/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.tile.networking;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FullnessMode;
import appeng.api.config.FuzzyMode;
import appeng.api.config.OperationMode;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.definitions.IItemDefinition;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import appeng.util.item.AEItemStack;
import com.google.common.base.Preconditions;
import dev.beecube31.crazyae2.common.containers.base.slot.RestrictedSlot;
import dev.beecube31.crazyae2.common.interfaces.upgrades.IUpgradesInfoProvider;
import dev.beecube31.crazyae2.common.parts.implementations.CrazyAEBlockUpgradeInv;
import dev.beecube31.crazyae2.common.registration.definitions.Upgrades;
import dev.beecube31.crazyae2.common.tile.base.CrazyAENetworkOCTile;
import dev.beecube31.crazyae2.common.util.inv.CrazyAEInternalInv;
import dev.beecube31.crazyae2.core.CrazyAE;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class TileBigCrystalCharger
extends CrazyAENetworkOCTile
implements IConfigManagerHost,
IUpgradesInfoProvider,
IAEAppEngInventory,
IGridTickable {
    private static final int NUMBER_OF_UPGRADE_SLOTS = 5;
    private final CrazyAEBlockUpgradeInv upgrades;
    private final IConfigManager manager;
    private final CrazyAEInternalInv inputInv;
    private final CrazyAEInternalInv outputInv;
    private int progressPerTick;
    private int progress;
    private int outputItemsPerJob;
    private boolean isPowered;
    private final IActionSource actionSource;

    public TileBigCrystalCharger() {
        this.inputInv = new CrazyAEInternalInv(this, 18, 64).setItemFilter(RestrictedSlot.PlaceableItemType.CERTUS_QUARTZ_CRYSTALS.associatedFilter);
        this.outputInv = new CrazyAEInternalInv(this, 18, 64).setItemFilter(RestrictedSlot.PlaceableItemType.CHARGED_CERTUS_QUARTZ_CRYSTALS.inputLockedFilter());
        this.progressPerTick = 1;
        this.progress = 0;
        this.outputItemsPerJob = 0;
        this.isPowered = false;
        this.actionSource = new MachineSource((IActionHost)this);
        Block charger = CrazyAE.definitions().blocks().bigCrystalCharger().maybeBlock().orElse(null);
        Preconditions.checkNotNull((Object)charger);
        this.getProxy().setIdlePowerUsage(16.0);
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
        this.getProxy().setVisualRepresentation(CrazyAE.definitions().blocks().bigCrystalCharger().maybeStack(1).orElse(ItemStack.field_190927_a));
        this.manager = new ConfigManager((IConfigManagerHost)this);
        this.manager.registerSetting(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
        this.manager.registerSetting(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL);
        this.manager.registerSetting(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
        this.manager.registerSetting(Settings.FULLNESS_MODE, (Enum)FullnessMode.EMPTY);
        this.manager.registerSetting(Settings.OPERATION_MODE, (Enum)OperationMode.EMPTY);
        this.upgrades = new CrazyAEBlockUpgradeInv(charger, this, 5);
    }

    public boolean canBeRotated() {
        return false;
    }

    @MENetworkEventSubscribe
    public void onPowerEvent(MENetworkPowerStatusChange p) {
        try {
            this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    protected boolean readFromStream(ByteBuf data) throws IOException {
        boolean c = super.readFromStream(data);
        boolean oldPower = this.isPowered;
        this.isPowered = data.readBoolean();
        return this.isPowered != oldPower || c;
    }

    protected void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        data.writeBoolean(this.isPowered);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        this.upgrades.writeToNBT(data, "upgrades");
        this.inputInv.writeToNBT(data, "acceleratorsInv");
        this.outputInv.writeToNBT(data, "storageInv");
        this.manager.writeToNBT(data);
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.upgrades.readFromNBT(data, "upgrades");
        this.inputInv.readFromNBT(data, "acceleratorsInv");
        this.outputInv.readFromNBT(data, "storageInv");
        this.manager.readFromNBT(data);
    }

    @NotNull
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.COVERED;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public IItemHandler getInventoryByName(String name) {
        AppEngInternalInventory appEngInternalInventory;
        switch (name) {
            case "input": {
                appEngInternalInventory = this.inputInv;
                break;
            }
            case "output": {
                appEngInternalInventory = this.outputInv;
                break;
            }
            case "upgrades": {
                appEngInternalInventory = this.upgrades;
                break;
            }
            default: {
                appEngInternalInventory = null;
            }
        }
        return appEngInternalInventory;
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (!(this.inputInv != inv || removed.func_190926_b() && added.func_190926_b())) {
            this.checkTasks();
        }
    }

    private void clearProgress() {
        this.progress = 0;
        this.progressPerTick = 0;
    }

    private void checkTasks() {
        try {
            if (this.hasWork()) {
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
            } else {
                this.clearProgress();
                this.getProxy().getTick().sleepDevice(this.getProxy().getNode());
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public void getDrops(World w, BlockPos pos, List<ItemStack> drops) {
        ItemStack is;
        super.getDrops(w, pos, drops);
        for (int upgradeIndex = 0; upgradeIndex < this.upgrades.getSlots(); ++upgradeIndex) {
            ItemStack stackInSlot = this.upgrades.getStackInSlot(upgradeIndex);
            if (stackInSlot.func_190926_b()) continue;
            drops.add(stackInSlot);
        }
        Iterator iterator = this.inputInv.iterator();
        while (iterator.hasNext()) {
            is = (ItemStack)iterator.next();
            if (is.func_190926_b()) continue;
            drops.add(is);
        }
        iterator = this.outputInv.iterator();
        while (iterator.hasNext()) {
            is = (ItemStack)iterator.next();
            if (is.func_190926_b()) continue;
            drops.add(is);
        }
    }

    public int getInstalledUpgrades(Upgrades u) {
        return this.upgrades.getInstalledUpgrades(u);
    }

    public int getInstalledCustomUpgrades(Upgrades.UpgradeType u) {
        return this.upgrades.getInstalledUpgrades(u);
    }

    public IConfigManager getConfigManager() {
        return this.manager;
    }

    @NotNull
    public TickingRequest getTickingRequest(@NotNull IGridNode iGridNode) {
        return new TickingRequest(1, 1, !this.hasWork(), false);
    }

    @NotNull
    public TickRateModulation tickingRequest(@NotNull IGridNode iGridNode, int i) {
        try {
            if (this.hasWork() && this.getProxy().getEnergy().extractAEPower(16.0, Actionable.MODULATE, PowerMultiplier.CONFIG) > 1.0E-4) {
                this.checkUpgrades();
                this.progress += this.progressPerTick;
                if (this.progress >= 100) {
                    this.progress = 0;
                    int itemsLeft = this.outputItemsPerJob;
                    for (int j = 0; j < this.inputInv.getSlots(); ++j) {
                        if (this.inputInv.getStackInSlot(j).func_190916_E() <= 0) continue;
                        if (!AEApi.instance().definitions().materials().certusQuartzCrystal().isSameAs(this.inputInv.getStackInSlot(j))) {
                            this.inputInv.setStackInSlot(j, ItemStack.field_190927_a);
                            continue;
                        }
                        int amt = Math.min(Math.min(itemsLeft, 64 - this.outputInv.getStackInSlot(j).func_190916_E()), this.inputInv.getStackInSlot(j).func_190916_E());
                        this.outputInv.insertItem(j, AEApi.instance().definitions().materials().certusQuartzCrystalCharged().maybeStack(amt).orElse(ItemStack.field_190927_a), false);
                        this.inputInv.extractItem(j, amt, false);
                        this.addCompletedOperations(amt);
                        if ((itemsLeft -= amt) <= 0) break;
                    }
                    this.pushOut();
                }
                return TickRateModulation.SAME;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return TickRateModulation.SLEEP;
    }

    private void pushOut() {
        if (!ItemHandlerUtil.isEmpty((IItemHandler)this.outputInv)) {
            try {
                IEnergyGrid grid = this.getProxy().getEnergy();
                IMEMonitor storage = ((IStorageGrid)this.getProxy().getGrid().getCache(IStorageGrid.class)).getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
                for (int j = 0; j < this.outputInv.getSlots(); ++j) {
                    if (this.outputInv.getStackInSlot(j).func_190916_E() <= 0) continue;
                    int amt = this.outputInv.getStackInSlot(j).func_190916_E();
                    AEItemStack copy = AEItemStack.fromItemStack((ItemStack)this.outputInv.getStackInSlot(j));
                    if (copy == null || Platform.poweredInsert((IEnergySource)grid, (IMEInventory)storage, (IAEStack)copy, (IActionSource)this.actionSource) == copy) continue;
                    this.outputInv.extractItem(j, amt, false);
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    private void checkUpgrades() {
        this.progressPerTick = 0;
        this.outputItemsPerJob = 0;
        switch (this.getInstalledCustomUpgrades(Upgrades.UpgradeType.IMPROVED_SPEED)) {
            case 1: {
                this.progressPerTick += 10;
                break;
            }
            case 2: {
                this.progressPerTick += 15;
                break;
            }
            case 3: {
                this.progressPerTick += 25;
                break;
            }
            case 4: {
                this.progressPerTick += 40;
                break;
            }
            case 5: {
                this.progressPerTick += 60;
            }
        }
        if (this.getInstalledCustomUpgrades(Upgrades.UpgradeType.ADVANCED_SPEED) > 0) {
            this.progressPerTick = 100;
        }
        switch (this.getInstalledCustomUpgrades(Upgrades.UpgradeType.STACKS)) {
            case 1: {
                this.outputItemsPerJob += 64;
                break;
            }
            case 2: {
                this.outputItemsPerJob += 192;
                break;
            }
            case 3: {
                this.outputItemsPerJob += 384;
                break;
            }
            case 4: {
                this.outputItemsPerJob += 768;
                break;
            }
            case 5: {
                this.outputItemsPerJob += 1152;
            }
        }
        if (this.outputItemsPerJob == 0) {
            this.outputItemsPerJob = 1;
        }
        if (this.progressPerTick == 0) {
            this.progressPerTick = 1;
        }
    }

    public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.inputInv);
        }
        return (T)super.getCapability(capability, facing);
    }

    public int getProgress() {
        return this.progress;
    }

    private boolean hasWork() {
        return !ItemHandlerUtil.isEmpty((IItemHandler)this.inputInv);
    }

    @Override
    public IItemDefinition getBlock() {
        return CrazyAE.definitions().blocks().bigCrystalCharger();
    }
}

