/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.tile.networking;

import appeng.api.config.Upgrades;
import appeng.api.definitions.IItemDefinition;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCraftingCpuChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.api.util.WorldCoord;
import appeng.me.GridAccessException;
import appeng.me.cluster.IAECluster;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.implementations.CraftingCPUCalculator;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.tile.crafting.TileCraftingTile;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import appeng.util.inv.WrapperChainedItemHandler;
import dev.beecube31.crazyae2.common.containers.base.slot.RestrictedSlot;
import dev.beecube31.crazyae2.common.interfaces.upgrades.IUpgradesInfoProvider;
import dev.beecube31.crazyae2.common.util.Utils;
import dev.beecube31.crazyae2.common.util.inv.CrazyAEInternalInv;
import dev.beecube31.crazyae2.core.CrazyAE;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class TileCraftingUnitsCombiner
extends TileCraftingTile
implements IConfigManagerHost,
IUpgradesInfoProvider,
IAEAppEngInventory,
IGridTickable {
    private CraftingCPUCluster cluster;
    private CraftingCPUCalculator calc = new CraftingCPUCalculator((IAEMultiBlock)this);
    private final CrazyAEInternalInv acceleratorsInv;
    private final CrazyAEInternalInv storageInv;
    private final IItemHandler combinedInv;
    private long storageAmt;
    private int acceleratorAmt;
    private int storageItemsAmt;
    private int acceleratorItemsAmt;
    private boolean isPowered;
    private boolean recalculate;

    public TileCraftingUnitsCombiner() {
        this.acceleratorsInv = new CrazyAEInternalInv(this, 12, 64).setItemFilter(RestrictedSlot.PlaceableItemType.CRAFTING_ACCELERATORS.associatedFilter);
        this.storageInv = new CrazyAEInternalInv(this, 12, 64).setItemFilter(RestrictedSlot.PlaceableItemType.CRAFTING_STORAGES.associatedFilter);
        this.combinedInv = new WrapperChainedItemHandler(new IItemHandler[]{this.acceleratorsInv, this.storageInv});
        this.storageAmt = 0L;
        this.acceleratorAmt = 0;
        this.storageItemsAmt = 0;
        this.acceleratorItemsAmt = 0;
        this.isPowered = false;
        this.recalculate = false;
        this.getProxy().setIdlePowerUsage(1024.0);
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
        this.getProxy().setVisualRepresentation(CrazyAE.definitions().blocks().craftingUnitsCombiner().maybeStack(1).orElse(ItemStack.field_190927_a));
    }

    public void setName(String name) {
        super.setName(name);
        if (this.cluster != null) {
            this.cluster.updateName();
        }
    }

    public boolean canBeRotated() {
        return false;
    }

    public IAECluster getCluster() {
        return this.cluster;
    }

    public void disconnect(boolean update) {
        if (this.cluster != null) {
            this.cluster.destroy();
        }
    }

    public void updateStatus(CraftingCPUCluster c) {
        if (this.cluster != null && this.cluster != c) {
            this.cluster.breakCluster();
        }
        this.cluster = c;
    }

    private void init() {
        this.calculateCrafting();
        this.updateMultiBlock();
        try {
            this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCraftingCpuChange(this.getProxy().getNode()));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public void onReady() {
        this.getProxy().onReady();
        this.init();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    public void updateMultiBlock() {
        if (Platform.isClient()) {
            return;
        }
        if (this.calc == null) {
            this.calc = new CraftingCPUCalculator((IAEMultiBlock)this);
        }
        IAECluster c = this.calc.createCluster(this.field_145850_b, (WorldCoord)this.getLocation(), (WorldCoord)this.getLocation());
        boolean updateGrid = false;
        CraftingCPUCluster cluster = this.cluster;
        if (cluster == null) {
            this.calc.updateTiles(c, this.field_145850_b, (WorldCoord)this.getLocation(), (WorldCoord)this.getLocation());
            updateGrid = true;
        } else {
            c = cluster;
        }
        c.updateStatus(updateGrid);
    }

    public boolean isAccelerator() {
        return false;
    }

    public long getStorageAmt() {
        return this.storageAmt;
    }

    public int getAcceleratorAmt() {
        return this.acceleratorAmt;
    }

    public boolean isCoreBlock() {
        return true;
    }

    protected boolean readFromStream(ByteBuf data) throws IOException {
        boolean c = super.readFromStream(data);
        boolean oldPower = this.isPowered;
        this.isPowered = data.readBoolean();
        return this.isPowered != oldPower || c;
    }

    protected void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        data.writeBoolean(this.isPowered);
    }

    public boolean isFormed() {
        return this.cluster != null;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        data.func_74757_a("core", this.isCoreBlock());
        if (this.isCoreBlock() && this.cluster != null) {
            this.cluster.writeToNBT(data);
        }
        this.acceleratorsInv.writeToNBT(data, "acceleratorsInv");
        this.storageInv.writeToNBT(data, "storageInv");
        return data;
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.setCoreBlock(data.func_74767_n("core"));
        if (this.isCoreBlock()) {
            if (this.cluster != null) {
                this.cluster.readFromNBT(data);
            } else {
                this.setPreviousState(data.func_74737_b());
            }
        }
        this.acceleratorsInv.readFromNBT(data, "acceleratorsInv");
        this.storageInv.readFromNBT(data, "storageInv");
    }

    @NotNull
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.COVERED;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public IItemHandler getInventoryByName(String name) {
        CrazyAEInternalInv crazyAEInternalInv;
        switch (name) {
            case "ainv": {
                crazyAEInternalInv = this.acceleratorsInv;
                break;
            }
            case "sinv": {
                crazyAEInternalInv = this.storageInv;
                break;
            }
            default: {
                crazyAEInternalInv = null;
            }
        }
        return crazyAEInternalInv;
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }

    public IItemHandler getAcceleratorsInv() {
        return this.acceleratorsInv;
    }

    public IItemHandler getStorageInv() {
        return this.storageInv;
    }

    public boolean isActive() {
        if (Platform.isServer()) {
            try {
                return this.getProxy().getEnergy().isNetworkPowered();
            }
            catch (GridAccessException e) {
                return false;
            }
        }
        return this.isPowered;
    }

    public void removeCluster() {
        this.cluster.cancel();
        this.calc.disconnect();
        this.breakCluster();
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (!(!this.getProxy().isReady() || removed.func_190926_b() && added.func_190926_b())) {
            this.recalculate = true;
        }
    }

    private void calculateCrafting() {
        int i;
        ItemStack item;
        this.storageAmt = 0L;
        this.acceleratorAmt = 0;
        this.storageItemsAmt = 0;
        this.acceleratorItemsAmt = 0;
        Iterator iterator = this.storageInv.iterator();
        while (iterator.hasNext()) {
            item = (ItemStack)iterator.next();
            if (item == null) continue;
            this.storageItemsAmt += item.func_190916_E();
            for (i = 0; i < item.func_190916_E(); ++i) {
                this.storageAmt += Math.min(Utils.getStorageCountOf(item), Long.MAX_VALUE - this.storageAmt);
            }
        }
        iterator = this.acceleratorsInv.iterator();
        while (iterator.hasNext()) {
            item = (ItemStack)iterator.next();
            if (item == null) continue;
            this.acceleratorItemsAmt += item.func_190916_E();
            for (i = 0; i < item.func_190916_E(); ++i) {
                this.acceleratorAmt += Math.min(Utils.getAcceleratorsCountOf(item), Integer.MAX_VALUE - this.acceleratorAmt);
            }
        }
    }

    public void getDrops(World w, BlockPos pos, List<ItemStack> drops) {
        ItemStack is;
        super.getDrops(w, pos, drops);
        Iterator iterator = this.acceleratorsInv.iterator();
        while (iterator.hasNext()) {
            is = (ItemStack)iterator.next();
            if (is.func_190926_b()) continue;
            drops.add(is);
        }
        iterator = this.storageInv.iterator();
        while (iterator.hasNext()) {
            is = (ItemStack)iterator.next();
            if (is.func_190926_b()) continue;
            drops.add(is);
        }
    }

    public int getInstalledUpgrades(Upgrades upgrades) {
        return 0;
    }

    public IConfigManager getConfigManager() {
        return null;
    }

    public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.combinedInv;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public IItemDefinition getBlock() {
        return CrazyAE.definitions().blocks().craftingUnitsCombiner();
    }

    @NotNull
    public TickingRequest getTickingRequest(@NotNull IGridNode iGridNode) {
        return new TickingRequest(1, 1, false, false);
    }

    @NotNull
    public TickRateModulation tickingRequest(@NotNull IGridNode iGridNode, int i) {
        if (this.recalculate) {
            this.removeCluster();
            this.calculateCrafting();
            this.updateMultiBlock();
            try {
                this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCraftingCpuChange(this.getProxy().getNode()));
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            this.recalculate = false;
        }
        return TickRateModulation.SAME;
    }
}

