/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.tile.networking;

import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridAccessException;
import appeng.tile.grid.AENetworkTile;
import appeng.util.Platform;
import dev.beecube31.crazyae2.common.interfaces.IChannelsMultiplier;
import dev.beecube31.crazyae2.core.cache.IGridChannelBoostersCache;
import dev.beecube31.crazyae2.core.config.CrazyAEConfig;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.EnumSet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class TileQuantumChannelsBooster
extends AENetworkTile
implements IPowerChannelState,
IChannelsMultiplier {
    public static final int POWERED_FLAG = 1;
    public static final int CHANNEL_FLAG = 2;
    private int clientFlags = 0;
    private boolean isRegistered = false;

    public TileQuantumChannelsBooster() {
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
        this.getProxy().setValidSides(EnumSet.noneOf(EnumFacing.class));
        this.getProxy().setIdlePowerUsage((double)(CrazyAEConfig.QCMBoostAmt * 256));
    }

    public void setOrientation(EnumFacing inForward, EnumFacing inUp) {
        super.setOrientation(inForward, inUp);
        this.getProxy().setValidSides(EnumSet.of(this.getForward().func_176734_d()));
    }

    @MENetworkEventSubscribe
    public void chanRender(MENetworkChannelsChanged c) {
        this.markForUpdate();
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.markForUpdate();
    }

    protected boolean readFromStream(ByteBuf data) throws IOException {
        boolean c = super.readFromStream(data);
        int old = this.getClientFlags();
        this.setClientFlags(data.readByte());
        return old != this.getClientFlags() || c;
    }

    protected void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        this.setClientFlags(0);
        try {
            if (this.getProxy().getEnergy().isNetworkPowered()) {
                this.setClientFlags(this.getClientFlags() | 1);
            }
            if (this.getProxy().getNode().meetsChannelRequirements()) {
                this.setClientFlags(this.getClientFlags() | 2);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        data.writeByte((int)((byte)this.getClientFlags()));
    }

    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public void onReady() {
        super.onReady();
    }

    public void saveChanges() {
        super.saveChanges();
    }

    public boolean isActive() {
        if (Platform.isClient()) {
            return this.isPowered() && 2 == (this.getClientFlags() & 2);
        }
        if (!this.isRegistered) {
            try {
                ((IGridChannelBoostersCache)this.getProxy().getGrid().getCache(IGridChannelBoostersCache.class)).addNode(this.getProxy().getNode(), this.getProxy().getMachine());
                this.isRegistered = true;
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return this.getProxy().isActive();
    }

    public void removeBoost() {
        if (this.isRegistered) {
            try {
                ((IGridChannelBoostersCache)this.getProxy().getGrid().getCache(IGridChannelBoostersCache.class)).removeNode(this.getProxy().getNode(), this.getProxy().getMachine());
                this.isRegistered = true;
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    public boolean isPowered() {
        return 1 == (this.getClientFlags() & 1);
    }

    public int getClientFlags() {
        return this.clientFlags;
    }

    private void setClientFlags(int clientFlags) {
        this.clientFlags = clientFlags;
    }

    @Override
    public boolean isCreative() {
        return false;
    }
}

