/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.tile.solars;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkPowerStorage;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridAccessException;
import appeng.tile.grid.AENetworkTile;
import appeng.util.SettingsFrom;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.block.material.MapColor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import org.jetbrains.annotations.NotNull;

public abstract class TileEnergyPanelBase
extends AENetworkTile
implements IGridTickable,
IAEPowerStorage {
    public double internalCurrentEnergy;
    private boolean isVisible;

    public TileEnergyPanelBase() {
        this.getProxy().setIdlePowerUsage(0.0);
        this.getProxy().setFlags(new GridFlags[0]);
    }

    protected abstract double getPowerPerTick();

    protected abstract double getPowerPerTickAtNight();

    protected abstract double getCapacity();

    public double injectAEPower(double v, @NotNull Actionable actionable) {
        return 0.0;
    }

    public double getAEMaxPower() {
        return this.getCapacity();
    }

    public double getAECurrentPower() {
        return this.internalCurrentEnergy;
    }

    public boolean isAEPublicPowerStorage() {
        return true;
    }

    @NotNull
    public AccessRestriction getPowerFlow() {
        return AccessRestriction.READ;
    }

    public double extractAEPower(double v, @NotNull Actionable mode, @NotNull PowerMultiplier pm) {
        return pm.divide(this.extractAEPower(pm.multiply(v), mode));
    }

    public double extractAEPower(double v, @NotNull Actionable mode) {
        boolean wasFull;
        if (mode == Actionable.SIMULATE) {
            return Math.min(this.internalCurrentEnergy, v);
        }
        boolean bl = wasFull = this.internalCurrentEnergy >= this.getCapacity() - 0.001;
        if (wasFull && v > 0.0) {
            try {
                this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkPowerStorage((IAEPowerStorage)this, MENetworkPowerStorage.PowerEventType.REQUEST_POWER));
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        if (this.internalCurrentEnergy > v) {
            this.internalCurrentEnergy -= v;
            return v;
        }
        v = this.internalCurrentEnergy;
        this.internalCurrentEnergy = 0.0;
        return v;
    }

    public void uploadSettings(SettingsFrom from, NBTTagCompound compound, EntityPlayer player) {
        if (from == SettingsFrom.DISMANTLE_ITEM) {
            this.internalCurrentEnergy = compound.func_74769_h("internalCurrentEnergy");
        }
    }

    public boolean canBeRotated() {
        return false;
    }

    public NBTTagCompound downloadSettings(SettingsFrom from) {
        if (from == SettingsFrom.DISMANTLE_ITEM) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74780_a("internalCurrentEnergy", this.internalCurrentEnergy);
            tag.func_74780_a("internalMaxPower", this.getCapacity());
            return tag;
        }
        return null;
    }

    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.COVERED;
    }

    protected boolean readFromStream(ByteBuf data) throws IOException {
        super.readFromStream(data);
        return true;
    }

    protected void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        data.func_74780_a("internalCurrentEnergy", this.internalCurrentEnergy);
        return data;
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.internalCurrentEnergy = data.func_74769_h("internalCurrentEnergy");
    }

    public void onReady() {
        super.onReady();
        this.updateVisibility();
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 1, false, false);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.func_145831_w().field_73011_w.getWorldTime() % 100L == 0L) {
            this.updateVisibility();
        }
        if (this.isVisible) {
            this.makeEnergy();
        }
        this.sendEnergy();
        return TickRateModulation.SAME;
    }

    private void updateVisibility() {
        this.isVisible = !this.field_145850_b.field_73011_w.func_177495_o() && this.field_145850_b.func_175710_j(this.field_174879_c.func_177984_a()) && this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_185904_a().func_151565_r() == MapColor.field_151660_b;
    }

    public void makeEnergy() {
        this.internalCurrentEnergy = this.field_145850_b.func_72935_r() ? (this.internalCurrentEnergy += Math.min(this.getPowerPerTick(), this.getCapacity() - this.internalCurrentEnergy)) : (this.internalCurrentEnergy += Math.min(this.getPowerPerTickAtNight(), this.getCapacity() - this.internalCurrentEnergy));
    }

    public void sendEnergy() {
        try {
            IEnergyGrid grid = this.getProxy().getEnergy();
            double overFlow = grid.injectPower(this.internalCurrentEnergy, Actionable.SIMULATE);
            grid.injectPower(Math.max(0.0, this.internalCurrentEnergy - overFlow), Actionable.MODULATE);
            this.internalCurrentEnergy = overFlow;
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }
}

