/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.tile.storage;

import appeng.api.AEApi;
import appeng.api.implementations.tiles.IChestOrDrive;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellHandler;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.core.sync.GuiBridge;
import appeng.helpers.IPriorityHost;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngCellInventory;
import appeng.util.Platform;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import appeng.util.inv.filter.IAEItemFilter;
import dev.beecube31.crazyae2.common.interfaces.gui.IPriHostGuiOverrider;
import dev.beecube31.crazyae2.common.sync.CrazyAEGuiBridge;
import dev.beecube31.crazyae2.common.util.DriveWatcherImproved;
import dev.beecube31.crazyae2.core.CrazyAE;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandler;

public class TileImprovedDrive
extends AENetworkInvTile
implements IChestOrDrive,
IPriorityHost,
IPriHostGuiOverrider {
    private static final int CELL_COUNT = 35;
    private static final int BITS_PER_CELL = 3;
    private static final int CELLS_PER_INT = 10;
    private final AppEngCellInventory inv = new AppEngCellInventory((IAEAppEngInventory)this, 35);
    private final ICellHandler[] handlersBySlot = new ICellHandler[35];
    private final DriveWatcherImproved<IAEItemStack>[] invBySlot = new DriveWatcherImproved[35];
    private final IActionSource mySrc;
    private boolean isCached = false;
    private final Map<IStorageChannel<? extends IAEStack<?>>, List<IMEInventoryHandler>> inventoryHandlers;
    private int priority = 0;
    private boolean wasActive = false;
    private final int[] cellState = new int[(int)Math.ceil(3.5)];
    private boolean powered;
    private int blinking;

    public TileImprovedDrive() {
        this.mySrc = new MachineSource((IActionHost)this);
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
        this.inv.setFilter((IAEItemFilter)new CellValidInventoryFilter());
        this.inventoryHandlers = new IdentityHashMap();
    }

    protected void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        for (int state : this.cellState) {
            data.writeInt(state);
        }
        data.writeBoolean(this.getProxy().isActive());
        data.writeInt(this.blinking);
    }

    protected boolean readFromStream(ByteBuf data) throws IOException {
        boolean c = super.readFromStream(data);
        int[] oldCellState = Arrays.copyOf(this.cellState, this.cellState.length);
        boolean oldPowered = this.powered;
        int oldBlinking = this.blinking;
        for (int i = 0; i < this.cellState.length; ++i) {
            this.cellState[i] = data.readInt();
        }
        this.powered = data.readBoolean();
        this.blinking = data.readInt();
        return !Arrays.equals(oldCellState, this.cellState) || oldPowered != this.powered || oldBlinking != this.blinking || c;
    }

    public int getCellCount() {
        return 35;
    }

    public int getCellStatus(int slot) {
        if (Platform.isClient()) {
            int arrayIndex = slot / 10;
            int bitOffset = slot % 10 * 3;
            return this.cellState[arrayIndex] >> bitOffset & 7;
        }
        DriveWatcherImproved<IAEItemStack> handler = this.invBySlot[slot];
        if (handler == null) {
            return 0;
        }
        return handler.getStatus();
    }

    public boolean isPowered() {
        if (Platform.isClient()) {
            return this.powered;
        }
        return this.getProxy().isActive();
    }

    public boolean isCellBlinking(int slot) {
        return (this.blinking & 1 << slot) == 1;
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.isCached = false;
        this.priority = data.func_74762_e("priority");
        if (data.func_74764_b("cellState")) {
            int[] loadedCellState = data.func_74759_k("cellState");
            System.arraycopy(loadedCellState, 0, this.cellState, 0, Math.min(loadedCellState.length, this.cellState.length));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        data.func_74768_a("priority", this.priority);
        data.func_74783_a("cellState", this.cellState);
        return data;
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.recalculateDisplay();
    }

    private void recalculateDisplay() {
        boolean currentActive = this.getProxy().isActive();
        int[] oldCellState = Arrays.copyOf(this.cellState, this.cellState.length);
        boolean oldPowered = this.powered;
        this.powered = currentActive;
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            try {
                this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        for (int x = 0; x < this.getCellCount(); ++x) {
            int arrayIndex = x / 10;
            int bitOffset = x % 10 * 3;
            int status = this.getCellStatus(x);
            int mask = ~(7 << bitOffset);
            int n = arrayIndex;
            this.cellState[n] = this.cellState[n] & mask;
            int n2 = arrayIndex;
            this.cellState[n2] = this.cellState[n2] | status << bitOffset;
        }
        if (!Arrays.equals(oldCellState, this.cellState) || oldPowered != this.powered) {
            this.markForUpdate();
        }
    }

    @MENetworkEventSubscribe
    public void channelRender(MENetworkChannelsChanged c) {
        this.recalculateDisplay();
    }

    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public IItemHandler getInternalInventory() {
        return this.inv;
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (this.isCached) {
            this.isCached = false;
            this.updateState();
            this.recalculateDisplay();
        }
        try {
            if (this.getProxy().isActive()) {
                IStorageGrid gs = this.getProxy().getStorage();
                Platform.postChanges((IStorageGrid)gs, (ItemStack)removed, (ItemStack)added, (IActionSource)this.mySrc);
            }
            this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        this.markForUpdate();
    }

    private void updateState() {
        if (!this.isCached) {
            Collection storageChannels = AEApi.instance().storage().storageChannels();
            storageChannels.forEach(channel -> this.inventoryHandlers.put((IStorageChannel<IAEStack<?>>)channel, new ArrayList(35)));
            double power = 2.0;
            block0: for (int x = 0; x < this.inv.getSlots(); ++x) {
                ItemStack is = this.inv.getStackInSlot(x);
                this.invBySlot[x] = null;
                this.handlersBySlot[x] = null;
                if (is.func_190926_b()) continue;
                this.handlersBySlot[x] = AEApi.instance().registries().cell().getHandler(is);
                if (this.handlersBySlot[x] == null) continue;
                for (IStorageChannel channel2 : storageChannels) {
                    ICellInventoryHandler cell = this.handlersBySlot[x].getCellInventory(is, (ISaveProvider)this, channel2);
                    if (cell == null) continue;
                    this.inv.setHandler(x, cell);
                    power += this.handlersBySlot[x].cellIdleDrain(is, cell);
                    DriveWatcherImproved ih = new DriveWatcherImproved(cell, is, this.handlersBySlot[x], this);
                    ih.setPriority(this.priority);
                    this.invBySlot[x] = ih;
                    this.inventoryHandlers.get(channel2).add((IMEInventoryHandler)ih);
                    continue block0;
                }
            }
            this.getProxy().setIdlePowerUsage(power);
            this.isCached = true;
        }
    }

    public void onReady() {
        super.onReady();
        this.updateState();
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel channel) {
        this.updateState();
        return this.inventoryHandlers.get(channel);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int newValue) {
        this.priority = newValue;
        this.saveChanges();
        this.isCached = false;
        this.updateState();
        try {
            this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public void blinkCell(int slot) {
        this.blinking |= 1 << slot;
        this.recalculateDisplay();
    }

    public void saveChanges(ICellInventory<?> cellInventory) {
        this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
    }

    public ItemStack getItemStackRepresentation() {
        return CrazyAE.definitions().blocks().improvedDrive().maybeStack(1).orElse(ItemStack.field_190927_a);
    }

    public GuiBridge getGuiBridge() {
        return GuiBridge.GUI_Handler;
    }

    @Override
    public CrazyAEGuiBridge getOverrideGui() {
        return CrazyAEGuiBridge.IMPROVED_DRIVE;
    }

    private static class CellValidInventoryFilter
    implements IAEItemFilter {
        private CellValidInventoryFilter() {
        }

        public boolean allowExtract(IItemHandler inv, int slot, int amount) {
            return true;
        }

        public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
            return !stack.func_190926_b() && AEApi.instance().registries().cell().isCellHandled(stack);
        }
    }
}

