/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.tile.trashcans;

import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.definitions.IItemDefinition;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import appeng.util.inv.InvOperation;
import dev.beecube31.crazyae2.common.interfaces.upgrades.IUpgradesInfoProvider;
import dev.beecube31.crazyae2.common.tile.base.CrazyAENetworkInvOCTile;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class TileTrashcanBase
extends CrazyAENetworkInvOCTile
implements IUpgradesInfoProvider,
IConfigManagerHost,
IGridTickable {
    protected final IActionSource src = new MachineSource((IActionHost)this);
    protected final ConfigManager manager = new ConfigManager((IConfigManagerHost)this);
    protected boolean isActive = false;
    protected int itemsToSendPerTick = 32;

    public TileTrashcanBase() {
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
        this.getProxy().setIdlePowerUsage(4.0);
        this.getConfigManager().registerSetting(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.CRAFT_ONLY, (Enum)YesNo.NO);
    }

    public abstract void onChangeInventory(IItemHandler var1, int var2, InvOperation var3, ItemStack var4, ItemStack var5);

    protected boolean readFromStream(ByteBuf data) throws IOException {
        boolean c = super.readFromStream(data);
        boolean oldIsActive = this.isActive;
        this.isActive = data.readBoolean();
        return oldIsActive != this.isActive || c;
    }

    protected void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        data.writeBoolean(this.isActive());
    }

    public boolean isActive() {
        if (Platform.isServer()) {
            try {
                return this.getProxy().getEnergy().isNetworkPowered();
            }
            catch (GridAccessException e) {
                return false;
            }
        }
        return this.isActive;
    }

    @NotNull
    public AECableType getCableConnectionType(@NotNull AEPartLocation dir) {
        return AECableType.SMART;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public IConfigManager getConfigManager() {
        return this.manager;
    }

    @Override
    public abstract IItemDefinition getBlock();

    public abstract IItemHandler getInventoryByName(String var1);

    @NotNull
    public abstract IItemHandler getInternalInventory();

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }

    public void getDrops(World w, BlockPos pos, List<ItemStack> drops) {
    }

    @NotNull
    public TickingRequest getTickingRequest(@NotNull IGridNode node) {
        return new TickingRequest(1, 5, false, false);
    }

    @NotNull
    public abstract TickRateModulation tickingRequest(@NotNull IGridNode var1, int var2);
}

