/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.tile.trashcans;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.Upgrades;
import appeng.api.definitions.IItemDefinition;
import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.util.Platform;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import dev.beecube31.crazyae2.common.parts.implementations.CrazyAEBlockUpgradeInv;
import dev.beecube31.crazyae2.common.registration.definitions.Upgrades;
import dev.beecube31.crazyae2.common.tile.trashcans.TileTrashcanBase;
import dev.beecube31.crazyae2.common.util.AEUtils;
import dev.beecube31.crazyae2.common.util.Utils;
import dev.beecube31.crazyae2.common.util.inv.CrazyAEInternalAEInv;
import dev.beecube31.crazyae2.core.CrazyAE;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class TileTrashcanEnergy
extends TileTrashcanBase {
    private final CrazyAEBlockUpgradeInv upgrades = new CrazyAEBlockUpgradeInv(CrazyAE.definitions().blocks().trashcanItem().maybeBlock().orElse(null), (IAEAppEngInventory)this, 4);
    private final CrazyAEInternalAEInv inv = new CrazyAEInternalAEInv((IAEAppEngInventory)this, 72, 1);

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (inv == this.upgrades) {
            this.checkUpgrades();
        }
        if (inv != this.inv && Utils.getItemEnergyType(this.inv.getStackInSlot(slot)) == null) {
            this.inv.setStackInSlot(slot, ItemStack.field_190927_a);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        if (this.inv != null) {
            this.inv.writeToNBT(data, "inv");
        }
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (this.inv != null) {
            this.inv.readFromNBT(data, "inv");
        }
    }

    @Override
    public void getDrops(World w, BlockPos pos, List<ItemStack> drops) {
        super.getDrops(w, pos, drops);
        for (int upgradeIndex = 0; upgradeIndex < this.upgrades.getSlots(); ++upgradeIndex) {
            ItemStack stackInSlot = this.upgrades.getStackInSlot(upgradeIndex);
            if (stackInSlot.func_190926_b()) continue;
            drops.add(stackInSlot);
        }
    }

    public int getInstalledUpgrades(Upgrades u) {
        return this.upgrades.getInstalledUpgrades(u);
    }

    public int getInstalledCustomUpgrades(Upgrades.UpgradeType u) {
        return this.upgrades.getInstalledUpgrades(u);
    }

    protected void checkUpgrades() {
        switch (this.getInstalledCustomUpgrades(Upgrades.UpgradeType.STACKS)) {
            default: {
                this.itemsToSendPerTick = 32;
                break;
            }
            case 1: {
                this.itemsToSendPerTick = 2048;
                break;
            }
            case 2: {
                this.itemsToSendPerTick = 16384;
                break;
            }
            case 3: {
                this.itemsToSendPerTick = 65536;
                break;
            }
            case 4: {
                this.itemsToSendPerTick = 262144;
            }
        }
    }

    public void onReady() {
        super.onReady();
        if (Platform.isServer()) {
            this.checkUpgrades();
        }
    }

    @Override
    public IItemDefinition getBlock() {
        return CrazyAE.definitions().blocks().trashcanEnergy();
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        switch (name) {
            case "inv": {
                return this.inv;
            }
            case "upgrades": {
                return this.upgrades;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public IItemHandler getInternalInventory() {
        return this.inv;
    }

    @Override
    @NotNull
    public TickRateModulation tickingRequest(@NotNull IGridNode node, int ticksSinceLastCall) {
        if (!this.getProxy().isActive()) {
            return TickRateModulation.IDLE;
        }
        boolean worked = false;
        try {
            IMEMonitor inv = this.getProxy().getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
            for (IAEItemStack candidate : this.inv) {
                IAEItemStack ais;
                IAEItemStack o;
                if (candidate == null || (o = (IAEItemStack)inv.getStorageList().findPrecise((IAEStack)candidate)) == null || o.getStackSize() <= 0L || (ais = AEUtils.extractFromME(inv, (IAEItemStack)o.setStackSize((long)this.itemsToSendPerTick), this.src, Actionable.MODULATE)).getStackSize() >= Long.MAX_VALUE) continue;
                worked = true;
            }
        }
        catch (Throwable ignored) {
            return TickRateModulation.IDLE;
        }
        return worked ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
    }
}

