/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.tile.trashcans;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.Upgrades;
import appeng.api.definitions.IItemDefinition;
import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.fluids.util.IAEFluidTank;
import appeng.me.GridAccessException;
import appeng.util.Platform;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import dev.beecube31.crazyae2.common.parts.implementations.CrazyAEBlockUpgradeInv;
import dev.beecube31.crazyae2.common.registration.definitions.Upgrades;
import dev.beecube31.crazyae2.common.tile.trashcans.TileTrashcanBase;
import dev.beecube31.crazyae2.common.util.inv.CrazyAEInternalFluidInv;
import dev.beecube31.crazyae2.core.CrazyAE;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class TileTrashcanFluids
extends TileTrashcanBase {
    private final CrazyAEBlockUpgradeInv upgrades;
    private final CrazyAEInternalFluidInv fluidInv = new CrazyAEInternalFluidInv(null, 72, 65536);

    public TileTrashcanFluids() {
        this.upgrades = new CrazyAEBlockUpgradeInv(CrazyAE.definitions().blocks().trashcanItem().maybeBlock().orElse(null), (IAEAppEngInventory)this, 4);
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (inv == this.upgrades) {
            this.checkUpgrades();
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        if (this.fluidInv != null) {
            this.fluidInv.writeToNBT(data, "inv");
        }
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (data.func_74764_b("inv")) {
            this.fluidInv.readFromNBT(data, "inv");
        }
    }

    @Override
    public void getDrops(World w, BlockPos pos, List<ItemStack> drops) {
        super.getDrops(w, pos, drops);
        for (int upgradeIndex = 0; upgradeIndex < this.upgrades.getSlots(); ++upgradeIndex) {
            ItemStack stackInSlot = this.upgrades.getStackInSlot(upgradeIndex);
            if (stackInSlot.func_190926_b()) continue;
            drops.add(stackInSlot);
        }
    }

    public int getInstalledUpgrades(Upgrades u) {
        return this.upgrades.getInstalledUpgrades(u);
    }

    public int getInstalledCustomUpgrades(Upgrades.UpgradeType u) {
        return this.upgrades.getInstalledUpgrades(u);
    }

    protected void checkUpgrades() {
        switch (this.getInstalledCustomUpgrades(Upgrades.UpgradeType.STACKS)) {
            default: {
                this.itemsToSendPerTick = 32768;
                break;
            }
            case 1: {
                this.itemsToSendPerTick = 0x200000;
                break;
            }
            case 2: {
                this.itemsToSendPerTick = 0x1000000;
                break;
            }
            case 3: {
                this.itemsToSendPerTick = 0x4000000;
                break;
            }
            case 4: {
                this.itemsToSendPerTick = 0x10000000;
            }
        }
    }

    public void onReady() {
        super.onReady();
        if (Platform.isServer()) {
            this.checkUpgrades();
        }
    }

    @Override
    public IItemDefinition getBlock() {
        return CrazyAE.definitions().blocks().trashcanFluid();
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        if (name.equals("upgrades")) {
            return this.upgrades;
        }
        return null;
    }

    @Override
    @NotNull
    public IItemHandler getInternalInventory() {
        return this.upgrades;
    }

    public IAEFluidTank getConfig() {
        return this.fluidInv;
    }

    @Override
    @NotNull
    public TickRateModulation tickingRequest(@NotNull IGridNode node, int ticksSinceLastCall) {
        if (!this.getProxy().isActive()) {
            return TickRateModulation.IDLE;
        }
        boolean worked = false;
        try {
            IFluidStorageChannel channel = (IFluidStorageChannel)AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class);
            IMEMonitor inv = this.getProxy().getStorage().getInventory((IStorageChannel)channel);
            for (IAEFluidStack filterStack : this.fluidInv) {
                IAEFluidStack modulated;
                if (filterStack == null) continue;
                IAEFluidStack toExtract = filterStack.copy();
                toExtract.setStackSize((long)this.itemsToSendPerTick);
                IAEFluidStack simulated = (IAEFluidStack)inv.extractItems((IAEStack)toExtract, Actionable.SIMULATE, this.src);
                if (simulated == null || simulated.getStackSize() <= 0L || (modulated = (IAEFluidStack)inv.extractItems((IAEStack)simulated, Actionable.MODULATE, this.src)) == null || modulated.getStackSize() <= 0L) continue;
                worked = true;
            }
        }
        catch (GridAccessException e) {
            return TickRateModulation.IDLE;
        }
        return worked ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
    }
}

