/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.util;

import appeng.api.config.Actionable;
import appeng.api.definitions.IItemDefinition;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.core.stats.Stats;
import appeng.util.item.AEItemStack;
import com.google.common.base.Preconditions;
import net.minecraft.item.ItemStack;

public class AEUtils {
    public static IAEItemStack createAEStackFromItemstack(ItemStack is, long amt) {
        Preconditions.checkNotNull((Object)is);
        if (amt < 0L) {
            return null;
        }
        return !is.func_190926_b() ? (IAEItemStack)AEItemStack.fromItemStack((ItemStack)is).setStackSize(amt) : null;
    }

    public static IAEItemStack createAEStackFromDefinition(IItemDefinition is, long amt) {
        Preconditions.checkNotNull((Object)is);
        if (amt < 0L) {
            return null;
        }
        ItemStack out = is.maybeStack(1).orElse(ItemStack.field_190927_a);
        return !out.func_190926_b() ? (IAEItemStack)AEItemStack.fromItemStack((ItemStack)out).setStackSize(amt) : null;
    }

    public static <T extends IAEStack<T>> T extractFromME(IMEInventory<T> cell, T request, IActionSource src, Actionable mode) {
        if (cell == null) {
            return null;
        }
        if (request == null) {
            return null;
        }
        if (src == null) {
            return null;
        }
        if (mode == null) {
            return null;
        }
        IAEStack possible = cell.extractItems(request.copy(), Actionable.SIMULATE, src);
        long retrieved = 0L;
        if (possible != null) {
            retrieved = possible.getStackSize();
        }
        if (retrieved > 0L) {
            if (mode == Actionable.MODULATE) {
                possible.setStackSize(retrieved);
                IAEStack ret = cell.extractItems(possible, Actionable.MODULATE, src);
                if (ret != null) {
                    src.player().ifPresent(player -> Stats.ItemsExtracted.addToPlayer(player, (int)ret.getStackSize()));
                }
                return (T)ret;
            }
            return (T)possible.setStackSize(retrieved);
        }
        return null;
    }

    public static <T extends IAEStack<T>> T injectToME(IMEInventory<T> cell, T input, IActionSource src, Actionable mode) {
        if (cell == null) {
            return input;
        }
        if (input == null) {
            return null;
        }
        if (src == null) {
            return input;
        }
        if (mode == null) {
            return input;
        }
        IAEStack possible = cell.injectItems(input, Actionable.SIMULATE, src);
        long stored = input.getStackSize();
        if (possible != null) {
            stored -= possible.getStackSize();
        }
        if (stored > 0L) {
            if (mode == Actionable.MODULATE) {
                if (stored < input.getStackSize()) {
                    long original = input.getStackSize();
                    IAEStack leftover = input.copy();
                    IAEStack split = input.copy();
                    leftover.decStackSize(stored);
                    split.setStackSize(stored);
                    leftover.add(cell.injectItems(split, Actionable.MODULATE, src));
                    src.player().ifPresent(player -> {
                        long diff = original - leftover.getStackSize();
                        Stats.ItemsInserted.addToPlayer(player, (int)diff);
                    });
                    return (T)leftover;
                }
                IAEStack ret = cell.injectItems(input, Actionable.MODULATE, src);
                src.player().ifPresent(player -> {
                    long diff = ret == null ? input.getStackSize() : input.getStackSize() - ret.getStackSize();
                    Stats.ItemsInserted.addToPlayer(player, (int)diff);
                });
                return (T)ret;
            }
            IAEStack ret = input.copy().setStackSize(input.getStackSize() - stored);
            return (T)(ret != null && ret.getStackSize() > 0L ? ret : null);
        }
        return input;
    }
}

