/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.util;

import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.DimensionalCoord;
import appeng.helpers.ItemStackHelper;
import appeng.util.item.AEItemStack;
import dev.beecube31.crazyae2.common.tile.botania.TileBotaniaMechanicalMachineBase;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class NBTUtils {
    public static NBTTagCompound openNbtDataNullable(ItemStack i) {
        NBTTagCompound compound = i.func_77978_p();
        i.func_77982_d(compound);
        return compound;
    }

    public static NBTTagCompound writeDimensionalCoord(@Nullable DimensionalCoord coord) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (coord != null) {
            nbt.func_74768_a("x", coord.x);
            nbt.func_74768_a("y", coord.y);
            nbt.func_74768_a("z", coord.z);
            if (coord.getWorld() != null) {
                nbt.func_74768_a("dim", coord.getWorld().field_73011_w.getDimension());
            }
        }
        return nbt;
    }

    public static DimensionalCoord readDimensionalCoord(@Nullable NBTTagCompound nbt) {
        if (!(nbt != null && nbt.func_150297_b("x", 3) && nbt.func_150297_b("y", 3) && nbt.func_150297_b("z", 3) && nbt.func_150297_b("dim", 3))) {
            return null;
        }
        int dimId = nbt.func_74762_e("dim");
        WorldServer world = DimensionManager.getWorld((int)dimId);
        if (world == null) {
            return null;
        }
        int x = nbt.func_74762_e("x");
        int y = nbt.func_74762_e("y");
        int z = nbt.func_74762_e("z");
        return new DimensionalCoord((World)world, x, y, z);
    }

    public static NBTBase createItemTag(ItemStack i) {
        NBTTagCompound c = new NBTTagCompound();
        if (!i.func_190926_b()) {
            ItemStackHelper.stackWriteToNBT((ItemStack)i, (NBTTagCompound)c);
        }
        return c;
    }

    public static void writeQueueMapToNBT(List<? extends TileBotaniaMechanicalMachineBase.CraftingTask> queueMap, NBTTagCompound data, String tagName) {
        NBTTagList list = new NBTTagList();
        for (TileBotaniaMechanicalMachineBase.CraftingTask craftingTask : queueMap) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("progressAmt", craftingTask.getProgress());
            String taskType = NBTUtils.getTaskType(craftingTask, tag);
            tag.func_74778_a("taskType", taskType);
            NBTTagList inputsTag = new NBTTagList();
            for (IAEItemStack input : craftingTask.getTaskItems()) {
                if (input == null) continue;
                NBTTagCompound itemTag = new NBTTagCompound();
                ItemStackHelper.stackWriteToNBT((ItemStack)input.asItemStackRepresentation(), (NBTTagCompound)itemTag);
                inputsTag.func_74742_a((NBTBase)itemTag);
            }
            tag.func_74782_a("inputs", (NBTBase)inputsTag);
            list.func_74742_a((NBTBase)tag);
        }
        data.func_74782_a(tagName, (NBTBase)list);
    }

    private static String getTaskType(TileBotaniaMechanicalMachineBase.CraftingTask details, NBTTagCompound nbt) {
        if (details instanceof TileBotaniaMechanicalMachineBase.ManaCraftingTask) {
            TileBotaniaMechanicalMachineBase.ManaCraftingTask k = (TileBotaniaMechanicalMachineBase.ManaCraftingTask)details;
            nbt.func_74768_a("manaReq", k.getRequiredMana());
            return "manapool";
        }
        if (details instanceof TileBotaniaMechanicalMachineBase.PureDaisyCraftingTask) {
            TileBotaniaMechanicalMachineBase.PureDaisyCraftingTask k = (TileBotaniaMechanicalMachineBase.PureDaisyCraftingTask)details;
            nbt.func_74757_a("reqBucket", k.requireOutputBucket());
            return "puredaisy";
        }
        if (details instanceof TileBotaniaMechanicalMachineBase.RuneAltarCraftingTask) {
            TileBotaniaMechanicalMachineBase.RuneAltarCraftingTask k = (TileBotaniaMechanicalMachineBase.RuneAltarCraftingTask)details;
            nbt.func_74768_a("manaReq", k.getRequiredMana());
            return "runealtar";
        }
        if (details instanceof TileBotaniaMechanicalMachineBase.TeraplateCraftingTask) {
            TileBotaniaMechanicalMachineBase.TeraplateCraftingTask k = (TileBotaniaMechanicalMachineBase.TeraplateCraftingTask)details;
            nbt.func_74768_a("manaReq", k.getRequiredMana());
            return "teraplate";
        }
        if (details instanceof TileBotaniaMechanicalMachineBase.BreweryCraftingTask) {
            TileBotaniaMechanicalMachineBase.BreweryCraftingTask k = (TileBotaniaMechanicalMachineBase.BreweryCraftingTask)details;
            nbt.func_74768_a("manaReq", k.getRequiredMana());
            return "brewery";
        }
        if (details instanceof TileBotaniaMechanicalMachineBase.CraftingTask) {
            return "default";
        }
        throw new IllegalArgumentException("Invalid CraftingTask provided");
    }

    public static List<TileBotaniaMechanicalMachineBase.CraftingTask> readQueueMapFromNBT(NBTTagCompound data, String tagName) {
        ArrayList<TileBotaniaMechanicalMachineBase.CraftingTask> queueMap = new ArrayList<TileBotaniaMechanicalMachineBase.CraftingTask>();
        if (data.func_150297_b(tagName, 9)) {
            NBTTagList list = data.func_150295_c(tagName, 10);
            block14: for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                int progressAmt = tag.func_74762_e("progressAmt");
                String taskType = tag.func_74779_i("taskType");
                NBTTagList inputsTag = tag.func_150295_c("inputs", 10);
                IAEItemStack[] inputs = new IAEItemStack[inputsTag.func_74745_c()];
                for (int j = 0; j < inputsTag.func_74745_c(); ++j) {
                    ItemStack itemStack = ItemStackHelper.stackFromNBT((NBTTagCompound)inputsTag.func_150305_b(j));
                    inputs[j] = AEItemStack.fromItemStack((ItemStack)itemStack);
                }
                switch (taskType) {
                    case "manapool": {
                        TileBotaniaMechanicalMachineBase.CraftingTask task = new TileBotaniaMechanicalMachineBase.ManaCraftingTask(inputs, progressAmt, tag.func_74762_e("manaReq"));
                        queueMap.add(task);
                        continue block14;
                    }
                    case "puredaisy": {
                        TileBotaniaMechanicalMachineBase.CraftingTask task = new TileBotaniaMechanicalMachineBase.PureDaisyCraftingTask(inputs, progressAmt, tag.func_74767_n("reqBucket"));
                        queueMap.add(task);
                        continue block14;
                    }
                    case "runealtar": {
                        TileBotaniaMechanicalMachineBase.CraftingTask task = new TileBotaniaMechanicalMachineBase.RuneAltarCraftingTask(inputs, progressAmt, tag.func_74762_e("manaReq"));
                        queueMap.add(task);
                        continue block14;
                    }
                    case "teraplate": {
                        TileBotaniaMechanicalMachineBase.CraftingTask task = new TileBotaniaMechanicalMachineBase.TeraplateCraftingTask(inputs, progressAmt, tag.func_74762_e("manaReq"));
                        queueMap.add(task);
                        continue block14;
                    }
                    case "brewery": {
                        TileBotaniaMechanicalMachineBase.CraftingTask task = new TileBotaniaMechanicalMachineBase.BreweryCraftingTask(inputs, progressAmt, tag.func_74762_e("manaReq"));
                        queueMap.add(task);
                        continue block14;
                    }
                    default: {
                        TileBotaniaMechanicalMachineBase.CraftingTask task = new TileBotaniaMechanicalMachineBase.CraftingTask(inputs, progressAmt);
                        queueMap.add(task);
                    }
                }
            }
        }
        return queueMap;
    }
}

