/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.util;

import appeng.api.AEApi;
import appeng.api.definitions.IItemDefinition;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AEColor;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import cofh.core.item.ItemMultiRF;
import cofh.thermaldynamics.block.ItemBlockDuct;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.Energy;
import com.denfop.items.ItemBaseCircuit;
import com.denfop.items.resource.ItemCraftingElements;
import com.denfop.items.transport.ItemCable;
import com.denfop.items.transport.ItemQCable;
import com.denfop.items.transport.ItemSCable;
import com.denfop.items.transport.ItemUniversalCable;
import com.denfop.tiles.base.TileEntityBlock;
import com.google.common.collect.ImmutableList;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IItemStack;
import dev.beecube31.crazyae2.client.gui.sprites.ISpriteProvider;
import dev.beecube31.crazyae2.client.gui.sprites.Sprite;
import dev.beecube31.crazyae2.common.i18n.CrazyAETooltip;
import dev.beecube31.crazyae2.common.util.ModsChecker;
import dev.beecube31.crazyae2.core.CrazyAE;
import dev.beecube31.crazyae2.core.CrazyAESidedHandler;
import dev.beecube31.crazyae2.core.client.CrazyAEClientConfig;
import ic2.core.item.block.ItemBlockTileEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class Utils {
    public static final String RENDER_FLAG_BASE = "RENDERFLAG~";
    public static final String RENDER_FLAG_BASE_TOOLTIPED = "\u00a77RENDERFLAG~";
    public static final String SPRITE_FLAG = "SPRITE~";
    public static final String ITEMSTACK_FLAG = "STACK~";

    public static ISpriteProvider decodeSpriteFlag(String v) {
        final String[] data = v.split("\\|");
        return new ISpriteProvider(){

            @Override
            public int getTextureX() {
                return Integer.parseInt(data[3]);
            }

            @Override
            public int getTextureY() {
                return Integer.parseInt(data[4]);
            }

            @Override
            public int getSizeX() {
                return Integer.parseInt(data[1]);
            }

            @Override
            public int getSizeY() {
                return Integer.parseInt(data[2]);
            }

            @Override
            public String getTextureStr() {
                return data[0];
            }

            @Override
            public ResourceLocation getTexture() {
                return new ResourceLocation(data[5]);
            }
        };
    }

    @SideOnly(value=Side.CLIENT)
    public static String encodeSpriteFlag(ISpriteProvider r) {
        if (!CrazyAEClientConfig.isAdvancedTooltipsEnabled()) {
            return "";
        }
        return r.getTextureStr() + '|' + r.getSizeX() + '|' + r.getSizeY() + '|' + r.getTextureX() + '|' + r.getTextureY() + '|' + r.getTexture().toString();
    }

    @SideOnly(value=Side.CLIENT)
    public static String writeItemStackFlag(ItemStack v) {
        if (!CrazyAEClientConfig.isAdvancedTooltipsEnabled()) {
            return "";
        }
        return "RENDERFLAG~STACK~" + Utils.encodeItemStack(v) + ';';
    }

    @SideOnly(value=Side.CLIENT)
    public static String writeSpriteFlag(ISpriteProvider v) {
        if (!CrazyAEClientConfig.isAdvancedTooltipsEnabled()) {
            return "";
        }
        return "RENDERFLAG~SPRITE~" + Utils.encodeSpriteFlag(v) + ';';
    }

    @SideOnly(value=Side.CLIENT)
    public static String encodeItemStack(ItemStack toEncode) {
        NBTTagCompound comp = new NBTTagCompound();
        return toEncode.func_77955_b(comp).toString();
    }

    @SideOnly(value=Side.CLIENT)
    public static ItemStack decodeItemStack(String nbt) {
        try {
            return new ItemStack(JsonToNBT.func_180713_a((String)nbt));
        }
        catch (NBTException ignored) {
            return ItemStack.field_190927_a;
        }
    }

    public static boolean isToolChargingEnabled(ItemStack victim) {
        return victim.func_77942_o() && victim.func_77978_p().func_74764_b("enableCharging") && victim.func_77978_p().func_74767_n("enableCharging");
    }

    @SideOnly(value=Side.CLIENT)
    public static void addReqChannelTooltip(List<String> tooltip) {
        if (!CrazyAEClientConfig.isAdvancedTooltipsEnabled()) {
            return;
        }
        tooltip.add(Utils.writeItemStackFlag(AEApi.instance().definitions().parts().cableSmart().stack(AEColor.values()[CrazyAE.oneToSixteenTicks], 1)) + CrazyAETooltip.REQUIRE_CHANNEL.getLocal());
    }

    @SideOnly(value=Side.CLIENT)
    public static void addReqManaPerJob(List<String> tooltip, double val) {
        if (!CrazyAEClientConfig.isAdvancedTooltipsEnabled()) {
            return;
        }
        tooltip.add(Utils.writeSpriteFlag(Sprite.MANA_TABLET) + String.format(CrazyAETooltip.REQUIRE_MANA_PER_JOB.getLocalWithSpaceAtEnd(), val));
    }

    @SideOnly(value=Side.CLIENT)
    public static void addReqManaPerTick(List<String> tooltip, double val) {
        if (!CrazyAEClientConfig.isAdvancedTooltipsEnabled()) {
            return;
        }
        tooltip.add(Utils.writeSpriteFlag(Sprite.MANA_TABLET) + String.format(CrazyAETooltip.REQUIRE_MANA_PER_TICK.getLocalWithSpaceAtEnd(), val));
    }

    @SideOnly(value=Side.CLIENT)
    public static void addReqAePerJob(List<String> tooltip, double val) {
        if (!CrazyAEClientConfig.isAdvancedTooltipsEnabled()) {
            return;
        }
        tooltip.add(Utils.writeSpriteFlag(Sprite.ENERGY) + String.format(CrazyAETooltip.REQUIRE_AE_PER_JOB.getLocalWithSpaceAtEnd(), val));
    }

    @SideOnly(value=Side.CLIENT)
    public static void addReqAePerTick(List<String> tooltip, double val) {
        if (!CrazyAEClientConfig.isAdvancedTooltipsEnabled()) {
            return;
        }
        tooltip.add(Utils.writeSpriteFlag(Sprite.ENERGY) + String.format(CrazyAETooltip.REQUIRE_AE_PER_TICK.getLocalWithSpaceAtEnd(), val));
    }

    public static List<IAEItemStack> getContainerItemsFromInputs(ICraftingPatternDetails details, long batchSize) {
        IAEItemStack[] inputs;
        ArrayList<IAEItemStack> containerItemsToReturn = new ArrayList<IAEItemStack>();
        if (details == null || batchSize <= 0L) {
            return containerItemsToReturn;
        }
        for (IAEItemStack templateInput : inputs = details.getInputs()) {
            long totalContainersFromThisInputType;
            long totalUnitsOfThisInputItemUsed;
            AEItemStack aeContainerStack;
            ItemStack containerPerSingleItem;
            ItemStack inputStackForOneCraft;
            if (templateInput == null || templateInput.getStackSize() <= 0L || (inputStackForOneCraft = templateInput.createItemStack()).func_190926_b() || (containerPerSingleItem = Platform.getContainerItem((ItemStack)inputStackForOneCraft.func_77946_l().func_77979_a(1))).func_190926_b() || (aeContainerStack = AEItemStack.fromItemStack((ItemStack)containerPerSingleItem.func_77946_l())) == null || aeContainerStack.getStackSize() <= 0L || (totalUnitsOfThisInputItemUsed = Utils.multiplySafely(templateInput.getStackSize(), batchSize)) <= 0L || (totalContainersFromThisInputType = Utils.multiplySafely(aeContainerStack.getStackSize(), totalUnitsOfThisInputItemUsed)) <= 0L) continue;
            IAEItemStack finalBatchContainer = aeContainerStack.copy();
            finalBatchContainer.setStackSize(totalContainersFromThisInputType);
            boolean merged = false;
            for (IAEItemStack existingContainer : containerItemsToReturn) {
                if (!existingContainer.isSameType(finalBatchContainer)) continue;
                existingContainer.setStackSize(existingContainer.getStackSize() + finalBatchContainer.getStackSize());
                merged = true;
                break;
            }
            if (merged) continue;
            containerItemsToReturn.add(finalBatchContainer);
        }
        return containerItemsToReturn;
    }

    public static NBTTagCompound createItemTag(ItemStack i, boolean ignoreItemNBT) {
        NBTTagCompound c = new NBTTagCompound();
        if (!i.func_190926_b()) {
            Utils.stackWriteToNBT(i, c, ignoreItemNBT);
        }
        return c;
    }

    public static void stackWriteToNBT(ItemStack is, NBTTagCompound itemNBT, boolean ignoreItemNBT) {
        if (ignoreItemNBT && !Utils.isItemAlwaysContainsNBT(is)) {
            is.func_77982_d(null);
        }
        is.func_77955_b(itemNBT);
        if (is.func_190916_E() > 127) {
            itemNBT.func_74768_a("stackSize", is.func_190916_E());
        }
    }

    public static String format4(double amt) {
        String out = "0";
        double i = Math.log10(amt);
        if (i > -3.0 && i < 0.0) {
            out = String.format("%.0fm", amt * 1000.0);
        } else if (i <= -3.0 && i > -6.0) {
            out = String.format("%.0f\u00b5", amt * 1000000.0);
        } else if (i <= -6.0 && i > -9.0) {
            out = String.format("%.0fn", amt * 1.0E9);
        } else if (i <= -9.0 && i > -12.0) {
            out = String.format("%.0fp", amt * 1.0E12);
        } else if (i < 3.0) {
            out = String.format("%.0f", amt);
        } else if (i < 6.0) {
            out = String.format("%.4fK", amt / 1000.0);
        } else if (i < 9.0) {
            out = String.format("%.4fM", amt / 1000000.0);
        } else if (i < 12.0) {
            out = String.format("%.4fG", amt / 1.0E9);
        } else if (i < 15.0) {
            out = String.format("%.4fT", amt / 1.0E12);
        } else if (i < 18.0) {
            out = String.format("%.4fP", amt / 1.0E15);
        } else if (i < 21.0) {
            out = String.format("%.4fE", amt / 1.0E18);
        } else if (i < 24.0) {
            out = String.format("%.4fZ", amt / 1.0E21);
        } else if (i < 27.0) {
            out = String.format("%.4fY", amt / 1.0E24);
        }
        return out;
    }

    public static String getFullDecimalOf(double val) {
        return String.format("%.0f", val);
    }

    public static String format1(double amt) {
        if (amt > 4.0E12) {
            return String.format("%fT", amt / 1024.0 / 1024.0 / 1024.0 / 1024.0);
        }
        if (amt > 4.0E9) {
            return String.format("%fG", amt / 1024.0 / 1024.0 / 1024.0);
        }
        if (amt > 4000000.0) {
            return String.format("%fM", amt / 1024.0 / 1024.0);
        }
        if (amt > 4000.0) {
            return String.format("%fk", amt / 1024.0);
        }
        return Double.toString(amt);
    }

    public static long getStorageCountOf(ItemStack item) {
        if (item != null) {
            return AEApi.instance().definitions().blocks().craftingStorage1k().isSameAs(item) ? 1024L : (AEApi.instance().definitions().blocks().craftingStorage4k().isSameAs(item) ? 4096L : (AEApi.instance().definitions().blocks().craftingStorage16k().isSameAs(item) ? 16384L : (AEApi.instance().definitions().blocks().craftingStorage64k().isSameAs(item) ? 65536L : (CrazyAE.definitions().blocks().craftingStorage256k().isSameAs(item) ? 262144L : (CrazyAE.definitions().blocks().craftingStorage1mb().isSameAs(item) ? 0x100000L : (CrazyAE.definitions().blocks().craftingStorage4mb().isSameAs(item) ? 0x400000L : (CrazyAE.definitions().blocks().craftingStorage16mb().isSameAs(item) ? 0x1000000L : (CrazyAE.definitions().blocks().craftingStorage64mb().isSameAs(item) ? 0x4000000L : (CrazyAE.definitions().blocks().craftingStorage256mb().isSameAs(item) ? 0x10000000L : (CrazyAE.definitions().blocks().craftingStorage1gb().isSameAs(item) ? 0x40000000L : (CrazyAE.definitions().blocks().craftingStorage2gb().isSameAs(item) ? 0x80000000L : (CrazyAE.definitions().blocks().craftingStorage8gb().isSameAs(item) ? 0x200000000L : (CrazyAE.definitions().blocks().craftingStorage32gb().isSameAs(item) ? 0x800000000L : (CrazyAE.definitions().blocks().craftingStorage128gb().isSameAs(item) ? 0x2000000000L : (CrazyAE.definitions().blocks().craftingStorageCreative().isSameAs(item) ? Long.MAX_VALUE : 0L)))))))))))))));
        }
        return 0L;
    }

    public static int getAcceleratorsCountOf(ItemStack item) {
        if (item != null) {
            return AEApi.instance().definitions().blocks().craftingAccelerator().isSameAs(item) ? 1 : (CrazyAE.definitions().blocks().coprocessor4x().isSameAs(item) ? 4 : (CrazyAE.definitions().blocks().coprocessor16x().isSameAs(item) ? 16 : (CrazyAE.definitions().blocks().coprocessor64x().isSameAs(item) ? 64 : (CrazyAE.definitions().blocks().coprocessor256x().isSameAs(item) ? 256 : (CrazyAE.definitions().blocks().coprocessor1024x().isSameAs(item) ? 1024 : (CrazyAE.definitions().blocks().coprocessor4096x().isSameAs(item) ? 4096 : (CrazyAE.definitions().blocks().coprocessor16384x().isSameAs(item) ? 16384 : (CrazyAE.definitions().blocks().coprocessor65536x().isSameAs(item) ? 65536 : (CrazyAE.definitions().blocks().coprocessor262144x().isSameAs(item) ? 262144 : (CrazyAE.definitions().blocks().coprocessor1048576x().isSameAs(item) ? 0x100000 : (CrazyAE.definitions().blocks().coprocessor4194304x().isSameAs(item) ? 0x400000 : (CrazyAE.definitions().blocks().coprocessorCreative().isSameAs(item) ? Integer.MAX_VALUE : 0))))))))))));
        }
        return 0;
    }

    public static int findSlotIndex(ICraftingPatternDetails details, IAEItemStack templateInput) {
        IAEItemStack[] inputs = details.getInputs();
        for (int i = 0; i < inputs.length; ++i) {
            if (inputs[i] != null && inputs[i].equals(templateInput)) {
                return i;
            }
            if (inputs[i] == null || !inputs[i].isSameType(templateInput)) continue;
            return i;
        }
        return -1;
    }

    public static long multiplySafely(long a, long b) {
        if (a == 0L || b == 0L) {
            return 0L;
        }
        long result = a * b;
        if (a == result / b) {
            return result;
        }
        return -1L;
    }

    public static boolean isIUBlock(TileEntity te) {
        return ModsChecker.IU_LOADED && te instanceof TileEntityBlock;
    }

    public static boolean isItemAlwaysContainsNBT(ItemStack is) {
        return ModsChecker.IU_LOADED && (is.func_77973_b() instanceof ItemCraftingElements || is.func_77973_b() instanceof ItemBaseCircuit);
    }

    public static double getPowerFromTier(int tier) {
        return tier < 14 ? 8.0 * Math.pow(4.0, tier) : 9.223372036854776E18;
    }

    public static long getLongPowerFromTier(int tier) {
        return tier < 14 ? (long)(8.0 * Math.pow(4.0, tier)) : Long.MAX_VALUE;
    }

    public static int getIntPowerFromTier(int tier) {
        return tier < 14 ? (int)(8.0 * Math.pow(4.0, tier)) : Integer.MAX_VALUE;
    }

    public static int getTierFromPower(double power) {
        return power <= 0.0 ? 0 : Math.min(30, (int)Math.ceil(Math.log(power / 8.0) / Math.log(4.0)));
    }

    public static ItemStack getItemStack(IItemStack item) {
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        Object internal = item.getInternal();
        if (!(internal instanceof ItemStack)) {
            CraftTweakerAPI.logError((String)("Not a valid item stack: " + item));
            throw new IllegalArgumentException("Not a valid item stack: " + item);
        }
        return ((ItemStack)internal).func_77946_l();
    }

    public static String generateCraftingID(IAEItemStack finalOutput) {
        long now = System.currentTimeMillis();
        int hash = System.identityHashCode(Platform.getRandomInt());
        int itemHash = finalOutput == null ? 0 : finalOutput.hashCode();
        return Long.toString(now, 36) + '-' + Integer.toString(hash, 36) + '-' + Integer.toString(itemHash, 36);
    }

    public static void postChange(IAEItemStack diff, IActionSource src, Iterator<Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object>> listeners) {
        if (listeners.hasNext()) {
            ImmutableList single = ImmutableList.of((Object)diff.copy());
            while (listeners.hasNext()) {
                Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object> o = listeners.next();
                IMEMonitorHandlerReceiver<IAEItemStack> receiver = o.getKey();
                if (receiver.isValid(o.getValue())) {
                    receiver.postChange(null, (Iterable)single, src);
                    continue;
                }
                listeners.remove();
            }
        }
    }

    public static NBTTagCompound generateLinkData(String craftingID, boolean standalone, boolean req) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("CraftID", craftingID);
        tag.func_74757_a("canceled", false);
        tag.func_74757_a("done", false);
        tag.func_74757_a("standalone", standalone);
        tag.func_74757_a("req", req);
        return tag;
    }

    public static void setStackInSlot(IItemHandler inv, int slot, ItemStack stack) {
        if (inv instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable m = (IItemHandlerModifiable)inv;
            m.setStackInSlot(slot, stack);
        } else {
            inv.extractItem(slot, Integer.MAX_VALUE, false);
            inv.insertItem(slot, stack, false);
        }
    }

    public static List<Object> findEnergyComponents(TileEntity tile) {
        ArrayList<Object> out = new ArrayList<Object>();
        for (AbstractComponent comp : ((TileEntityBlock)tile).getComponentList()) {
            if (!(comp instanceof ComponentBaseEnergy) && !(comp instanceof Energy)) continue;
            out.add(comp);
        }
        return out;
    }

    public static void copy(IItemHandler from, IItemHandler to, boolean deepCopy) {
        for (int i = 0; i < Math.min(from.getSlots(), to.getSlots()); ++i) {
            Utils.setStackInSlot(to, i, deepCopy ? from.getStackInSlot(i).func_77946_l() : from.getStackInSlot(i));
        }
    }

    public static void updateEnergyHandler(IItemHandler from) {
        for (int i = 0; i < from.getSlots(); ++i) {
            List<IItemDefinition> found = Utils.getItemEnergyType(from.getStackInSlot(i));
            if (found != null && !found.isEmpty()) {
                Utils.setStackInSlot(from, i, found.get(0).maybeStack(1).orElse(ItemStack.field_190927_a));
                continue;
            }
            Utils.setStackInSlot(from, i, ItemStack.field_190927_a);
        }
    }

    public static void copyExcluded(IItemHandler from, IItemHandler to, boolean deepCopy, int ... excludedList) {
        for (int i = 0; i < Math.min(from.getSlots(), to.getSlots()); ++i) {
            boolean skip = false;
            for (int j : excludedList) {
                if (i != j) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            Utils.setStackInSlot(to, i, deepCopy ? from.getStackInSlot(i).func_77946_l() : from.getStackInSlot(i));
        }
    }

    public static List<IItemDefinition> getItemEnergyType(ItemStack is) {
        for (IItemDefinition candidate : CrazyAESidedHandler.availableEnergyTypes) {
            if (!candidate.isSameAs(is)) continue;
            return Collections.singletonList(candidate);
        }
        Item item = is.func_77973_b();
        if (ModsChecker.IU_LOADED && item instanceof ItemCable) {
            return Collections.singletonList(CrazyAE.definitions().items().EFEnergyAsAeStack());
        }
        if (ModsChecker.IU_LOADED && item instanceof ItemQCable) {
            return Collections.singletonList(CrazyAE.definitions().items().QEEnergyAsAeStack());
        }
        if (ModsChecker.IU_LOADED && item instanceof ItemSCable) {
            return Collections.singletonList(CrazyAE.definitions().items().SEEnergyAsAeStack());
        }
        if (ModsChecker.IU_LOADED && item instanceof ItemUniversalCable) {
            return Collections.singletonList(CrazyAE.definitions().items().EFEnergyAsAeStack());
        }
        if (ModsChecker.COFHCORE_LOADED && item instanceof ItemMultiRF) {
            return Collections.singletonList(CrazyAE.definitions().items().FEEnergyAsAeStack());
        }
        if (ModsChecker.TD_LOADED && item instanceof ItemBlockDuct) {
            return Collections.singletonList(CrazyAE.definitions().items().FEEnergyAsAeStack());
        }
        if (ModsChecker.IC2_LOADED && (item instanceof ic2.core.item.block.ItemCable || item instanceof ItemBlockTileEntity)) {
            return Collections.singletonList(CrazyAE.definitions().items().EUEnergyAsAeStack());
        }
        return null;
    }
}

