/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.util.patterns.crafting;

import appeng.api.AEApi;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.helpers.ItemStackHelper;
import appeng.util.item.AEItemStack;
import dev.beecube31.crazyae2.common.interfaces.crafting.ICrazyAECraftingPatternDetails;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public abstract class CrazyAECraftingPatternDetails
implements ICrazyAECraftingPatternDetails {
    protected int priority = 0;
    protected IAEItemStack[] inputs;
    protected IAEItemStack[] outputs;
    protected IAEItemStack pattern;
    protected final ItemStack patternItem;

    public CrazyAECraftingPatternDetails(ItemStack is) {
        ItemStack gs;
        int x;
        NBTTagCompound encodedValue = is.func_77978_p();
        if (encodedValue == null) {
            throw new IllegalArgumentException("Invalid pattern provided : " + is);
        }
        NBTTagList inTag = encodedValue.func_150295_c("input", 10);
        NBTTagList outTag = encodedValue.func_150295_c("output", 10);
        ArrayList<IAEItemStack> in = new ArrayList<IAEItemStack>();
        ArrayList<IAEItemStack> out = new ArrayList<IAEItemStack>();
        for (x = 0; x < inTag.func_74745_c(); ++x) {
            NBTTagCompound ingredient = inTag.func_150305_b(x);
            gs = ItemStackHelper.stackFromNBT((NBTTagCompound)ingredient);
            if (!ingredient.func_82582_d() && gs.func_190926_b()) {
                throw new IllegalArgumentException("Invalid pattern provided : " + is);
            }
            if (gs.func_190926_b()) continue;
            in.add((IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)gs));
        }
        for (x = 0; x < outTag.func_74745_c(); ++x) {
            NBTTagCompound resultItemTag = outTag.func_150305_b(x);
            gs = ItemStackHelper.stackFromNBT((NBTTagCompound)resultItemTag);
            if (!resultItemTag.func_82582_d() && gs.func_190926_b()) {
                throw new IllegalArgumentException("Invalid pattern provided : " + is);
            }
            if (gs.func_190926_b()) continue;
            out.add((IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)gs));
        }
        IAEItemStack[] inputs = in.toArray(new IAEItemStack[0]);
        IAEItemStack[] outputs = out.toArray(new IAEItemStack[0]);
        HashMap<IAEItemStack, IAEItemStack> tmpOutputs = new HashMap<IAEItemStack, IAEItemStack>();
        for (IAEItemStack io : outputs) {
            if (io == null) continue;
            IAEItemStack g = (IAEItemStack)tmpOutputs.get(io);
            if (g == null) {
                tmpOutputs.put(io, io.copy());
                continue;
            }
            g.add(io);
        }
        HashMap<IAEItemStack, IAEItemStack> tmpInputs = new HashMap<IAEItemStack, IAEItemStack>();
        for (IAEItemStack io : inputs) {
            if (io == null) continue;
            IAEItemStack g = (IAEItemStack)tmpInputs.get(io);
            if (g == null) {
                tmpInputs.put(io, io.copy());
                continue;
            }
            g.add(io);
        }
        if (tmpOutputs.isEmpty() || tmpInputs.isEmpty()) {
            throw new IllegalArgumentException("Invalid pattern provided : " + is);
        }
        this.inputs = new IAEItemStack[tmpInputs.size()];
        int offset = 0;
        Iterator iterator = tmpInputs.values().iterator();
        while (iterator.hasNext()) {
            IAEItemStack io;
            this.inputs[offset] = io = (IAEItemStack)iterator.next();
            ++offset;
        }
        offset = 0;
        this.outputs = new IAEItemStack[tmpOutputs.size()];
        iterator = tmpOutputs.values().iterator();
        while (iterator.hasNext()) {
            IAEItemStack io;
            this.outputs[offset] = io = (IAEItemStack)iterator.next();
            ++offset;
        }
        this.patternItem = is;
        this.pattern = AEItemStack.fromItemStack((ItemStack)is);
    }

    public abstract ItemStack getPattern();

    public boolean isValidItemForSlot(int i, ItemStack itemStack, World world) {
        return true;
    }

    public boolean isCraftable() {
        return true;
    }

    public IAEItemStack[] getInputs() {
        return this.inputs;
    }

    public IAEItemStack[] getCondensedInputs() {
        return this.inputs;
    }

    public IAEItemStack[] getCondensedOutputs() {
        return this.outputs;
    }

    public IAEItemStack[] getOutputs() {
        return this.outputs;
    }

    public IAEItemStack getPrimaryOutput() {
        return this.outputs[0];
    }

    public boolean canSubstitute() {
        return false;
    }

    public ItemStack getOutput(InventoryCrafting inventoryCrafting, World world) {
        return this.outputs[0].createItemStack();
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int i) {
        this.priority = i;
    }
}

