/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.core;

import appeng.api.definitions.IItemDefinition;
import appeng.api.features.IRegistryContainer;
import appeng.api.networking.IGridCacheRegistry;
import appeng.api.storage.ICellHandler;
import appeng.container.implementations.ContainerMEPortableCell;
import appeng.core.Api;
import appeng.items.AEBaseItem;
import appeng.util.Platform;
import dev.beecube31.crazyae2.client.gui.CrazyAEBaseGui;
import dev.beecube31.crazyae2.client.gui.sprites.ISpriteProvider;
import dev.beecube31.crazyae2.common.features.Features;
import dev.beecube31.crazyae2.common.features.subfeatures.ISubFeature;
import dev.beecube31.crazyae2.common.interfaces.gui.ITooltipIconsObj;
import dev.beecube31.crazyae2.common.interfaces.gui.ITooltipSpritesObj;
import dev.beecube31.crazyae2.common.items.cells.handlers.CreativeEnergyCellHandler;
import dev.beecube31.crazyae2.common.items.cells.handlers.CreativeManaCellHandler;
import dev.beecube31.crazyae2.common.items.cells.storage.ImprovedPortableCell;
import dev.beecube31.crazyae2.common.networking.CrazyAENetworkHandler;
import dev.beecube31.crazyae2.common.networking.network.NetworkHandler;
import dev.beecube31.crazyae2.common.registration.Registration;
import dev.beecube31.crazyae2.common.registration.definitions.Upgrades;
import dev.beecube31.crazyae2.common.sync.CrazyAEGuiHandler;
import dev.beecube31.crazyae2.common.util.Utils;
import dev.beecube31.crazyae2.core.Ticker;
import dev.beecube31.crazyae2.core.UpdateChecker;
import dev.beecube31.crazyae2.core.cache.ICrazyAutocraftingSystem;
import dev.beecube31.crazyae2.core.cache.IGridChannelBoostersCache;
import dev.beecube31.crazyae2.core.cache.impl.CrazyAutocraftingSystem;
import dev.beecube31.crazyae2.core.cache.impl.GridChannelBoostersCache;
import dev.beecube31.crazyae2.core.client.CrazyAEClientConfig;
import dev.beecube31.crazyae2.core.client.CrazyAEClientHandler;
import dev.beecube31.crazyae2.core.config.CrazyAEConfig;
import dev.beecube31.crazyae2.core.helpers.Helper;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="crazyae", version="v0.6.0.1", name="CrazyAE", acceptedMinecraftVersions="[1.12.2]", dependencies="required-after:appliedenergistics2;required-after:mixinbooter@[8.3,);after:codechickenlib;after:lumenized;after:botania")
public class CrazyAE {
    public static CrazyAE instance;
    @SidedProxy(clientSide="dev.beecube31.crazyae2.core.helpers.ClientHelper", serverSide="dev.beecube31.crazyae2.core.helpers.ServerHelper", modId="crazyae")
    public static Helper proxy;
    private static FeatureManager featureManager;
    private final Logger logger = LogManager.getLogger((String)"crazyae".toUpperCase());
    private final CrazyAENetworkHandler network = new CrazyAENetworkHandler();
    private Registration registration;
    private CrazyAEGuiHandler crazyAEGuiHandler;
    @SideOnly(value=Side.CLIENT)
    private static ItemStack icon;
    public static int iconTicks;
    public static int oneToSixteenTicks;

    public static void setupFeatureConfig() {
        if (featureManager == null) {
            featureManager = new FeatureManager();
        }
    }

    public static SimpleNetworkWrapper net() {
        return CrazyAE.instance.network.getChannel();
    }

    public static CrazyAEGuiHandler gui() {
        return CrazyAE.instance.crazyAEGuiHandler;
    }

    public static Registration definitions() {
        return CrazyAE.instance.registration;
    }

    @SideOnly(value=Side.CLIENT)
    public static ItemStack icon() {
        return icon;
    }

    @SideOnly(value=Side.CLIENT)
    public static void runClientLoops() {
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        scheduler.scheduleAtFixedRate(new TicksLoop(), 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    public static Logger logger() {
        return CrazyAE.instance.logger;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.registration = new Registration();
        instance = this;
        this.crazyAEGuiHandler = new CrazyAEGuiHandler();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)this.crazyAEGuiHandler);
        if (Platform.isClient()) {
            proxy.preinit();
            CrazyAEClientConfig.init(new Configuration(new File(event.getModConfigurationDirectory().getPath(), "crazyae-client.cfg")));
        }
        MinecraftForge.EVENT_BUS.register((Object)instance);
        this.registration.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.registration.init(event);
        proxy.init();
        MinecraftForge.EVENT_BUS.register((Object)Ticker.INSTANCE);
        if (!CrazyAEConfig.disableUpdatesCheck) {
            MinecraftForge.EVENT_BUS.register((Object)new UpdateChecker());
        }
        Api api = Api.INSTANCE;
        IRegistryContainer registries = api.registries();
        IGridCacheRegistry gcr = registries.gridCache();
        if (Features.MANA_CELLS.isEnabled() || Features.MANA_DENSE_CELLS.isEnabled() || Features.MEGA_MANA_DENSE_CELLS.isEnabled()) {
            registries.cell().addCellHandler((ICellHandler)new CreativeManaCellHandler());
        }
        if (Features.ENERGY_CELLS.isEnabled() || Features.ENERGY_DENSE_CELLS.isEnabled() || Features.MEGA_ENERGY_DENSE_CELLS.isEnabled()) {
            registries.cell().addCellHandler((ICellHandler)new CreativeEnergyCellHandler());
        }
        if (Features.FAST_AUTOCRAFTING_SYSTEM.isEnabled()) {
            gcr.registerGridCache(ICrazyAutocraftingSystem.class, CrazyAutocraftingSystem.class);
        }
        if (Features.QUANTUM_CHANNELS_MULTIPLIER.isEnabled()) {
            gcr.registerGridCache(IGridChannelBoostersCache.class, GridChannelBoostersCache.class);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (event.getSide() == Side.CLIENT) {
            CrazyAE.runClientLoops();
        }
        proxy.postinit();
        NetworkHandler.init("CrazyAE");
        this.registration.postInit(event);
    }

    @SubscribeEvent
    public void handleEntityItemPickup(EntityItemPickupEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player.field_71070_bA instanceof ContainerMEPortableCell) {
            return;
        }
        InventoryPlayer inventory = event.getEntityPlayer().field_71071_by;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ImprovedPortableCell cell;
            ItemStack stack = inventory.func_70301_a(i);
            Item item = stack.func_77973_b();
            if (!(item instanceof ImprovedPortableCell) || !(cell = (ImprovedPortableCell)item).isAutoPickupEnabled(stack) || !cell.onItemPickup(event, stack)) continue;
            event.setCanceled(true);
            return;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onTooltipPreRenderingEv(RenderTooltipEvent.Pre event) {
        block47: {
            if (!CrazyAEClientConfig.isAdvancedTooltipsEnabled()) {
                return;
            }
            List originalLines = event.getLines();
            if (originalLines.isEmpty()) {
                return;
            }
            ArrayList<String> lines = new ArrayList<String>();
            HashMap<Integer, Integer> originalToProcessed = new HashMap<Integer, Integer>();
            HashMap<Integer, Integer> processedToOriginal = new HashMap<Integer, Integer>();
            for (int i = 0; i < originalLines.size(); ++i) {
                String line = (String)originalLines.get(i);
                if (line == null) {
                    line = "";
                }
                String[] subLines = line.split("\n", -1);
                originalToProcessed.put(i, lines.size());
                for (String subLine : subLines) {
                    processedToOriginal.put(lines.size(), i);
                    lines.add(subLine);
                }
            }
            boolean needDraw = false;
            ArrayList<String> flagProcessedLines = new ArrayList<String>(lines);
            HashMap<Integer, Object> itemIconDefinitions = new HashMap<Integer, Object>();
            HashMap<Integer, Object> spriteIconDefinitions = new HashMap<Integer, Object>();
            block10: for (int i = 0; i < flagProcessedLines.size(); ++i) {
                String[] baseSplit;
                String line = (String)flagProcessedLines.get(i);
                Integer originalIndex = (Integer)processedToOriginal.get(i);
                if (originalIndex == null || (Integer)originalToProcessed.get(originalIndex) != i) continue;
                boolean canRender = false;
                String flagContent = null;
                if (line.startsWith("\u00a77RENDERFLAG~")) {
                    canRender = true;
                    flagContent = line.substring("\u00a77RENDERFLAG~".length());
                } else if (line.startsWith("RENDERFLAG~")) {
                    canRender = true;
                    flagContent = line.substring("RENDERFLAG~".length());
                } else if (line.length() >= 2) {
                    String potentialFlagPart = line.substring(2);
                    if (potentialFlagPart.startsWith("RENDERFLAG~")) {
                        canRender = true;
                        flagContent = potentialFlagPart.substring("RENDERFLAG~".length());
                    } else if (potentialFlagPart.startsWith("\u00a77RENDERFLAG~")) {
                        canRender = true;
                        flagContent = potentialFlagPart.substring("\u00a77RENDERFLAG~".length());
                    }
                }
                if (!canRender || (baseSplit = flagContent.split("~", 2)).length <= 1) continue;
                String typeMarker = baseSplit[0] + "~";
                String dataAndText = baseSplit[1];
                String[] typeAndTextSplit = dataAndText.split(";", 2);
                if (typeAndTextSplit.length <= 1) continue;
                String definition = typeAndTextSplit[0];
                String lineText = typeAndTextSplit[1];
                switch (typeMarker) {
                    case "STACK~": {
                        needDraw = true;
                        itemIconDefinitions.put(i, definition);
                        flagProcessedLines.set(i, CrazyAEClientHandler.ICON_INDENTATION + lineText);
                        continue block10;
                    }
                    case "SPRITE~": {
                        needDraw = true;
                        spriteIconDefinitions.put(i, definition);
                        flagProcessedLines.set(i, CrazyAEClientHandler.ICON_INDENTATION + lineText);
                    }
                }
            }
            if (needDraw) {
                event.setCanceled(true);
                FontRenderer font = event.getFontRenderer();
                int screenWidth = event.getScreenWidth();
                int screenHeight = event.getScreenHeight();
                CrazyAEClientHandler.TooltipLayout layout = CrazyAEClientHandler.drawTooltipAndGetComponents(event.getStack(), flagProcessedLines, event.getX(), event.getY(), screenWidth, screenHeight, -1, font);
                if (layout.posArray != null && !layout.effectiveLines.isEmpty()) {
                    int lineTextStartY;
                    int finalTooltipX = layout.posArray[0];
                    int finalTooltipY = layout.posArray[1];
                    int titleLinesCount = layout.posArray[4];
                    int iconOffsetX = 2;
                    boolean iconBaseYOffset = false;
                    for (Map.Entry entry : itemIconDefinitions.entrySet()) {
                        int logicalLineIndex = (Integer)entry.getKey();
                        Integer firstEffectiveLineIndex = layout.logicalToEffectiveLineMap.get(logicalLineIndex);
                        if (firstEffectiveLineIndex == null) continue;
                        lineTextStartY = CrazyAEClientHandler.getCorrectTextLineY(firstEffectiveLineIndex, finalTooltipY, titleLinesCount, layout.effectiveLines.size());
                        CrazyAEClientHandler.drawItemIntoTooltip(Utils.decodeItemStack((String)entry.getValue()), finalTooltipX + 2, lineTextStartY + 0);
                    }
                    for (Map.Entry entry : spriteIconDefinitions.entrySet()) {
                        int logicalLineIndex = (Integer)entry.getKey();
                        Integer firstEffectiveLineIndex = layout.logicalToEffectiveLineMap.get(logicalLineIndex);
                        if (firstEffectiveLineIndex == null) continue;
                        lineTextStartY = CrazyAEClientHandler.getCorrectTextLineY(firstEffectiveLineIndex, finalTooltipY, titleLinesCount, layout.effectiveLines.size());
                        CrazyAEClientHandler.drawSpriteIntoTooltip(Utils.decodeSpriteFlag((String)entry.getValue()), finalTooltipX + 2, lineTextStartY + 0);
                    }
                }
                return;
            }
            GuiScreen screenWidth = Minecraft.func_71410_x().field_71462_r;
            if (screenWidth instanceof CrazyAEBaseGui) {
                CrazyAEBaseGui g = (CrazyAEBaseGui)screenWidth;
                if (g.hoveredClientSlot != null) {
                    return;
                }
            }
            Upgrades.UpgradeType contain = null;
            if (CrazyAE.definitions().upgrades().stackUpgrade().isSameAs(event.getStack())) {
                contain = Upgrades.UpgradeType.STACKS;
            } else if (CrazyAE.definitions().upgrades().improvedSpeedUpgrade().isSameAs(event.getStack())) {
                contain = Upgrades.UpgradeType.IMPROVED_SPEED;
            } else if (CrazyAE.definitions().upgrades().advancedSpeedUpgrade().isSameAs(event.getStack())) {
                contain = Upgrades.UpgradeType.ADVANCED_SPEED;
            }
            if (contain != null) {
                event.setCanceled(true);
                FontRenderer font = event.getFontRenderer();
                int screenWidth2 = event.getScreenWidth();
                int screenHeight = event.getScreenHeight();
                ArrayList<String> upgradeProcessedLines = new ArrayList<String>(lines.size());
                HashMap<Integer, Integer> upgradeIconTargetMap = new HashMap<Integer, Integer>();
                int entryIndex = 0;
                for (int i = 0; i < lines.size(); ++i) {
                    String lineContent = (String)lines.get(i);
                    Integer originalIndex = (Integer)processedToOriginal.get(i);
                    if (originalIndex != null && originalIndex >= 2 && originalIndex < originalLines.size() - (Minecraft.func_71410_x().field_71474_y.field_82882_x ? 2 : 0) && (Integer)originalToProcessed.get(originalIndex) == i) {
                        if (!lineContent.startsWith("crazyae:") && !lineContent.contains("CrazyAE")) {
                            lineContent = CrazyAEClientHandler.ICON_INDENTATION + lineContent;
                        }
                        if (originalIndex - 2 == entryIndex) {
                            upgradeIconTargetMap.put(entryIndex, i);
                            ++entryIndex;
                        }
                    }
                    upgradeProcessedLines.add(lineContent.replaceAll("\u00a7+.", ""));
                }
                Map<ItemStack, Integer> supportedDevices = contain.getSupported();
                List<Map.Entry<ItemStack, Integer>> sortedSupportedDeviceEntries = CrazyAEClientHandler.getSortedItemEntries(supportedDevices, supportedDevices.keySet());
                CrazyAEClientHandler.TooltipLayout layout = CrazyAEClientHandler.drawTooltipAndGetComponents(event.getStack(), upgradeProcessedLines, event.getX(), event.getY(), screenWidth2, screenHeight, -1, font);
                if (layout.posArray != null && !layout.effectiveLines.isEmpty()) {
                    int finalTooltipX = layout.posArray[0];
                    int finalTooltipY = layout.posArray[1];
                    int titleActualLinesCount = layout.posArray[4];
                    int iconOffsetX = 2;
                    boolean iconBaseYOffset = false;
                    for (int deviceIdx = 0; deviceIdx < sortedSupportedDeviceEntries.size(); ++deviceIdx) {
                        Integer firstEffectiveLineIndex;
                        Integer logicalLineIndex = (Integer)upgradeIconTargetMap.get(deviceIdx);
                        if (logicalLineIndex == null || logicalLineIndex >= upgradeProcessedLines.size() || (firstEffectiveLineIndex = layout.logicalToEffectiveLineMap.get(logicalLineIndex)) == null) continue;
                        ItemStack itemToDraw = sortedSupportedDeviceEntries.get(deviceIdx).getKey();
                        int lineTextStartY = CrazyAEClientHandler.getCorrectTextLineY(firstEffectiveLineIndex, finalTooltipY, titleActualLinesCount, layout.effectiveLines.size());
                        CrazyAEClientHandler.drawItemIntoTooltip(itemToDraw, finalTooltipX + 2, lineTextStartY + 0);
                    }
                }
                return;
            }
            Item eventItem = event.getStack().func_77973_b();
            if (!(eventItem instanceof AEBaseItem) || !(eventItem instanceof ITooltipSpritesObj) && !(eventItem instanceof ITooltipIconsObj)) break block47;
            event.setCanceled(true);
            FontRenderer font = event.getFontRenderer();
            int screenWidth3 = event.getScreenWidth();
            int screenHeight = event.getScreenHeight();
            ArrayList<String> itemTooltipProcessedLines = new ArrayList<String>(lines.size());
            for (int i = 0; i < lines.size(); ++i) {
                String lineContent = (String)lines.get(i);
                Integer originalIndex = (Integer)processedToOriginal.get(i);
                if (originalIndex != null && originalIndex >= 2 && originalIndex < originalLines.size() - (Minecraft.func_71410_x().field_71474_y.field_82882_x ? 2 : 0) && (Integer)originalToProcessed.get(originalIndex) == i && !lineContent.startsWith("crazyae:") && !lineContent.contains("CrazyAE")) {
                    lineContent = CrazyAEClientHandler.ICON_INDENTATION + lineContent;
                }
                itemTooltipProcessedLines.add(lineContent.replaceAll("\u00a7+.", ""));
            }
            CrazyAEClientHandler.TooltipLayout layout = CrazyAEClientHandler.drawTooltipAndGetComponents(event.getStack(), itemTooltipProcessedLines, event.getX(), event.getY(), screenWidth3, screenHeight, -1, font);
            if (layout.posArray != null && !layout.effectiveLines.isEmpty()) {
                int finalTooltipX = layout.posArray[0];
                int finalTooltipY = layout.posArray[1];
                int titleActualLinesCount = layout.posArray[4];
                int iconOffsetX = 3;
                boolean iconBaseYOffset = false;
                if (eventItem instanceof ITooltipSpritesObj) {
                    ITooltipSpritesObj tSprites = (ITooltipSpritesObj)eventItem;
                    for (Map.Entry<ISpriteProvider, Integer> e : tSprites.getTooltipIcons().entrySet()) {
                        Integer firstEffectiveLineIndex;
                        int originalLineIndexForIcon = e.getValue();
                        Integer logicalLineIndex = (Integer)originalToProcessed.get(originalLineIndexForIcon);
                        if (logicalLineIndex == null || (firstEffectiveLineIndex = layout.logicalToEffectiveLineMap.get(logicalLineIndex)) == null || firstEffectiveLineIndex >= layout.effectiveLines.size()) continue;
                        int lineTextStartY = CrazyAEClientHandler.getCorrectTextLineY(firstEffectiveLineIndex, finalTooltipY, titleActualLinesCount, layout.effectiveLines.size());
                        CrazyAEClientHandler.drawSpriteIntoTooltip(e.getKey(), finalTooltipX + 3, lineTextStartY + 0);
                    }
                } else {
                    ITooltipIconsObj tIcons = (ITooltipIconsObj)eventItem;
                    for (Map.Entry<ItemStack, Integer> e : tIcons.getTooltipIcons().entrySet()) {
                        Integer firstEffectiveLineIndex;
                        int originalLineIndexForIcon = e.getValue();
                        Integer logicalLineIndex = (Integer)originalToProcessed.get(originalLineIndexForIcon);
                        if (logicalLineIndex == null || (firstEffectiveLineIndex = layout.logicalToEffectiveLineMap.get(logicalLineIndex)) == null || firstEffectiveLineIndex >= layout.effectiveLines.size()) continue;
                        int lineTextStartY = CrazyAEClientHandler.getCorrectTextLineY(firstEffectiveLineIndex, finalTooltipY, titleActualLinesCount, layout.effectiveLines.size());
                        CrazyAEClientHandler.drawItemIntoTooltip(e.getKey(), finalTooltipX + 3, lineTextStartY + 0);
                    }
                }
            }
        }
    }

    static {
        iconTicks = 0;
        oneToSixteenTicks = 0;
    }

    public static class FeatureManager {
        public FeatureManager() {
            File file = new File("config/crazyae-features.cfg");
            Configuration config = new Configuration(file);
            for (Features feature : Features.values()) {
                if (feature.name().equals("STUB")) {
                    feature.setEnabled(true);
                    continue;
                }
                String lowerCase = feature.name().toLowerCase();
                ConfigCategory featureCategory = config.getCategory(lowerCase);
                Property entry = (Property)featureCategory.computeIfAbsent((Object)"enabled", x -> new Property("enabled", "true", Property.Type.BOOLEAN));
                feature.setEnabled(entry.getBoolean(true));
                EnumSet<? extends ISubFeature> subFeatures = feature.getSubFeatures();
                if (subFeatures == null) continue;
                for (Enum enum_ : subFeatures) {
                    String subFeatureLowerCase = enum_.name().toLowerCase();
                    Property subFeatureEntry = (Property)featureCategory.computeIfAbsent((Object)subFeatureLowerCase, x -> new Property(subFeatureLowerCase, "true", Property.Type.BOOLEAN));
                    ((ISubFeature)((Object)enum_)).setEnabled(feature.isEnabled() && subFeatureEntry.getBoolean(true));
                    subFeatureEntry.setComment(((ISubFeature)((Object)enum_)).getDescription());
                }
            }
            config.save();
        }
    }

    public static class TicksLoop
    implements Runnable {
        @Override
        public void run() {
            List<IItemDefinition> list = CrazyAE.definitions().items().getCreativeTabIcons();
            if (iconTicks >= list.size()) {
                iconTicks = 0;
            }
            oneToSixteenTicks = oneToSixteenTicks >= 16 ? 0 : ++oneToSixteenTicks;
            list.get(iconTicks).maybeStack(1).ifPresent(is -> icon = is);
            ++iconTicks;
        }
    }
}

