/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.core;

import appeng.core.AEConfig;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import dev.beecube31.crazyae2.craftsystem.CrazyCraftingJob;
import java.util.Collection;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class Ticker {
    public static final Ticker INSTANCE = new Ticker();
    private final Multimap<World, CrazyCraftingJob> craftingJobs = LinkedListMultimap.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onTickEv(TickEvent ev) {
        if (ev.type == TickEvent.Type.WORLD && ev.phase == TickEvent.Phase.END) {
            TickEvent.WorldTickEvent wte = (TickEvent.WorldTickEvent)ev;
            Multimap<World, CrazyCraftingJob> multimap = this.craftingJobs;
            synchronized (multimap) {
                Collection jobSet = this.craftingJobs.get((Object)wte.world);
                if (!jobSet.isEmpty()) {
                    int jobSize = jobSet.size();
                    int microSecondsPerTick = AEConfig.instance().getCraftingCalculationTimePerTick() * 1000;
                    int simTime = Math.max(1, microSecondsPerTick / jobSize);
                    jobSet.removeIf(cj -> !cj.simulateFor(simTime));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCraftingSimulation(World world, CrazyCraftingJob craftingJob) {
        Multimap<World, CrazyCraftingJob> multimap = this.craftingJobs;
        synchronized (multimap) {
            this.craftingJobs.put((Object)world, (Object)craftingJob);
        }
    }
}

