/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.core.cache.impl;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridCache;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridStorage;
import appeng.api.networking.crafting.ICraftingCallback;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.crafting.ICraftingWatcher;
import appeng.api.networking.crafting.ICraftingWatcherHost;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPostCacheConstruction;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellProvider;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.crafting.CraftingJob;
import appeng.me.helpers.BaseActionSource;
import appeng.me.helpers.GenericInterestManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import dev.beecube31.crazyae2.common.interfaces.craftsystem.ICrazyCraftHost;
import dev.beecube31.crazyae2.common.interfaces.craftsystem.ICrazyCraftingMethod;
import dev.beecube31.crazyae2.common.interfaces.craftsystem.ICrazyCraftingProviderHelper;
import dev.beecube31.crazyae2.common.interfaces.craftsystem.ICrazyInterfaceHost;
import dev.beecube31.crazyae2.common.networking.events.MECraftHostPatternsChangedEv;
import dev.beecube31.crazyae2.common.networking.events.MECraftHostStateUpdateEv;
import dev.beecube31.crazyae2.common.networking.events.MEInterfaceHostStateUpdateEv;
import dev.beecube31.crazyae2.core.cache.ICrazyAutocraftingSystem;
import dev.beecube31.crazyae2.craftsystem.CrazyCraftingJob;
import dev.beecube31.crazyae2.craftsystem.CrazyCraftingLink;
import dev.beecube31.crazyae2.craftsystem.CrazyCraftingLinkNexus;
import dev.beecube31.crazyae2.craftsystem.CrazyCraftingWatcher;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class CrazyAutocraftingSystem
implements IGridCache,
ICellProvider,
ICrazyCraftingProviderHelper,
IMEInventoryHandler<IAEItemStack>,
ICrazyAutocraftingSystem {
    private static final ExecutorService CRAFTING_POOL;
    private static final Comparator<ICraftingPatternDetails> COMPARATOR;
    private final Set<ICrazyCraftHost> workersList = new HashSet<ICrazyCraftHost>();
    private final Set<ICrazyInterfaceHost> interfacesList = new HashSet<ICrazyInterfaceHost>();
    private final Map<IGridNode, ICraftingWatcher> craftingWatchers = new HashMap<IGridNode, ICraftingWatcher>();
    private final Map<String, CrazyCraftingLinkNexus> craftingLinks = new HashMap<String, CrazyCraftingLinkNexus>();
    private final Object2ObjectMap<ICraftingPatternDetails, List<ICrazyCraftingMethod>> craftingMethods = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<IAEItemStack, ImmutableList<ICraftingPatternDetails>> craftableItems = new Object2ObjectOpenHashMap();
    private final Set<IAEItemStack> emitableItems = new HashSet<IAEItemStack>();
    private final Multimap<IAEStack, CrazyCraftingWatcher> interests = HashMultimap.create();
    private final GenericInterestManager<CrazyCraftingWatcher> interestManager = new GenericInterestManager(this.interests);
    private Map<ICraftingPatternDetails, List<ICrazyCraftingMethod>> patternToMethodsCache = new HashMap<ICraftingPatternDetails, List<ICrazyCraftingMethod>>();
    private boolean updateList = false;
    private boolean updatePatterns = false;
    private IStorageGrid storageGrid;
    private final IGrid grid;

    public CrazyAutocraftingSystem(IGrid grid) {
        this.grid = grid;
    }

    @MENetworkEventSubscribe
    public void onCacheConstructionEndEv(MENetworkPostCacheConstruction cacheConstruction) {
        this.storageGrid = (IStorageGrid)this.grid.getCache(IStorageGrid.class);
        this.storageGrid.registerCellProvider((ICellProvider)this);
    }

    public void onUpdateTick() {
        if (this.updateList) {
            this.updateList = false;
            this.checkWorkers();
        }
        if (this.updatePatterns) {
            this.recalculateCraftingPatterns();
            this.updatePatterns = false;
        }
        this.craftingLinks.values().removeIf(crazyCraftingLinkNexus -> crazyCraftingLinkNexus.isDead(this.grid, this));
        for (ICrazyCraftHost iCrazyCraftHost : this.workersList) {
            iCrazyCraftHost.tickCraftHost(this.grid, this);
        }
        for (ICrazyInterfaceHost iCrazyInterfaceHost : this.interfacesList) {
            iCrazyInterfaceHost.tickInterfaceHost(this.grid, this);
        }
    }

    private void checkWorkers() {
        Object tile;
        this.workersList.clear();
        this.interfacesList.clear();
        int uuid = 0;
        for (Object cls : StreamSupport.stream(this.grid.getMachinesClasses().spliterator(), false).filter(ICrazyCraftHost.class::isAssignableFrom).toArray()) {
            for (IGridNode cst : this.grid.getMachines((Class)cls)) {
                tile = (ICrazyCraftHost)cst.getMachine();
                if (!(tile.getStorageCount() > 0.0)) continue;
                tile.setCpuName(" #" + ++uuid);
                this.workersList.add((ICrazyCraftHost)tile);
                if (tile.getLastLink() == null) continue;
                this.addLink(tile.getLastLink());
            }
        }
        for (Object cls : StreamSupport.stream(this.grid.getMachinesClasses().spliterator(), false).filter(ICrazyInterfaceHost.class::isAssignableFrom).toArray()) {
            for (IGridNode cst : this.grid.getMachines((Class)cls)) {
                tile = (ICrazyInterfaceHost)cst.getMachine();
                this.interfacesList.add((ICrazyInterfaceHost)tile);
            }
        }
    }

    private void recalculateCraftingPatterns() {
        IAEItemStack changedStack;
        Object2ObjectOpenHashMap oldItems = new Object2ObjectOpenHashMap(this.craftableItems);
        HashSet<IAEItemStack> oldEmitableItems = new HashSet<IAEItemStack>(this.emitableItems);
        this.craftingMethods.clear();
        this.craftableItems.clear();
        this.emitableItems.clear();
        this.patternToMethodsCache.clear();
        for (ICrazyCraftHost iCrazyCraftHost : this.workersList) {
            ((ICrazyCraftingMethod)((Object)iCrazyCraftHost)).provideCrafting(this);
        }
        for (ICrazyInterfaceHost iCrazyInterfaceHost : this.interfacesList) {
            iCrazyInterfaceHost.provideCrafting(this);
        }
        for (Map.Entry entry : this.craftingMethods.entrySet()) {
            ICraftingPatternDetails details = (ICraftingPatternDetails)entry.getKey();
            ObjectIterator patternStack = details.getPattern();
            if (patternStack == null || patternStack.func_190926_b()) continue;
            this.patternToMethodsCache.computeIfAbsent(details, k -> new ArrayList()).addAll((Collection)entry.getValue());
        }
        Object2ObjectOpenHashMap tmpCraft = new Object2ObjectOpenHashMap();
        for (ICraftingPatternDetails details : this.craftingMethods.keySet()) {
            for (ObjectIterator out : details.getOutputs()) {
                if (out == null) continue;
                out = out.copy();
                out.reset();
                out.setCraftable(true);
                ObjectSet methods = (ObjectSet)tmpCraft.get((Object)out);
                if (methods == null) {
                    methods = new ObjectRBTreeSet(COMPARATOR);
                    tmpCraft.put((Object)out, (Object)methods);
                }
                methods.add((Object)details);
            }
        }
        for (Map.Entry e : tmpCraft.entrySet()) {
            this.craftableItems.put((Object)((IAEItemStack)e.getKey()), (Object)ImmutableList.copyOf((Collection)((Collection)e.getValue())));
        }
        ArrayList<IAEItemStack> arrayList = new ArrayList<IAEItemStack>();
        ObjectSet i = oldItems.entrySet();
        for (Map.Entry ais : i) {
            if (this.craftableItems.containsKey(ais.getKey())) continue;
            IAEItemStack changedStack2 = ((IAEItemStack)ais.getKey()).copy();
            changedStack2.reset();
            changedStack2.setCraftable(false);
            arrayList.add(changedStack2);
        }
        ObjectSet j = this.craftableItems.entrySet();
        for (Map.Entry ais : j) {
            if (oldItems.containsKey((Object)ais)) continue;
            changedStack = ((IAEItemStack)ais.getKey()).copy();
            changedStack.reset();
            changedStack.setCraftable(true);
            arrayList.add(changedStack);
        }
        for (IAEItemStack st : oldEmitableItems) {
            if (this.emitableItems.contains(st)) continue;
            changedStack = st.copy();
            changedStack.reset();
            changedStack.setCraftable(false);
            arrayList.add(changedStack);
        }
        for (IAEItemStack st : this.emitableItems) {
            if (oldEmitableItems.contains(st)) continue;
            changedStack = st.copy();
            changedStack.reset();
            changedStack.setCraftable(true);
            arrayList.add(changedStack);
        }
        this.storageGrid.postCraftablesChanges(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class), arrayList, (IActionSource)new BaseActionSource());
    }

    public void addLink(CrazyCraftingLink link) {
        if (link.isStandalone()) {
            return;
        }
        CrazyCraftingLinkNexus nexus = this.craftingLinks.computeIfAbsent(link.getCraftingID(), k -> new CrazyCraftingLinkNexus(link.getCraftingID()));
        link.setNexus(nexus);
    }

    @MENetworkEventSubscribe
    public void updateWorkers(MECraftHostStateUpdateEv c) {
        this.updateList = true;
    }

    @MENetworkEventSubscribe
    public void updateCPUClusters(MECraftHostPatternsChangedEv c) {
        this.updatePatterns = true;
    }

    @MENetworkEventSubscribe
    public void updateInterfaces(MEInterfaceHostStateUpdateEv c) {
        this.updatePatterns = true;
    }

    public void removeNode(@NotNull IGridNode iGridNode, @NotNull IGridHost iGridHost) {
        Object craftingWatcher;
        if (iGridHost instanceof ICraftingWatcherHost && (craftingWatcher = this.craftingWatchers.get(iGridHost)) != null) {
            craftingWatcher.reset();
            this.craftingWatchers.remove(iGridHost);
        }
        if (iGridHost instanceof ICraftingRequester) {
            for (CrazyCraftingLinkNexus link : this.craftingLinks.values()) {
                link.removeNode();
            }
        }
        if (iGridHost instanceof ICrazyCraftHost) {
            ICrazyCraftHost r = (ICrazyCraftHost)iGridHost;
            this.workersList.remove(r);
            this.updateList = true;
            this.updatePatterns = true;
        }
        if (iGridHost instanceof ICrazyInterfaceHost) {
            ICrazyInterfaceHost h = (ICrazyInterfaceHost)iGridHost;
            this.interfacesList.remove(h);
            this.updateList = true;
            this.updatePatterns = true;
        }
    }

    public void addNode(@NotNull IGridNode iGridNode, @NotNull IGridHost iGridHost) {
        if (iGridHost instanceof ICraftingWatcherHost) {
            ICraftingWatcherHost watcherHost = (ICraftingWatcherHost)iGridHost;
            CrazyCraftingWatcher watcher = new CrazyCraftingWatcher(this, watcherHost);
            this.craftingWatchers.put(iGridNode, watcher);
            watcherHost.updateWatcher((ICraftingWatcher)watcher);
        }
        if (iGridHost instanceof ICrazyCraftHost) {
            ICrazyCraftHost r = (ICrazyCraftHost)iGridHost;
            this.workersList.add(r);
            this.updateList = true;
            this.updatePatterns = true;
        }
        if (iGridHost instanceof ICrazyInterfaceHost) {
            ICrazyInterfaceHost h = (ICrazyInterfaceHost)iGridHost;
            this.interfacesList.add(h);
            this.updateList = true;
            this.updatePatterns = true;
        }
    }

    public GenericInterestManager<CrazyCraftingWatcher> getInterestManager() {
        return this.interestManager;
    }

    public void onSplit(@NotNull IGridStorage iGridStorage) {
    }

    public void onJoin(@NotNull IGridStorage iGridStorage) {
    }

    public void populateGridStorage(@NotNull IGridStorage iGridStorage) {
    }

    @Override
    public ImmutableCollection<ICraftingPatternDetails> getCraftingFor(IAEItemStack whatToCraft, ICraftingPatternDetails details, int slotIndex, World world) {
        ImmutableList res = (ImmutableList)this.craftableItems.get((Object)whatToCraft);
        if (res == null) {
            return ImmutableSet.of();
        }
        return res;
    }

    @Override
    public boolean canEmitFor(IAEItemStack var1) {
        return this.emitableItems.contains(var1);
    }

    @Override
    public ICraftingLink submitCraftingJob(ICraftingJob job, ICraftingRequester requester, ICrazyCraftHost host, IActionSource src) {
        Preconditions.checkNotNull((Object)job, (Object)"Cannot submit a null ICraftingJob");
        if (job.isSimulation() || job instanceof CraftingJob) {
            return null;
        }
        ArrayList<ICrazyCraftHost> freeWorkers = new ArrayList<ICrazyCraftHost>(this.getFreeWorkers());
        if (!freeWorkers.isEmpty()) {
            freeWorkers.sort(Comparator.comparingDouble(ICrazyCraftHost::getAcceleratorCount).thenComparingDouble(ICrazyCraftHost::getStorageCount));
            return ((ICrazyCraftHost)freeWorkers.get(0)).pushJob(job, requester, src);
        }
        return null;
    }

    @Override
    public Future<ICraftingJob> beginCraftingJob(World world, IGrid grid, IActionSource source, IAEItemStack ais, ICraftingCallback callback) {
        Preconditions.checkArgument((world != null && grid != null && source != null && ais != null ? 1 : 0) != 0, (Object)"Invalid crafting job request provided");
        CrazyCraftingJob job = new CrazyCraftingJob(world, grid, source, ais, callback);
        return CRAFTING_POOL.submit(job, job);
    }

    @Override
    public Set<ICrazyCraftHost> getFreeWorkers() {
        return this.workersList.stream().filter(ic -> !ic.isBusy()).collect(Collectors.toSet());
    }

    @Override
    public Set<ICrazyCraftHost> getBusyWorkers() {
        return this.workersList.stream().filter(ICrazyCraftHost::isBusy).collect(Collectors.toSet());
    }

    @Override
    public Set<ICrazyCraftHost> getWorkers() {
        return Collections.unmodifiableSet(this.workersList);
    }

    @Override
    public Set<ICrazyInterfaceHost> findInterfaceByDetails(ICraftingPatternDetails details) {
        HashSet<ICrazyInterfaceHost> out = new HashSet<ICrazyInterfaceHost>();
        if (details == null) {
            return out;
        }
        for (ICrazyInterfaceHost host : this.interfacesList) {
            if (host.isBusy() || !host.canAcceptPattern(details)) continue;
            out.add(host);
        }
        return out;
    }

    @Override
    public boolean containsCraftingItem(IAEItemStack req) {
        return this.craftableItems.keySet().stream().anyMatch(is -> is == req || is.getDefinition() == req.getDefinition());
    }

    @Override
    public void addCraftingOption(ICrazyCraftingMethod crafter, ICraftingPatternDetails patternDetails) {
        List methodsForPattern = (List)this.craftingMethods.computeIfAbsent((Object)patternDetails, k -> new ArrayList());
        if (!methodsForPattern.contains(crafter)) {
            methodsForPattern.add(crafter);
        }
    }

    @Override
    public void setEmitable(IAEItemStack var1) {
        this.emitableItems.add(var1.copy());
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel<?> iStorageChannel) {
        ArrayList<IMEInventoryHandler> list = new ArrayList<IMEInventoryHandler>(1);
        if (iStorageChannel == AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
            list.add(this);
        }
        return list;
    }

    public AccessRestriction getAccess() {
        return AccessRestriction.WRITE;
    }

    public boolean isPrioritized(IAEItemStack iaeItemStack) {
        return true;
    }

    public boolean canAccept(IAEItemStack iaeItemStack) {
        for (ICrazyCraftHost cpu : this.workersList) {
            if (!cpu.canAccept(iaeItemStack)) continue;
            return true;
        }
        return false;
    }

    public int getPriority() {
        return 0;
    }

    public int getSlot() {
        return 0;
    }

    public boolean validForPass(int i) {
        return i == 1;
    }

    public IAEItemStack injectItems(IAEItemStack iaeItemStack, Actionable actionable, IActionSource iActionSource) {
        for (ICrazyCraftHost cpu : this.workersList) {
            iaeItemStack = cpu.injectItems(iaeItemStack, actionable, iActionSource);
        }
        return iaeItemStack;
    }

    public IAEItemStack extractItems(IAEItemStack iaeItemStack, Actionable actionable, IActionSource iActionSource) {
        return null;
    }

    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> iItemList) {
        for (IAEItemStack stack : this.craftableItems.keySet()) {
            iItemList.addCrafting((IAEStack)stack);
        }
        for (IAEItemStack st : this.emitableItems) {
            iItemList.addCrafting((IAEStack)st);
        }
        return iItemList;
    }

    public IStorageChannel<IAEItemStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }

    static {
        ThreadFactory factory = ar -> new Thread(ar, "CrazyAE Crafting Calculator");
        CRAFTING_POOL = Executors.newCachedThreadPool(factory);
        COMPARATOR = (firstDetail, nextDetail) -> nextDetail.getPriority() - firstDetail.getPriority();
    }
}

