/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.core.cache.impl;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridCache;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridStorage;
import dev.beecube31.crazyae2.common.interfaces.IChannelsMultiplier;
import dev.beecube31.crazyae2.core.cache.IGridChannelBoostersCache;
import dev.beecube31.crazyae2.core.config.CrazyAEConfig;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class GridChannelBoostersCache
implements IGridCache,
IGridChannelBoostersCache {
    private static final HashMap<IChannelsMultiplier, Integer> boosters = new HashMap();
    private int channels = 0;
    private int creativeBoostersAmt;
    private final IGrid grid;

    public GridChannelBoostersCache(IGrid grid) {
        this.grid = grid;
    }

    public void onUpdateTick() {
    }

    public void removeNode(@NotNull IGridNode iGridNode, @NotNull IGridHost iGridHost) {
        if (iGridHost instanceof IChannelsMultiplier) {
            IChannelsMultiplier r = (IChannelsMultiplier)iGridHost;
            if (boosters.containsKey(iGridHost)) {
                if (r.isCreative()) {
                    boosters.remove(r, Integer.MAX_VALUE);
                    if (this.creativeBoostersAmt == 1) {
                        this.channels = 0;
                    }
                    --this.creativeBoostersAmt;
                    return;
                }
                int channelsAmt = CrazyAEConfig.QCMBoostAmt;
                boosters.remove(r, channelsAmt);
                this.channels -= channelsAmt;
            }
        }
    }

    public void addNode(@NotNull IGridNode iGridNode, @NotNull IGridHost iGridHost) {
        if (iGridHost instanceof IChannelsMultiplier) {
            IChannelsMultiplier r = (IChannelsMultiplier)iGridHost;
            if (!boosters.containsKey(iGridHost)) {
                if (r.isCreative()) {
                    this.channels = Integer.MAX_VALUE;
                    ++this.creativeBoostersAmt;
                    boosters.put(r, Integer.MAX_VALUE);
                    return;
                }
                if (this.channels < Integer.MAX_VALUE) {
                    int channelsAmt = CrazyAEConfig.QCMBoostAmt;
                    boosters.put(r, channelsAmt);
                    this.channels += channelsAmt;
                }
            }
        }
    }

    public void onSplit(@NotNull IGridStorage iGridStorage) {
    }

    public void onJoin(@NotNull IGridStorage iGridStorage) {
    }

    public void populateGridStorage(@NotNull IGridStorage iGridStorage) {
    }

    @Override
    public int getChannels() {
        return this.channels;
    }

    @Override
    public boolean isForcingCreativeMultiplier() {
        return this.creativeBoostersAmt > 0;
    }

    @Override
    public int getActiveBoosters() {
        return boosters.size();
    }
}

