/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.core.client;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="crazyae", value={Side.CLIENT})
@Config(modid="crazyae", name="crazyae-client", category="client")
public final class CrazyAEClientConfig
extends Configuration {
    private static Configuration config;
    private static int colorizerColorRed;
    private static int colorizerColorGreen;
    private static int colorizerColorBlue;
    private static int colorizerTextColorRed;
    private static int colorizerTextColorGreen;
    private static int colorizerTextColorBlue;
    private static int tooltipIconsIndentationSize;
    private static boolean isColorizingEnabled;
    private static boolean isAdvancedTooltipsEnabled;

    public static void init(Configuration configuration) {
        if (config == null) {
            config = configuration;
            CrazyAEClientConfig.updateConfig();
        }
    }

    private static void updateConfig() {
        if (config == null) {
            throw new IllegalStateException("null config");
        }
        colorizerColorRed = CrazyAEClientConfig.getIntKey("client", "colorizerColorRed", colorizerColorRed, 0, 255, "Red color for the Gui colorizer.").getInt();
        colorizerColorGreen = CrazyAEClientConfig.getIntKey("client", "colorizerColorGreen", colorizerColorGreen, 0, 255, "Green color for the Gui colorizer.").getInt();
        colorizerColorBlue = CrazyAEClientConfig.getIntKey("client", "colorizerColorBlue", colorizerColorBlue, 0, 255, "Blue color for the Gui colorizer.").getInt();
        colorizerTextColorRed = CrazyAEClientConfig.getIntKey("client", "colorizerTextColorRed", colorizerTextColorRed, 0, 255, "Text red color for the Gui colorizer.").getInt();
        colorizerTextColorGreen = CrazyAEClientConfig.getIntKey("client", "colorizerTextColorGreen", colorizerTextColorGreen, 0, 255, "Text green color for the Gui colorizer.").getInt();
        colorizerTextColorBlue = CrazyAEClientConfig.getIntKey("client", "colorizerTextColorBlue", colorizerTextColorBlue, 0, 255, "Text blue color for the Gui colorizer.").getInt();
        isColorizingEnabled = CrazyAEClientConfig.getBooleanKey("client", "isColorizingEnabled", isColorizingEnabled, "Enable GUI & Text colorizing?").getBoolean();
        tooltipIconsIndentationSize = CrazyAEClientConfig.getIntKey("client", "tooltipIconsIndentationSize", tooltipIconsIndentationSize, 0, 16, "Indentation length for advanced tooltips").getInt();
        isAdvancedTooltipsEnabled = CrazyAEClientConfig.getBooleanKey("client", "isAdvancedTooltipsEnabled", isAdvancedTooltipsEnabled, "Enable advanced tooltips with icons for AE2 and CrazyAE?").getBoolean();
        config.save();
    }

    public static Property getIntKey(String category, String key, int defaultValue, int min, int max, String comment) {
        Property property = config.get(category, key, defaultValue);
        property.setDefaultValue(defaultValue);
        property.setMinValue(min);
        property.setMaxValue(max);
        property.setComment(comment);
        return property;
    }

    public static Property getBooleanKey(String category, String key, boolean defaultValue, String comment) {
        Property property = config.get(category, key, defaultValue);
        property.setDefaultValue(defaultValue);
        property.setComment(comment);
        return property;
    }

    static void updateIntKey(String category, String key, int defaultValue, int min, int max, String comment, int newValue) {
        CrazyAEClientConfig.getIntKey(category, key, defaultValue, min, max, comment).set(newValue);
        CrazyAEClientConfig.updateConfig();
    }

    static void updateBooleanKey(String category, String key, boolean defaultValue, String comment, boolean newValue) {
        CrazyAEClientConfig.getBooleanKey(category, key, defaultValue, comment).set(newValue);
        CrazyAEClientConfig.updateConfig();
    }

    static Configuration getConfig() {
        return config;
    }

    public static boolean isColorizingEnabled() {
        return isColorizingEnabled;
    }

    public static boolean isAdvancedTooltipsEnabled() {
        return isAdvancedTooltipsEnabled;
    }

    public static int getColorizerColorRed() {
        return colorizerColorRed;
    }

    public static int getColorizerColorGreen() {
        return colorizerColorGreen;
    }

    public static int getColorizerColorBlue() {
        return colorizerColorBlue;
    }

    public static int getColorizerTextColorRed() {
        return colorizerTextColorRed;
    }

    public static int getColorizerTextColorGreen() {
        return colorizerTextColorGreen;
    }

    public static int getColorizerTextColorBlue() {
        return colorizerTextColorBlue;
    }

    public static int getTooltipsIndentationSize() {
        return tooltipIconsIndentationSize;
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("crazyae")) {
            CrazyAEClientConfig.updateConfig();
        }
    }

    static {
        colorizerColorRed = 255;
        colorizerColorGreen = 255;
        colorizerColorBlue = 255;
        colorizerTextColorRed = 0;
        colorizerTextColorGreen = 0;
        colorizerTextColorBlue = 0;
        tooltipIconsIndentationSize = 4;
        isColorizingEnabled = true;
        isAdvancedTooltipsEnabled = true;
    }
}

