/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.core.client;

import appeng.api.implementations.items.IItemGroup;
import appeng.util.Platform;
import com.google.common.base.Preconditions;
import dev.beecube31.crazyae2.client.gui.sprites.ISpriteProvider;
import dev.beecube31.crazyae2.core.client.CrazyAEClientConfig;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CrazyAEClientHandler {
    public static final String ICON_INDENTATION = CrazyAEClientHandler.getIconIndentation();

    private static String getIconIndentation() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < CrazyAEClientConfig.getTooltipsIndentationSize(); ++i) {
            s.append(" ");
        }
        return s.toString();
    }

    public static Collator getLocaleCollator() {
        Locale javaLocale = Minecraft.func_71410_x().func_135016_M().func_135041_c().getJavaLocale();
        return Collator.getInstance(javaLocale);
    }

    public static String getUpgradeLocalizedName(ItemStack stack, int limit, Set<ItemStack> groupContextKeys) {
        Set<ItemStack> context;
        IItemGroup ig;
        String str;
        String name = null;
        Item itemFromStack = stack.func_77973_b();
        if (itemFromStack instanceof IItemGroup && (str = (ig = (IItemGroup)itemFromStack).getUnlocalizedGroupName(context = groupContextKeys != null && !groupContextKeys.isEmpty() ? groupContextKeys : Collections.singleton(stack), stack)) != null) {
            name = Platform.gui_localize((String)str) + (limit > 1 ? " (" + limit + ')' : "");
        }
        if (name == null) {
            name = stack.func_82833_r() + (limit > 1 ? " (" + limit + ')' : "");
        }
        return name;
    }

    public static List<Map.Entry<ItemStack, Integer>> getSortedItemEntries(Map<ItemStack, Integer> entriesMap, Set<ItemStack> groupContextKeys) {
        ArrayList<Map.Entry<ItemStack, Integer>> sortedList = new ArrayList<Map.Entry<ItemStack, Integer>>(entriesMap.entrySet());
        Collator localeCollator = CrazyAEClientHandler.getLocaleCollator();
        if (localeCollator != null) {
            sortedList.sort((e1, e2) -> {
                String name1 = CrazyAEClientHandler.getUpgradeLocalizedName((ItemStack)e1.getKey(), (Integer)e1.getValue(), groupContextKeys);
                String name2 = CrazyAEClientHandler.getUpgradeLocalizedName((ItemStack)e2.getKey(), (Integer)e2.getValue(), groupContextKeys);
                return localeCollator.compare(name1, name2);
            });
        }
        return sortedList;
    }

    public static void renderItemIntoGUI(ItemStack stack, int x, int y, float scale) {
        Preconditions.checkNotNull((Object)stack);
        Minecraft mc = Minecraft.func_71410_x();
        RenderItem itemRenderer = mc.func_175599_af();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)100.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        RenderHelper.func_74520_c();
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)515);
        IBakedModel model = itemRenderer.func_184393_a(stack, null, null);
        itemRenderer.func_180454_a(stack, model);
        GlStateManager.func_179097_i();
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
    }

    public static void drawItemIntoTooltip(ItemStack stack, int finalIconDrawX, int finalIconDrawY) {
        if (stack.func_190926_b()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        RenderItem itemRenderer = mc.func_175599_af();
        float scale = 0.5625f;
        boolean yOffset = false;
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)finalIconDrawX, (float)((float)finalIconDrawY + (float)yOffset), (float)350.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        float originalZLevel = itemRenderer.field_77023_b;
        itemRenderer.field_77023_b = 200.0f;
        RenderHelper.func_74520_c();
        itemRenderer.func_184391_a((EntityLivingBase)mc.field_71439_g, stack, 0, 0);
        RenderHelper.func_74518_a();
        itemRenderer.field_77023_b = originalZLevel;
        GlStateManager.func_179121_F();
    }

    public static void drawSpriteIntoTooltip(ISpriteProvider sprite, int finalIconDrawX, int finalIconDrawY) {
        if (sprite == null || sprite.getTexture() == null) {
            return;
        }
        int iconHeightInText = 9;
        boolean yOffset = false;
        float scaleFactor = sprite.getSizeY() > 0 ? (float)iconHeightInText / (float)sprite.getSizeY() : 1.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)finalIconDrawX, (float)((float)finalIconDrawY + (float)yOffset), (float)350.0f);
        GlStateManager.func_179152_a((float)scaleFactor, (float)scaleFactor, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        CrazyAEClientHandler.drawSprite(sprite.getTexture(), 0, 0, sprite.getSizeX(), sprite.getSizeY());
        GlStateManager.func_179121_F();
    }

    public static int getCorrectTextLineY(int effectiveLineIndex, int initialTooltipY, int actualTitleLines, int totalEffectiveLines) {
        int currentY = initialTooltipY;
        int lineHeight = 10;
        for (int l = 0; l < effectiveLineIndex; ++l) {
            currentY += lineHeight;
            if (l + 1 != actualTitleLines || totalEffectiveLines <= actualTitleLines) continue;
            currentY += 2;
        }
        return currentY;
    }

    public static void drawSprite(ResourceLocation tex, int x, int y, int width, int height) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(tex);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    public static TooltipLayout drawTooltipAndGetComponents(@Nonnull ItemStack stack, List<String> initialTextLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, FontRenderer font) {
        if (initialTextLines == null || initialTextLines.isEmpty()) {
            return new TooltipLayout(new int[]{0, 0, 0, 0, 0}, Collections.emptyList(), Collections.emptyMap());
        }
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        ArrayList<String> effectiveLines = new ArrayList<String>(initialTextLines);
        HashMap<Integer, Integer> logicalToEffectiveMap = new HashMap<Integer, Integer>();
        int tooltipTextWidth = 0;
        for (String textLine : effectiveLines) {
            int textLineWidth = font.func_78256_a(textLine);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        boolean needsWrap = false;
        int titleActualLinesCount = initialTextLines.isEmpty() ? 0 : 1;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
            tooltipTextWidth = maxTextWidth;
            needsWrap = true;
        }
        if (tooltipTextWidth < 0) {
            tooltipTextWidth = 0;
        }
        if (needsWrap) {
            int wrappedTooltipWidth = 0;
            ArrayList<String> wrappedTextLines = new ArrayList<String>();
            int currentEffectiveIndex = 0;
            for (int i = 0; i < initialTextLines.size(); ++i) {
                logicalToEffectiveMap.put(i, currentEffectiveIndex);
                String textLine = initialTextLines.get(i);
                List wrappedLine = font.func_78271_c(textLine, tooltipTextWidth);
                if (i == 0) {
                    titleActualLinesCount = wrappedLine.size();
                }
                for (String line : wrappedLine) {
                    int lineWidth = font.func_78256_a(line);
                    if (lineWidth > wrappedTooltipWidth) {
                        wrappedTooltipWidth = lineWidth;
                    }
                    wrappedTextLines.add(line);
                    ++currentEffectiveIndex;
                }
            }
            tooltipTextWidth = wrappedTooltipWidth;
            effectiveLines = wrappedTextLines;
            tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
            if (tooltipX < 4) {
                tooltipX = 4;
            }
        } else {
            for (int i = 0; i < initialTextLines.size(); ++i) {
                logicalToEffectiveMap.put(i, i);
            }
            if (initialTextLines.isEmpty()) {
                titleActualLinesCount = 0;
            }
        }
        int tooltipY = mouseY - 12;
        int tooltipHeight = 8;
        if (!effectiveLines.isEmpty()) {
            tooltipHeight += (effectiveLines.size() - 1) * 10;
            if (effectiveLines.size() > titleActualLinesCount && titleActualLinesCount > 0) {
                tooltipHeight += 2;
            }
        } else {
            tooltipHeight = 0;
        }
        if (tooltipY < 4) {
            tooltipY = 4;
        } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 4;
        }
        if (effectiveLines.isEmpty() && tooltipTextWidth == 0) {
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
            return new TooltipLayout(new int[]{tooltipX, tooltipY, tooltipTextWidth, tooltipHeight, titleActualLinesCount}, effectiveLines, logicalToEffectiveMap);
        }
        int zLevel = 300;
        int backgroundColor = -267386864;
        int borderColorStart = 0x505000FF;
        int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
        RenderTooltipEvent.Color colorEvent = new RenderTooltipEvent.Color(stack, effectiveLines, tooltipX, tooltipY, font, backgroundColor, borderColorStart, borderColorEnd);
        MinecraftForge.EVENT_BUS.post((Event)colorEvent);
        backgroundColor = colorEvent.getBackground();
        borderColorStart = colorEvent.getBorderStart();
        borderColorEnd = colorEvent.getBorderEnd();
        CrazyAEClientHandler.drawGradientRect(300, tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, backgroundColor, backgroundColor);
        CrazyAEClientHandler.drawGradientRect(300, tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, backgroundColor, backgroundColor);
        CrazyAEClientHandler.drawGradientRect(300, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
        CrazyAEClientHandler.drawGradientRect(300, tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
        CrazyAEClientHandler.drawGradientRect(300, tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
        CrazyAEClientHandler.drawGradientRect(300, tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
        CrazyAEClientHandler.drawGradientRect(300, tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
        CrazyAEClientHandler.drawGradientRect(300, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, borderColorStart, borderColorStart);
        CrazyAEClientHandler.drawGradientRect(300, tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, borderColorEnd, borderColorEnd);
        MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostBackground(stack, effectiveLines, tooltipX, tooltipY, font, tooltipTextWidth, tooltipHeight));
        int currentTextY = tooltipY;
        for (int lineNumber = 0; lineNumber < effectiveLines.size(); ++lineNumber) {
            String line = (String)effectiveLines.get(lineNumber);
            font.func_175063_a(line, (float)tooltipX, (float)currentTextY, -1);
            if (lineNumber + 1 == titleActualLinesCount && effectiveLines.size() > titleActualLinesCount) {
                currentTextY += 2;
            }
            currentTextY += 10;
        }
        MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostText(stack, effectiveLines, tooltipX, tooltipY, font, tooltipTextWidth, tooltipHeight));
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
        GlStateManager.func_179091_B();
        return new TooltipLayout(new int[]{tooltipX, tooltipY, tooltipTextWidth, tooltipHeight, titleActualLinesCount}, effectiveLines, logicalToEffectiveMap);
    }

    public static void drawGradientRect(int zLevel, int left, int top, int right, int bottom, int startColor, int endColor) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)right, (double)top, (double)zLevel).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        buffer.func_181662_b((double)left, (double)top, (double)zLevel).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        buffer.func_181662_b((double)left, (double)bottom, (double)zLevel).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        buffer.func_181662_b((double)right, (double)bottom, (double)zLevel).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static class TooltipLayout {
        public final int[] posArray;
        public final List<String> effectiveLines;
        public final Map<Integer, Integer> logicalToEffectiveLineMap;

        public TooltipLayout(int[] posArray, List<String> effectiveLines, Map<Integer, Integer> logicalToEffectiveLineMap) {
            this.posArray = posArray;
            this.effectiveLines = effectiveLines;
            this.logicalToEffectiveLineMap = logicalToEffectiveLineMap;
        }
    }
}

