/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.core.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="crazyae")
@Config(modid="crazyae", name="crazyae")
public final class CrazyAEConfig
extends Configuration {
    @Config.Comment(value={"Capacity of the Improved Energy Cell."})
    @Config.Name(value="impEnergyCellCap")
    @Config.RangeDouble(min=0.0)
    public static double impEnergyCellCap = 1.6777216E7;
    @Config.Comment(value={"Capacity of the Advanced Energy Cell."})
    @Config.Name(value="advEnergyCellCap")
    @Config.RangeDouble(min=0.0)
    public static double advEnergyCellCap = 1.1534336E8;
    @Config.Comment(value={"Capacity of the Perfect Energy Cell."})
    @Config.Name(value="perEnergyCellCap")
    @Config.RangeDouble(min=0.0)
    public static double perEnergyCellCap = 8.05306368E8;
    @Config.Comment(value={"Capacity of the Quantum Energy Cell."})
    @Config.Name(value="quantumEnergyCellCap")
    @Config.RangeDouble(min=0.0)
    public static double quantumEnergyCellCap = 1.7179869184E10;
    @Config.Comment(value={"Quantum Channels Multiplier will give extra channels by this value. (For small cables this value will be divided by 4)"})
    @Config.Name(value="QCMBoostAmt")
    @Config.RangeInt(min=1)
    public static int QCMBoostAmt = 8;
    @Config.Comment(value={"Amount of types for Items Cells"})
    @Config.Name(value="cellItemsTypesAmt")
    @Config.RangeInt(min=1)
    public static int cellItemsTypesAmt = 63;
    @Config.Comment(value={"Amount of types for Fluid Cells"})
    @Config.Name(value="cellFluidTypesAmt")
    @Config.RangeInt(min=1)
    public static int cellFluidTypesAmt = 15;
    @Config.RangeDouble(min=0.0)
    public static double basicSolarPanelGenPerTick = 128.0;
    @Config.RangeDouble(min=0.0)
    public static double basicSolarPanelGenPerTickNight = 64.0;
    @Config.RangeDouble(min=0.0)
    public static double basicSolarPanelCapacity = 100000.0;
    @Config.RangeDouble(min=0.0)
    public static double improvedSolarPanelGenPerTick = 512.0;
    @Config.RangeDouble(min=0.0)
    public static double improvedSolarPanelGenPerTickNight = 256.0;
    @Config.RangeDouble(min=0.0)
    public static double improvedSolarPanelCapacity = 400000.0;
    @Config.RangeDouble(min=0.0)
    public static double advancedSolarPanelGenPerTick = 6144.0;
    @Config.RangeDouble(min=0.0)
    public static double advancedSolarPanelGenPerTickNight = 3072.0;
    @Config.RangeDouble(min=0.0)
    public static double advancedSolarPanelCapacity = 1.6E7;
    @Config.RangeDouble(min=0.0)
    public static double perfectSolarPanelGenPerTick = 32768.0;
    @Config.RangeDouble(min=0.0)
    public static double perfectSolarPanelGenPerTickNight = 16384.0;
    @Config.RangeDouble(min=0.0)
    public static double perfectSolarPanelCapacity = 6.4E7;
    @Config.RangeInt(min=1)
    public static int improvedMolecularAssemblerMaxQueueSize = 160;
    @Config.RangeInt(min=1)
    public static int improvedMolecularAssemblerCraftsPerTickWithoutUpgrades = 8;
    @Config.RangeInt(min=1)
    public static int improvedMolecularAssemblerCraftsPerTickWith1Upgrade = 16;
    @Config.RangeInt(min=1)
    public static int improvedMolecularAssemblerCraftsPerTickWith2Upgrades = 32;
    @Config.RangeInt(min=1)
    public static int improvedMolecularAssemblerCraftsPerTickWith3Upgrades = 64;
    @Config.RangeInt(min=1)
    public static int improvedMolecularAssemblerCraftsPerTickWith4Upgrades = 128;
    @Config.RangeInt(min=1)
    public static int improvedMolecularAssemblerCraftsPerTickWith5Upgrades = 160;
    @Config.Name(value="disableUpdatesCheck")
    @Config.Comment(value={"Disables updates checking."})
    public static boolean disableUpdatesCheck = false;
    @Config.Name(value="disableTierSystemForEnergyBuses")
    @Config.Comment(value={"Disables tier system for energy buses"})
    public static boolean disableTierSystemForEnergyBuses = false;
    public static final CrazyAEFixesConfig aeFixes;

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("crazyae")) {
            ConfigManager.sync((String)"crazyae", (Config.Type)Config.Type.INSTANCE);
        }
    }

    static {
        ConfigManager.sync((String)"crazyae", (Config.Type)Config.Type.INSTANCE);
        aeFixes = new CrazyAEFixesConfig();
    }

    public static class CrazyAEFixesConfig {
        @Config.Comment(value={"Enable Molecular Assembler Crafting Animation? (disabling this may increase your FPS!)"})
        @Config.RequiresMcRestart
        public boolean disableMolecularAssemblerCraftingAnimation = false;
    }
}

