/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.craftsystem;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.CraftingItemList;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.features.AEFeature;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketCraftingToast;
import appeng.me.GridAccessException;
import appeng.me.cache.CraftingGridCache;
import appeng.tile.crafting.TileCraftingMonitorTile;
import appeng.util.Platform;
import com.google.common.base.Preconditions;
import dev.beecube31.crazyae2.common.interfaces.craftsystem.ICrazyCraftHost;
import dev.beecube31.crazyae2.common.tile.base.CrazyAENetworkInvOCTile;
import dev.beecube31.crazyae2.common.util.Utils;
import dev.beecube31.crazyae2.core.cache.ICrazyAutocraftingSystem;
import dev.beecube31.crazyae2.core.cache.impl.CrazyAutocraftingSystem;
import dev.beecube31.crazyae2.craftsystem.CrazyCraftingInventory;
import dev.beecube31.crazyae2.craftsystem.CrazyCraftingLink;
import dev.beecube31.crazyae2.craftsystem.CrazyCraftingWatcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public abstract class CrazyCraftContainer
extends CrazyAENetworkInvOCTile
implements ICrazyCraftHost {
    private static final String LOG_MARK_AS_COMPLETE = "CrazyCraftContainer :: Completed job for %s.";
    protected final long[] usedOps = new long[3];
    protected ICraftingLink myLastLink;
    protected final Map<ICraftingPatternDetails, TaskProgress> tasks = new HashMap<ICraftingPatternDetails, TaskProgress>();
    protected CrazyCraftingInventory inventory = new CrazyCraftingInventory();
    protected IItemList<IAEItemStack> waitingFor = ((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createList();
    protected final List<TileCraftingMonitorTile> status = new ArrayList<TileCraftingMonitorTile>();
    protected final HashMap<IMEMonitorHandlerReceiver<IAEItemStack>, Object> listeners = new HashMap();
    protected long remainingOperations;
    protected long lastTime;
    protected long elapsedTime;
    protected double remainingItemCount;
    protected double startItemCount;
    protected UUID requestingPlayerUUID;
    protected IAEItemStack finalOutput;
    protected boolean waiting = false;
    protected boolean isComplete = true;
    protected boolean somethingChanged;

    public void addStorage(IAEItemStack extractItems) {
        this.inventory.injectItems(extractItems, Actionable.MODULATE, null);
    }

    public void addEmitable(IAEItemStack i) {
        this.waitingFor.add((IAEStack)i);
        this.postCraftingStatusChange(i);
    }

    @Override
    public void getListOfItem(IItemList<IAEItemStack> list, CraftingItemList whichList) {
        switch (whichList) {
            case ACTIVE: {
                for (IAEItemStack ais : this.waitingFor) {
                    list.add((IAEStack)ais);
                }
                break;
            }
            case PENDING: {
                for (Map.Entry<ICraftingPatternDetails, TaskProgress> t : this.tasks.entrySet()) {
                    for (IAEItemStack ais : t.getKey().getCondensedOutputs()) {
                        ais = ais.copy();
                        ais.setStackSize(ais.getStackSize() * t.getValue().value());
                        list.add((IAEStack)ais);
                    }
                }
                break;
            }
            case STORAGE: {
                this.inventory.getAvailableItems(list);
                break;
            }
            default: {
                this.inventory.getAvailableItems(list);
                for (IAEItemStack ais : this.waitingFor) {
                    list.add((IAEStack)ais);
                }
                for (Map.Entry<ICraftingPatternDetails, TaskProgress> t : this.tasks.entrySet()) {
                    for (IAEItemStack ais : t.getKey().getCondensedOutputs()) {
                        ais = ais.copy();
                        ais.setStackSize(ais.getStackSize() * t.getValue().value());
                        list.add((IAEStack)ais);
                    }
                }
            }
        }
    }

    protected void prepareElapsedTime() {
        this.lastTime = System.nanoTime();
        this.elapsedTime = 0L;
        IItemList list = ((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createList();
        this.getListOfItem((IItemList<IAEItemStack>)list, CraftingItemList.ACTIVE);
        this.getListOfItem((IItemList<IAEItemStack>)list, CraftingItemList.PENDING);
        double itemCount = 0.0;
        for (IAEItemStack ge : list) {
            itemCount += (double)ge.getStackSize();
        }
        this.startItemCount = itemCount;
        this.remainingItemCount = itemCount;
    }

    protected void completeJob() {
        if (this.isComplete && this.tasks.isEmpty() && this.waitingFor.isEmpty()) {
            return;
        }
        this.isComplete = true;
        if (this.myLastLink != null) {
            ((CrazyCraftingLink)this.myLastLink).markDone();
            this.myLastLink = null;
        }
        if (AELog.isCraftingLogEnabled() && this.finalOutput != null) {
            IAEItemStack logStack = this.finalOutput.copy();
            AELog.crafting((String)LOG_MARK_AS_COMPLETE, (Object[])new Object[]{logStack.getStackSize() > 0L ? logStack : "Unknown job output"});
        }
        if (!this.waitingFor.isEmpty()) {
            IItemList toPost = ((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createList();
            for (IAEItemStack stack : this.waitingFor) {
                if (stack == null || stack.getStackSize() <= 0L) continue;
                IAEItemStack negStack = stack.copy();
                negStack.setStackSize(-stack.getStackSize());
                toPost.add((IAEStack)negStack);
            }
            this.waitingFor.resetStatus();
            if (!toPost.isEmpty()) {
                for (IAEItemStack negStack : toPost) {
                    this.postCraftingStatusChange(negStack);
                    Utils.postChange(negStack, this.getActionSource(), this.getListeners());
                }
            }
        }
        this.remainingItemCount = 0.0;
        this.startItemCount = 0.0;
        this.lastTime = 0L;
        this.elapsedTime = 0L;
        this.tasks.clear();
        this.notifyRequester(false);
        this.requestingPlayerUUID = null;
        try {
            if (this.getProxy().getNode() != null) {
                this.getProxy().getTick().alertDevice(this.getProxy().getNode());
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        this.storeItems(this.getActionSource());
        this.finalOutput = null;
        this.updateCrafting();
    }

    @Override
    public void cancel(IActionSource src) {
        if (this.myLastLink != null) {
            this.myLastLink.cancel();
        }
        IItemList list = ((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createList();
        this.getListOfItem((IItemList<IAEItemStack>)list, CraftingItemList.ALL);
        for (IAEItemStack is : list) {
            Utils.postChange(is, src, this.getListeners());
        }
        this.isComplete = true;
        this.myLastLink = null;
        this.tasks.clear();
        ArrayList items = new ArrayList(this.waitingFor.size());
        this.waitingFor.forEach(stack -> items.add((IAEItemStack)stack.copy().setStackSize(-stack.getStackSize())));
        this.waitingFor.resetStatus();
        for (IAEItemStack is : items) {
            this.postCraftingStatusChange(is);
        }
        this.notifyRequester(true);
        this.requestingPlayerUUID = null;
        this.finalOutput = null;
        this.storeItems(src);
    }

    protected void storeItems(IActionSource src) {
        Preconditions.checkState((boolean)this.isComplete, (Object)"CPU should be complete to prevent re-insertion when dumping items");
        try {
            IGrid g = this.getProxy().getGrid();
            if (g == null) {
                return;
            }
            IStorageGrid sg = (IStorageGrid)g.getCache(IStorageGrid.class);
            IMEMonitor networkInv = sg.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
            IItemList currentCpuContents = ((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createList();
            this.inventory.getAvailableItems((IItemList<IAEItemStack>)currentCpuContents);
            if (currentCpuContents.isEmpty()) {
                return;
            }
            ArrayList<IAEItemStack> whatsLeftInCpu = new ArrayList<IAEItemStack>();
            boolean changed = false;
            for (IAEItemStack stackInCpu : currentCpuContents) {
                if (stackInCpu == null || stackInCpu.getStackSize() <= 0L) continue;
                IAEItemStack toInjectToNetwork = stackInCpu.copy();
                Utils.postChange(toInjectToNetwork, src, this.getListeners());
                IAEItemStack remainderFromNetwork = (IAEItemStack)networkInv.injectItems((IAEStack)toInjectToNetwork, Actionable.MODULATE, src);
                if (remainderFromNetwork != null && remainderFromNetwork.getStackSize() > 0L) {
                    whatsLeftInCpu.add(remainderFromNetwork.copy());
                }
                changed = true;
            }
            this.inventory = new CrazyCraftingInventory();
            for (IAEItemStack remainingStack : whatsLeftInCpu) {
                if (remainingStack.getStackSize() <= 0L) continue;
                this.inventory.getItemList().addStorage((IAEStack)remainingStack.copy());
            }
            if (changed) {
                this.func_70296_d();
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private void notifyRequester(boolean cancelled) {
        if (!Platform.isServer()) {
            return;
        }
        if (this.requestingPlayerUUID == null) {
            return;
        }
        if (this.finalOutput == null) {
            return;
        }
        if (!AEConfig.instance().isFeatureEnabled(AEFeature.CRAFTING_TOASTS)) {
            return;
        }
        EntityPlayer player = AppEng.proxy.getPlayerByUUID(this.requestingPlayerUUID);
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            try {
                NetworkHandler.instance().sendTo((AppEngPacket)new PacketCraftingToast(this.finalOutput, cancelled), playerMP);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.finalOutput = null;
    }

    protected void postCraftingStatusChange(IAEItemStack diff) {
        try {
            Collection list;
            if (this.getProxy().getGrid() == null) {
                return;
            }
            CraftingGridCache sg = (CraftingGridCache)this.getProxy().getGrid().getCache(ICraftingGrid.class);
            CrazyAutocraftingSystem sys = (CrazyAutocraftingSystem)this.getProxy().getGrid().getCache(ICrazyAutocraftingSystem.class);
            if (sys.getInterestManager().containsKey((IAEStack)diff) && !(list = sys.getInterestManager().get((IAEStack)diff)).isEmpty()) {
                for (CrazyCraftingWatcher iw : list) {
                    iw.getHost().onRequestChange((ICraftingGrid)sg, diff);
                }
            }
            if (sg.getInterestManager().containsKey((IAEStack)diff) && !(list = sg.getInterestManager().get((IAEStack)diff)).isEmpty()) {
                for (CrazyCraftingWatcher iw : list) {
                    iw.getHost().onRequestChange((ICraftingGrid)sg, diff);
                }
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    protected Iterator<Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object>> getListeners() {
        return this.listeners.entrySet().iterator();
    }

    protected void updateCrafting() {
        IAEItemStack send = this.finalOutput;
        if (this.finalOutput != null && this.finalOutput.getStackSize() <= 0L) {
            send = null;
        }
        for (TileCraftingMonitorTile t : this.status) {
            t.setJob(send);
        }
    }

    public static class TaskProgress {
        public long value;

        public long value() {
            return this.value;
        }
    }
}

