/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.craftsystem;

import appeng.api.networking.crafting.ICraftingCPU;
import dev.beecube31.crazyae2.common.interfaces.craftsystem.ICrazyCraftHost;
import dev.beecube31.crazyae2.craftsystem.CraftingHostType;
import javax.annotation.Nonnull;

public class CrazyCraftHostRecord
implements Comparable<CrazyCraftHostRecord> {
    private final String myName;
    private final ICrazyCraftHost cpu;
    private final ICraftingCPU aeCpu;
    private final long size;
    private final int processors;
    private final CraftingHostType type;

    public CrazyCraftHostRecord(double size, double coProcessors, ICrazyCraftHost server, CraftingHostType type) {
        this.size = (long)Math.min(size, 9.223372036854776E18);
        this.processors = (int)Math.min(coProcessors, 2.147483647E9);
        this.cpu = server;
        this.aeCpu = null;
        this.myName = server.getName();
        this.type = type;
    }

    public CrazyCraftHostRecord(double size, double coProcessors, ICraftingCPU server, CraftingHostType type) {
        this.size = (long)Math.min(size, 9.223372036854776E18);
        this.processors = (int)Math.min(coProcessors, 2.147483647E9);
        this.cpu = null;
        this.aeCpu = server;
        this.myName = server.getName();
        this.type = type;
    }

    @Override
    public int compareTo(@Nonnull CrazyCraftHostRecord o) {
        int a = Integer.compare(o.getProcessors(), this.getProcessors());
        if (a != 0) {
            return a;
        }
        return Long.compare(o.getSize(), this.getSize());
    }

    public CraftingHostType getType() {
        return this.type;
    }

    public ICrazyCraftHost getCrazyWorker() {
        return this.cpu;
    }

    public ICraftingCPU getCpu() {
        return this.aeCpu;
    }

    public String getName() {
        return this.myName;
    }

    public int getProcessors() {
        return this.processors;
    }

    public long getSize() {
        return this.size;
    }
}

