/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.craftsystem;

import appeng.api.config.Actionable;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.storage.data.IAEItemStack;
import dev.beecube31.crazyae2.common.interfaces.craftsystem.ICrazyCraftHost;
import dev.beecube31.crazyae2.craftsystem.CrazyCraftingLinkNexus;
import net.minecraft.nbt.NBTTagCompound;

public class CrazyCraftingLink
implements ICraftingLink {
    private final ICrazyCraftHost req;
    private final String CraftID;
    private final boolean standalone;
    private boolean canceled = false;
    private boolean done = false;
    private CrazyCraftingLinkNexus tie;

    public CrazyCraftingLink(NBTTagCompound data, ICrazyCraftHost req) {
        this.CraftID = data.func_74779_i("CraftID");
        this.setCanceled(data.func_74767_n("canceled"));
        this.setDone(data.func_74767_n("done"));
        this.standalone = data.func_74767_n("standalone");
        this.req = req;
    }

    public boolean isCanceled() {
        if (this.canceled) {
            return true;
        }
        if (this.done) {
            return false;
        }
        if (this.tie == null) {
            return false;
        }
        return this.tie.isCanceled();
    }

    public boolean isDone() {
        if (this.done) {
            return true;
        }
        if (this.canceled) {
            return false;
        }
        if (this.tie == null) {
            return false;
        }
        return this.tie.isDone();
    }

    public void cancel() {
        if (this.done) {
            return;
        }
        this.setCanceled(true);
        if (this.tie != null) {
            this.tie.cancel();
        }
        this.tie = null;
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("CraftID", this.CraftID);
        tag.func_74757_a("canceled", this.isCanceled());
        tag.func_74757_a("done", this.isDone());
        tag.func_74757_a("standalone", this.standalone);
        tag.func_74757_a("req", this.getRequester() != null);
    }

    public String getCraftingID() {
        return this.CraftID;
    }

    public void setNexus(CrazyCraftingLinkNexus n) {
        if (this.tie != null) {
            this.tie.remove(this);
        }
        if (this.isCanceled() && n != null) {
            n.cancel();
            this.tie = null;
            return;
        }
        this.tie = n;
        if (n != null) {
            n.add(this);
        }
    }

    public IAEItemStack injectItems(IAEItemStack input, Actionable mode) {
        if (this.tie == null || this.tie.getRequest() == null || this.tie.getRequest().getRequester() == null) {
            return input;
        }
        return this.tie.getRequest().getRequester().injectCraftedItems(this.tie.getRequest(), input, mode);
    }

    public void markDone() {
        if (this.tie != null) {
            this.tie.markDone();
        }
    }

    void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    ICrazyCraftHost getRequester() {
        return this.req;
    }

    void setDone(boolean done) {
        this.done = done;
    }
}

