/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.craftsystem;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import dev.beecube31.crazyae2.common.interfaces.craftsystem.ICrazyCraftHost;
import dev.beecube31.crazyae2.core.cache.impl.CrazyAutocraftingSystem;
import dev.beecube31.crazyae2.craftsystem.CrazyCraftingLink;

public class CrazyCraftingLinkNexus {
    private final String craftID;
    private boolean canceled = false;
    private boolean done = false;
    private int tickOfDeath = 0;
    private CrazyCraftingLink req;

    public CrazyCraftingLinkNexus(String craftID) {
        this.craftID = craftID;
    }

    public boolean isDead(IGrid g, CrazyAutocraftingSystem sys) {
        if (this.canceled || this.done) {
            return true;
        }
        CrazyCraftingLink req = this.getRequest();
        if (req == null) {
            ++this.tickOfDeath;
        } else {
            boolean hasMachine;
            boolean valid = CrazyCraftingLinkNexus.isRequesterValid(this.req);
            ICrazyCraftHost requester = req.getRequester();
            IGridNode actionableNode = requester != null ? requester.getNode() : null;
            IGrid grid = actionableNode != null ? actionableNode.getGrid() : null;
            boolean bl = hasMachine = grid != null && grid == g;
            this.tickOfDeath = valid && hasMachine ? 0 : (this.tickOfDeath += 60);
        }
        if (this.tickOfDeath > 60) {
            this.cancel();
            return true;
        }
        return false;
    }

    void cancel() {
        this.canceled = true;
        if (this.getRequest() != null) {
            this.getRequest().setCanceled(true);
            if (this.getRequest().getRequester() != null) {
                this.getRequest().getRequester().jobStateChange(this.getRequest());
            }
        }
        if (this.req != null) {
            this.req.setCanceled(true);
        }
    }

    void remove(CrazyCraftingLink craftingLink) {
        if (this.getRequest() == craftingLink) {
            this.setRequest(null);
        } else if (this.req == craftingLink) {
            this.req = null;
        }
    }

    void add(CrazyCraftingLink craftingLink) {
        if (CrazyCraftingLinkNexus.isRequesterValid(craftingLink)) {
            this.req = craftingLink;
        } else if (craftingLink.getRequester() != null) {
            this.setRequest(craftingLink);
        }
    }

    boolean isCanceled() {
        return this.canceled;
    }

    boolean isDone() {
        return this.done;
    }

    void markDone() {
        this.done = true;
        if (this.getRequest() != null) {
            this.getRequest().setDone(true);
            if (this.getRequest().getRequester() != null) {
                this.getRequest().getRequester().jobStateChange(this.getRequest());
            }
        }
        if (this.req != null) {
            this.req.setDone(true);
        }
    }

    public static boolean isRequesterValid(CrazyCraftingLink req) {
        return req.getRequester().getStorageCount() > 0.0;
    }

    public void removeNode() {
        if (this.getRequest() != null) {
            this.getRequest().setNexus(null);
        }
        this.setRequest(null);
        this.tickOfDeath = 0;
    }

    public CrazyCraftingLink getRequest() {
        return this.req;
    }

    public void setRequest(CrazyCraftingLink req) {
        this.req = req;
    }
}

