/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.craftsystem;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketInformPlayer;
import appeng.crafting.CraftBranchFailure;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import appeng.util.item.MeaningfulItemIterator;
import dev.beecube31.crazyae2.core.cache.ICrazyAutocraftingSystem;
import dev.beecube31.crazyae2.craftsystem.CrazyCraftContainer;
import dev.beecube31.crazyae2.craftsystem.CrazyCraftingInventory;
import dev.beecube31.crazyae2.craftsystem.CrazyCraftingJob;
import dev.beecube31.crazyae2.craftsystem.CrazyCraftingTreeProcess;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class CrazyCraftingTreeNode {
    private final int slot;
    private final CrazyCraftingJob job;
    private final IItemList<IAEItemStack> used = ((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createList();
    private final CrazyCraftingTreeProcess parent;
    private final World world;
    private final IAEItemStack what;
    private final ArrayList<CrazyCraftingTreeProcess> nodes = new ArrayList();
    private final ICrazyAutocraftingSystem cc;
    private final int depth;
    private int bytes = 0;
    private boolean canEmit = false;
    private long missing = 0L;
    private long howManyEmitted = 0L;
    private boolean exhausted = false;

    public CrazyCraftingTreeNode(ICrazyAutocraftingSystem cc, CrazyCraftingJob job, IAEItemStack wat, CrazyCraftingTreeProcess par, int slot, int depth) {
        this.what = wat;
        this.parent = par;
        this.slot = slot;
        this.world = job.getWorld();
        this.job = job;
        this.cc = cc;
        this.depth = depth;
        this.canEmit = cc.canEmitFor(this.what);
    }

    public void addNode() {
        if (!this.nodes.isEmpty()) {
            return;
        }
        if (this.canEmit) {
            return;
        }
        for (ICraftingPatternDetails details : this.cc.getCraftingFor(this.what, this.parent == null ? null : this.parent.details, this.slot, this.world)) {
            if (this.parent != null && (!this.notRecursive(details) || this.parent.details == details)) continue;
            this.nodes.add(new CrazyCraftingTreeProcess(this.cc, this.job, details, this, this.depth + 1));
        }
    }

    IAEItemStack request(CrazyCraftingInventory inv, long l, IActionSource src) throws CraftBranchFailure, InterruptedException {
        this.addNode();
        this.job.handlePausing();
        IItemList<IAEItemStack> inventoryList = inv.getItemList();
        ArrayList<IAEItemStack> thingsUsed = new ArrayList<IAEItemStack>();
        this.what.setStackSize(l);
        if (this.getSlot() >= 0 && this.parent != null && this.parent.details.isCraftable()) {
            boolean damageableItem;
            LinkedList<Object> itemList = new LinkedList<Object>();
            boolean bl = damageableItem = this.what.getItem().func_77645_m() || Platform.isGTDamageableItem((Item)this.what.getItem());
            if (this.parent.details.canSubstitute()) {
                for (IAEItemStack iAEItemStack : this.parent.details.getSubstituteInputs(this.slot)) {
                    IAEItemStack iAEItemStack2;
                    if (damageableItem) {
                        MeaningfulItemIterator it = new MeaningfulItemIterator(inventoryList.findFuzzy((IAEStack)this.what, FuzzyMode.IGNORE_ALL));
                        while (it.hasNext()) {
                            IAEItemStack i = (IAEItemStack)it.next();
                            if (i.getStackSize() <= 0L) continue;
                            itemList.add(i);
                        }
                    }
                    if ((iAEItemStack2 = (IAEItemStack)inventoryList.findPrecise((IAEStack)iAEItemStack)) == null || iAEItemStack2.getStackSize() <= 0L) continue;
                    itemList.add(iAEItemStack2);
                }
            } else if (damageableItem) {
                MeaningfulItemIterator it = new MeaningfulItemIterator(inventoryList.findFuzzy((IAEStack)this.what, FuzzyMode.IGNORE_ALL));
                while (it.hasNext()) {
                    IAEItemStack iAEItemStack = (IAEItemStack)it.next();
                    if (iAEItemStack.getStackSize() <= 0L) continue;
                    itemList.add(iAEItemStack);
                }
            } else {
                IAEItemStack item = (IAEItemStack)inventoryList.findPrecise((IAEStack)this.what);
                if (item != null && item.getStackSize() > 0L) {
                    itemList.add(item);
                }
            }
            for (IAEItemStack iAEItemStack : itemList) {
                IAEItemStack is;
                ItemStack is2;
                AEItemStack o;
                if (!this.parent.details.isValidItemForSlot(this.getSlot(), iAEItemStack.getDefinition(), this.world)) continue;
                IAEItemStack iAEItemStack3 = iAEItemStack.copy();
                iAEItemStack3.setStackSize(l);
                IAEItemStack available = inv.extractItems(iAEItemStack3, Actionable.MODULATE, src);
                if (available == null) continue;
                if (available.getItem().hasContainerItem(available.getDefinition()) && (o = AEItemStack.fromItemStack((ItemStack)(is2 = Platform.getContainerItem((ItemStack)available.createItemStack())))) != null) {
                    this.parent.addContainers((IAEItemStack)o);
                }
                if (!this.exhausted && (is = this.job.checkUse(available)) != null) {
                    thingsUsed.add(is.copy());
                    this.used.add((IAEStack)is);
                }
                this.bytes = (int)((long)this.bytes + available.getStackSize());
                if ((l -= available.getStackSize()) != 0L) continue;
                return available;
            }
        } else {
            IAEItemStack available = inv.extractItems(this.what, Actionable.MODULATE, src);
            if (available != null) {
                IAEItemStack is;
                if (!this.exhausted && (is = this.job.checkUse(available)) != null) {
                    thingsUsed.add(is.copy());
                    this.used.add((IAEStack)is);
                }
                this.bytes = (int)((long)this.bytes + available.getStackSize());
                if ((l -= available.getStackSize()) == 0L) {
                    return available;
                }
            }
        }
        if (this.canEmit) {
            IAEItemStack wat = this.what.copy();
            wat.setStackSize(l);
            this.howManyEmitted = wat.getStackSize();
            this.bytes = (int)((long)this.bytes + wat.getStackSize());
            return wat;
        }
        this.exhausted = true;
        if (this.nodes.size() == 1) {
            CrazyCraftingTreeProcess pro = this.nodes.get(0);
            while (pro.possible && l > 0L) {
                IAEItemStack madeWhat = pro.getAmountCrafted(this.what);
                pro.request(inv, pro.getTimes(l, madeWhat.getStackSize()), src);
                madeWhat.setStackSize(l);
                IAEItemStack available = inv.extractItems(madeWhat, Actionable.MODULATE, src);
                if (available != null) {
                    ItemStack itemStack;
                    AEItemStack o;
                    if (this.parent != null && available.getItem().hasContainerItem(available.getDefinition()) && (o = AEItemStack.fromItemStack((ItemStack)(itemStack = Platform.getContainerItem((ItemStack)available.createItemStack())))) != null) {
                        this.parent.addContainers((IAEItemStack)o);
                    }
                    this.bytes = (int)((long)this.bytes + available.getStackSize());
                    if ((l -= available.getStackSize()) > 0L) continue;
                    return available;
                }
                pro.possible = false;
            }
        } else if (this.nodes.size() > 1) {
            for (CrazyCraftingTreeProcess pro : this.nodes) {
                try {
                    while (pro.possible && l > 0L) {
                        CrazyCraftingInventory subInv = new CrazyCraftingInventory(inv, true, true, true);
                        pro.request(subInv, 1L, src);
                        this.what.setStackSize(l);
                        IAEItemStack iAEItemStack = subInv.extractItems(this.what, Actionable.MODULATE, src);
                        if (iAEItemStack != null) {
                            if (!subInv.commit(src)) {
                                throw new CraftBranchFailure(this.what, l);
                            }
                            this.bytes = (int)((long)this.bytes + iAEItemStack.getStackSize());
                            if ((l -= iAEItemStack.getStackSize()) > 0L) continue;
                            return iAEItemStack;
                        }
                        pro.possible = false;
                    }
                }
                catch (CraftBranchFailure fail) {
                    pro.possible = true;
                }
            }
        }
        if (this.job.isSimulation()) {
            ItemStack is2;
            AEItemStack o;
            this.bytes = (int)((long)this.bytes + l);
            if (this.parent != null && this.what.getItem().hasContainerItem(this.what.getDefinition()) && (o = AEItemStack.fromItemStack((ItemStack)(is2 = Platform.getContainerItem((ItemStack)((IAEItemStack)this.what.copy().setStackSize(1L)).createItemStack())))) != null) {
                this.parent.addContainers((IAEItemStack)o);
            }
            this.missing += l;
            IAEItemStack rv = this.what.copy();
            rv.setStackSize(l);
            return rv;
        }
        for (IAEItemStack o : thingsUsed) {
            this.job.refund(o.copy());
            o.setStackSize(-o.getStackSize());
            this.used.add((IAEStack)o);
        }
        throw new CraftBranchFailure(this.what, l);
    }

    boolean notRecursive(ICraftingPatternDetails details) {
        if (this.parent == null) {
            return true;
        }
        if (this.parent.details == details) {
            return false;
        }
        return this.parent.notRecursive(details);
    }

    void dive(CrazyCraftingJob job) {
        if (this.missing > 0L) {
            job.addMissing(this.getStack(this.missing));
        }
        job.addBytes(this.bytes);
        for (CrazyCraftingTreeProcess pro : this.nodes) {
            pro.dive(job);
        }
    }

    IAEItemStack getStack(long size) {
        IAEItemStack is = this.what.copy();
        is.setStackSize(size);
        return is;
    }

    void setSimulate() {
        this.missing = 0L;
        this.bytes = 0;
        this.used.resetStatus();
        this.exhausted = false;
        for (CrazyCraftingTreeProcess pro : this.nodes) {
            pro.setSimulate();
        }
    }

    public void setJob(CrazyCraftingInventory storage, CrazyCraftContainer craftingCPUCluster, IActionSource src) throws CraftBranchFailure {
        for (IAEItemStack i : this.used) {
            IAEItemStack actuallyExtracted = storage.extractItems(i, Actionable.MODULATE, src);
            if (actuallyExtracted == null || actuallyExtracted.getStackSize() != i.getStackSize()) {
                if (src.player().isPresent()) {
                    try {
                        if (actuallyExtracted == null) {
                            NetworkHandler.instance().sendTo((AppEngPacket)new PacketInformPlayer(i, null, PacketInformPlayer.InfoType.NO_ITEMS_EXTRACTED), (EntityPlayerMP)src.player().get());
                        } else {
                            NetworkHandler.instance().sendTo((AppEngPacket)new PacketInformPlayer(i, actuallyExtracted, PacketInformPlayer.InfoType.PARTIAL_ITEM_EXTRACTION), (EntityPlayerMP)src.player().get());
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw new CraftBranchFailure(i, i.getStackSize());
            }
            craftingCPUCluster.addStorage(actuallyExtracted);
        }
        if (this.howManyEmitted > 0L) {
            IAEItemStack i = (IAEItemStack)this.what.copy().reset();
            i.setStackSize(this.howManyEmitted);
            craftingCPUCluster.addEmitable(i);
        }
        for (CrazyCraftingTreeProcess pro : this.nodes) {
            pro.setJob(storage, craftingCPUCluster, src);
        }
    }

    void getPlan(IItemList<IAEItemStack> plan) {
        if (this.missing > 0L) {
            IAEItemStack o = this.what.copy();
            o.setStackSize(this.missing);
            plan.add((IAEStack)o);
        }
        if (this.howManyEmitted > 0L) {
            IAEItemStack i = this.what.copy();
            i.setCountRequestable(this.howManyEmitted);
            plan.addRequestable((IAEStack)i);
        }
        for (IAEItemStack i : this.used) {
            plan.add((IAEStack)i.copy());
        }
        for (CrazyCraftingTreeProcess pro : this.nodes) {
            pro.getPlan(plan);
        }
    }

    int getSlot() {
        return this.slot;
    }
}

