/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.craftsystem;

import appeng.api.config.Actionable;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.core.AEConfig;
import appeng.crafting.CraftBranchFailure;
import com.google.common.collect.ImmutableCollection;
import dev.beecube31.crazyae2.core.cache.ICrazyAutocraftingSystem;
import dev.beecube31.crazyae2.craftsystem.CrazyCraftContainer;
import dev.beecube31.crazyae2.craftsystem.CrazyCraftingInventory;
import dev.beecube31.crazyae2.craftsystem.CrazyCraftingJob;
import dev.beecube31.crazyae2.craftsystem.CrazyCraftingTreeNode;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.world.World;

public class CrazyCraftingTreeProcess {
    private final CrazyCraftingTreeNode parent;
    final ICraftingPatternDetails details;
    private final CrazyCraftingJob job;
    private final Object2LongArrayMap<CrazyCraftingTreeNode> nodes = new Object2LongArrayMap();
    private final int depth;
    private final ICrazyAutocraftingSystem cc;
    private final World world;
    boolean possible = true;
    private long crafts = 0L;
    private long bytes = 0L;
    private ArrayList<IAEItemStack> containers;

    public CrazyCraftingTreeProcess(ICrazyAutocraftingSystem cc, CrazyCraftingJob job, ICraftingPatternDetails details, CrazyCraftingTreeNode craftingTreeNode, int depth) {
        this.parent = craftingTreeNode;
        this.details = details;
        this.job = job;
        this.depth = depth;
        this.cc = cc;
        this.world = job.getWorld();
    }

    public void addProcess() {
        if (!this.nodes.isEmpty()) {
            return;
        }
        IAEItemStack[] list = this.details.getInputs();
        block0: for (IAEItemStack part : this.details.getCondensedInputs()) {
            if (part == null) continue;
            for (int x = 0; x < list.length; ++x) {
                IAEItemStack comparePart = list[x];
                if (!part.equals(comparePart)) continue;
                boolean isPartContainer = false;
                if (part.getItem().hasContainerItem(part.getDefinition())) {
                    part = list[x];
                    isPartContainer = true;
                }
                long wantedSize = part.getStackSize();
                if (AEConfig.instance().getEnableCraftingSubstitutes()) {
                    long requestAmount;
                    long remaining;
                    IAEItemStack found;
                    if (this.details.canSubstitute()) {
                        for (IAEItemStack subs : this.details.getSubstituteInputs(x)) {
                            found = this.job.checkAvailable(subs);
                            remaining = found != null ? found.getStackSize() : 0L;
                            if (remaining <= 0L) continue;
                            if (remaining >= wantedSize) {
                                requestAmount = wantedSize;
                                wantedSize = 0L;
                            } else {
                                requestAmount = remaining;
                                wantedSize -= remaining;
                            }
                            subs = (IAEItemStack)subs.copy().setStackSize(requestAmount);
                            CrazyCraftingTreeNode node = new CrazyCraftingTreeNode(this.cc, this.job, subs, this, x, this.depth + 1);
                            this.nodes.put((Object)node, requestAmount);
                            if (wantedSize != 0L) continue;
                            break;
                        }
                    } else {
                        found = this.job.checkAvailable(part);
                        remaining = found != null ? found.getStackSize() : 0L;
                        if (remaining > 0L) {
                            if (remaining >= wantedSize) {
                                requestAmount = wantedSize;
                                wantedSize = 0L;
                            } else {
                                requestAmount = remaining;
                                wantedSize -= remaining;
                            }
                            part = (IAEItemStack)part.copy().setStackSize(requestAmount);
                            this.nodes.put((Object)new CrazyCraftingTreeNode(this.cc, this.job, part, this, x, this.depth + 1), requestAmount);
                        }
                    }
                    if (wantedSize > 0L && this.details.canSubstitute() && this.cc.getCraftingFor(part, this.details, x, this.world).isEmpty()) {
                        ICraftingPatternDetails prioritizedPattern = null;
                        IAEItemStack prioritizedIAE = null;
                        for (IAEItemStack subs : this.details.getSubstituteInputs(x)) {
                            ImmutableCollection<ICraftingPatternDetails> detailCollection = this.cc.getCraftingFor(subs, this.details, x, this.world);
                            for (ICraftingPatternDetails sp : detailCollection) {
                                if (prioritizedPattern == null) {
                                    prioritizedPattern = sp;
                                    prioritizedIAE = subs;
                                    continue;
                                }
                                if (sp.getPriority() <= prioritizedPattern.getPriority()) continue;
                                prioritizedPattern = sp;
                            }
                            if (prioritizedIAE == null) continue;
                            subs = (IAEItemStack)subs.copy().setStackSize(wantedSize);
                            CrazyCraftingTreeNode node = new CrazyCraftingTreeNode(this.cc, this.job, subs, this, x, this.depth + 1);
                            this.nodes.put((Object)node, wantedSize);
                            wantedSize = 0L;
                            break;
                        }
                    }
                }
                if (wantedSize > 0L) {
                    part = (IAEItemStack)part.copy().setStackSize(wantedSize);
                    this.nodes.put((Object)new CrazyCraftingTreeNode(this.cc, this.job, part, this, x, this.depth + 1), wantedSize);
                    wantedSize = 0L;
                }
                if (!isPartContainer && wantedSize == 0L) continue block0;
            }
        }
    }

    boolean notRecursive(ICraftingPatternDetails details) {
        return this.parent == null || this.parent.notRecursive(details);
    }

    long getTimes(long remaining, long stackSize) {
        for (IAEItemStack part : this.details.getCondensedOutputs()) {
            for (IAEItemStack o : this.details.getCondensedInputs()) {
                if (!part.equals(o) && !o.getItem().hasContainerItem(part.getDefinition())) continue;
                return 1L;
            }
        }
        return remaining / stackSize + (long)(remaining % stackSize != 0L ? 1 : 0);
    }

    void request(CrazyCraftingInventory inv, long amountOfTimes, IActionSource src) throws CraftBranchFailure, InterruptedException {
        this.addProcess();
        this.job.handlePausing();
        for (Map.Entry entry : this.nodes.object2LongEntrySet()) {
            IAEItemStack iAEItemStack = ((CrazyCraftingTreeNode)entry.getKey()).request(inv, (Long)entry.getValue() * amountOfTimes, src);
        }
        if (this.containers != null) {
            for (IAEItemStack iae : this.containers) {
                inv.injectItems(iae, Actionable.MODULATE, src);
            }
            this.containers = null;
        }
        for (IAEItemStack out : this.details.getCondensedOutputs()) {
            IAEItemStack o = out.copy();
            o.setStackSize(o.getStackSize() * amountOfTimes);
            inv.injectItems(o, Actionable.MODULATE, src);
        }
        this.crafts += amountOfTimes;
    }

    public void addContainers(IAEItemStack container) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        this.containers.add(container);
    }

    void dive(CrazyCraftingJob job) {
        job.addTask(this.getAmountCrafted(this.parent.getStack(1L)), this.crafts, this.details, this.depth);
        for (Map.Entry entry : this.nodes.object2LongEntrySet()) {
            ((CrazyCraftingTreeNode)entry.getKey()).dive(job);
        }
        job.addBytes(this.crafts * 8L + this.bytes);
    }

    IAEItemStack getAmountCrafted(IAEItemStack what2) {
        for (IAEItemStack is : this.details.getCondensedOutputs()) {
            if (!is.isSameType(what2)) continue;
            what2 = what2.copy();
            what2.setStackSize(is.getStackSize());
            return what2;
        }
        for (IAEItemStack is : this.details.getCondensedOutputs()) {
            if (is.getItem() != what2.getItem() || !is.getItem().func_77645_m() && is.getItemDamage() != what2.getItemDamage()) continue;
            what2 = is.copy();
            what2.setStackSize(is.getStackSize());
            return what2;
        }
        throw new IllegalStateException("Crafting Tree construction failed.");
    }

    void setSimulate() {
        this.crafts = 0L;
        this.bytes = 0L;
        for (Map.Entry entry : this.nodes.object2LongEntrySet()) {
            ((CrazyCraftingTreeNode)entry.getKey()).setSimulate();
        }
    }

    void setJob(CrazyCraftingInventory storage, CrazyCraftContainer host, IActionSource src) throws CraftBranchFailure {
        host.pushDetails(this.details, this.crafts);
        for (Map.Entry entry : this.nodes.object2LongEntrySet()) {
            ((CrazyCraftingTreeNode)entry.getKey()).setJob(storage, host, src);
        }
    }

    void getPlan(IItemList<IAEItemStack> plan) {
        for (IAEItemStack i : this.details.getOutputs()) {
            i = i.copy();
            i.setCountRequestable(i.getStackSize() * this.crafts);
            plan.addRequestable((IAEStack)i);
        }
        for (Map.Entry entry : this.nodes.object2LongEntrySet()) {
            ((CrazyCraftingTreeNode)entry.getKey()).getPlan(plan);
        }
    }
}

