/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.integrations.ct;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientStack;
import crafttweaker.api.oredict.IOreDictEntry;
import dev.beecube31.crazyae2.common.recipes.botania.RecipeRepo;
import dev.beecube31.crazyae2.common.recipes.botania.RecipeTerraplate;
import dev.beecube31.crazyae2.common.util.Utils;
import dev.beecube31.crazyae2.integrations.ct.CraftTweakerPlugin;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenProperty;

@ZenClass(value="mods.crazyae.Agglomeration")
@ZenRegister
public class CTTerraplate {
    public static final String NAME = "CrazyAE Agglomeration";

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input1, IIngredient input2, IIngredient input3, int manaCost) {
        CraftTweakerPlugin.ACTIONS.add(new AddAction(CTTerraplate.buildAgglomerationRecipe(output, new IIngredient[]{input1, input2, input3}, manaCost)));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output, IIngredient input1, IIngredient input2, IIngredient input3, int manaCost) {
        CraftTweakerPlugin.ACTIONS.add(new RemoveAction(CTTerraplate.buildAgglomerationRecipe(output, new IIngredient[]{input1, input2, input3}, manaCost)));
    }

    private static RecipeTerraplate buildAgglomerationRecipe(IItemStack output, IIngredient[] inputs, int manaCostIn) {
        Preconditions.checkNotNull((Object)output, (Object)"Recipe output must be defined!");
        Preconditions.checkNotNull((Object)inputs, (Object)"Recipe inputs must be defined!");
        ImmutableList ins = ImmutableList.copyOf((Object[])CTTerraplate.mtlibToObjects(inputs));
        ItemStack out = Utils.getItemStack(output);
        return new RecipeTerraplate((ImmutableList<Object>)ins, out, manaCostIn);
    }

    public static Object[] mtlibToObjects(IIngredient[] ingredient) {
        if (ingredient == null) {
            return null;
        }
        Object[] output = new Object[ingredient.length];
        for (int i = 0; i < ingredient.length; ++i) {
            output[i] = ingredient[i] != null ? CTTerraplate.mtlibToObject(ingredient[i]) : "";
        }
        return output;
    }

    public static Object mtlibToObject(IIngredient iStack) {
        if (iStack == null) {
            return null;
        }
        if (iStack instanceof IOreDictEntry) {
            return ((IOreDictEntry)iStack).getName();
        }
        if (iStack instanceof IItemStack) {
            return Utils.getItemStack((IItemStack)iStack);
        }
        if (iStack instanceof IngredientStack) {
            return iStack.getItems();
        }
        return null;
    }

    public static class AddAction
    implements IAction {
        RecipeTerraplate recipe;

        public AddAction(RecipeTerraplate recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            RecipeRepo.add(this.recipe);
        }

        public String describe() {
            return "Adding an agglomeration recipe: " + this.recipe.toString();
        }
    }

    public static class RemoveAction
    implements IAction {
        RecipeTerraplate recipe;

        public RemoveAction(RecipeTerraplate recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            RecipeRepo.add(this.recipe);
        }

        public String describe() {
            return "Removing an agglomeration recipe: " + this.recipe.toString();
        }
    }

    @ZenClass(value="mods.crazyae.AgglomerationRecipe")
    @ZenRegister
    public static class CTAgglomerationRecipe {
        @ZenProperty
        public IItemStack output;
        @ZenProperty
        public IIngredient[] inputs;
        @ZenProperty
        public int manaCost;

        @ZenMethod
        public static CTAgglomerationRecipe create() {
            return new CTAgglomerationRecipe();
        }

        @ZenMethod
        public CTAgglomerationRecipe output(IItemStack output) {
            this.output = output;
            return this;
        }

        @ZenMethod
        public CTAgglomerationRecipe inputs(IIngredient input1, IIngredient input2, IIngredient input3) {
            this.inputs = new IIngredient[]{input1, input2, input3};
            return this;
        }

        @ZenMethod
        public CTAgglomerationRecipe manaCost(int manaCost) {
            this.manaCost = manaCost;
            return this;
        }

        RecipeTerraplate toAgglomerationRecipe() {
            return CTTerraplate.buildAgglomerationRecipe(this.output, this.inputs, this.manaCost);
        }
    }
}

