/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.mixins.core.crafting;

import appeng.api.util.WorldCoord;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.implementations.CraftingCPUCalculator;
import appeng.tile.crafting.TileCraftingTile;
import dev.beecube31.crazyae2.common.interfaces.ICrazyCraftingTile;
import dev.beecube31.crazyae2.common.tile.networking.TileCraftingUnitsCombiner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={CraftingCPUCalculator.class}, remap=false)
public class MixinCraftingCPUCalculator {
    @Overwrite
    public boolean verifyInternalStructure(World w, WorldCoord min, WorldCoord max) {
        boolean storage = false;
        for (int x = min.x; x <= max.x; ++x) {
            for (int y = min.y; y <= max.y; ++y) {
                for (int z = min.z; z <= max.z; ++z) {
                    IAEMultiBlock te = (IAEMultiBlock)w.func_175625_s(new BlockPos(x, y, z));
                    if (te == null || !te.isValid()) {
                        return false;
                    }
                    if (!storage && te instanceof ICrazyCraftingTile) {
                        ICrazyCraftingTile r = (ICrazyCraftingTile)te;
                        storage = r.getStorageCnt() > 0L;
                        continue;
                    }
                    if (!storage && te instanceof TileCraftingTile) {
                        boolean bl = storage = ((TileCraftingTile)te).getStorageBytes() > 0;
                    }
                    if (storage || !(te instanceof TileCraftingUnitsCombiner)) continue;
                    TileCraftingUnitsCombiner combiner = (TileCraftingUnitsCombiner)te;
                    storage = combiner.getStorageAmt() > 0L;
                }
            }
        }
        return storage;
    }
}

