/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.mixins.core.crafting;

import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.implementations.CraftingCPUStatus;
import dev.beecube31.crazyae2.common.interfaces.craftsystem.ICrazyCraftHost;
import dev.beecube31.crazyae2.common.interfaces.mixin.crafting.IMixinCraftingCPUStatus;
import dev.beecube31.crazyae2.common.tile.networking.TileCraftingUnitsCombiner;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CraftingCPUStatus.class}, remap=false)
public abstract class MixinCraftingCPUStatus
implements IMixinCraftingCPUStatus {
    @Shadow
    @Final
    private String name;
    @Shadow
    @Final
    private IAEItemStack crafting;
    @Shadow
    @Final
    private int serial;
    @Mutable
    @Shadow
    @Final
    private long storage;
    @Shadow
    @Final
    private long totalItems;
    @Shadow
    @Final
    private long remainingItems;
    @Unique
    private long crazyae$accelerators;
    @Unique
    private long crazyae$millisJobStarted;
    @Unique
    private String crazyae$jobInitiator;

    @Shadow
    public abstract long getStorage();

    @Override
    public long crazyae$whenJobStarted() {
        return this.crazyae$millisJobStarted;
    }

    @Override
    public void crazyae$setWhenJobStarted(long when) {
        this.crazyae$millisJobStarted = when;
    }

    @Override
    public String crazyae$jobInitiator() {
        return this.crazyae$jobInitiator;
    }

    @Override
    public void crazyae$setJobInitiator(String player) {
        this.crazyae$jobInitiator = player;
    }

    @Inject(method={"<init>(Lappeng/api/networking/crafting/ICraftingCPU;I)V"}, at={@At(value="RETURN")}, remap=false)
    private void crazyae$setOwnCount(ICraftingCPU cluster, int serial, CallbackInfo ci) {
        if (cluster instanceof ICrazyCraftHost) {
            ICrazyCraftHost r = (ICrazyCraftHost)cluster;
            this.storage = r.getAvailableStorage();
            this.crazyae$accelerators = r.getAcceleratorCount();
        } else if (cluster instanceof TileCraftingUnitsCombiner) {
            TileCraftingUnitsCombiner r = (TileCraftingUnitsCombiner)cluster;
            this.storage = r.getStorageAmt();
            this.crazyae$accelerators = r.getAcceleratorAmt();
        } else {
            this.storage = cluster.getAvailableStorage();
            this.crazyae$accelerators = cluster.getCoProcessors();
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/nbt/NBTTagCompound;)V"}, at={@At(value="RETURN")}, remap=false)
    private void crazyae$setOwnCountFromNBT(NBTTagCompound i, CallbackInfo ci) {
        this.crazyae$accelerators = i.func_74763_f("coprocessors");
        this.crazyae$jobInitiator = i.func_74779_i("jobInitiator");
        this.crazyae$millisJobStarted = i.func_74763_f("millisJobStarted");
    }

    @Overwrite
    public void writeToNBT(NBTTagCompound i) {
        if (this.name != null && !this.name.isEmpty()) {
            i.func_74778_a("name", this.name);
        }
        i.func_74768_a("serial", this.serial);
        i.func_74772_a("storage", this.storage);
        i.func_74772_a("coprocessors", this.crazyae$accelerators);
        i.func_74772_a("totalItems", this.totalItems);
        i.func_74772_a("remainingItems", this.remainingItems);
        if (this.crazyae$jobInitiator != null && !this.crazyae$jobInitiator.isEmpty()) {
            i.func_74778_a("jobInitiator", this.crazyae$jobInitiator);
        }
        if (this.crazyae$millisJobStarted > 0L) {
            i.func_74772_a("millisJobStarted", this.crazyae$millisJobStarted);
        }
        if (this.crafting != null) {
            NBTTagCompound stack = new NBTTagCompound();
            this.crafting.writeToNBT(stack);
            i.func_74782_a("crafting", (NBTBase)stack);
        }
    }

    @Overwrite
    public long getCoprocessors() {
        return this.crazyae$accelerators;
    }
}

