/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.mixins.core.crafting;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AEPartLocation;
import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerCraftAmount;
import appeng.container.implementations.ContainerCraftConfirm;
import appeng.container.interfaces.IInventorySlotAware;
import appeng.core.AELog;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.INetworkInfo;
import appeng.core.sync.packets.PacketCraftRequest;
import appeng.util.Platform;
import dev.beecube31.crazyae2.core.cache.ICrazyAutocraftingSystem;
import java.util.concurrent.Future;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={PacketCraftRequest.class}, remap=false)
public abstract class MixinPacketCraftRequest
extends AppEngPacket {
    @Shadow
    @Final
    private long amount;
    @Shadow
    @Final
    private boolean heldShift;

    @Overwrite
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        ContainerCraftAmount cca;
        Object target;
        Container container = player.field_71070_bA;
        if (container instanceof ContainerCraftAmount && (target = (cca = (ContainerCraftAmount)container).getTarget()) instanceof IActionHost) {
            IActionHost ah = (IActionHost)target;
            IGridNode gn = ah.getActionableNode();
            IGrid g = gn.getGrid();
            if (cca.getItemToCraft() == null) {
                return;
            }
            cca.getItemToCraft().setStackSize(this.amount);
            Future futureJob = null;
            try {
                ICraftingGrid cg = (ICraftingGrid)g.getCache(ICraftingGrid.class);
                ICrazyAutocraftingSystem sys = (ICrazyAutocraftingSystem)g.getCache(ICrazyAutocraftingSystem.class);
                futureJob = sys.containsCraftingItem(cca.getItemToCraft()) ? sys.beginCraftingJob(cca.getWorld(), cca.getGrid(), cca.getActionSrc(), cca.getItemToCraft(), null) : cg.beginCraftingJob(cca.getWorld(), cca.getGrid(), cca.getActionSrc(), cca.getItemToCraft(), null);
                ContainerOpenContext context = cca.getOpenContext();
                if (context != null) {
                    TileEntity te = context.getTile();
                    if (te != null) {
                        Platform.openGUI((EntityPlayer)player, (TileEntity)te, (AEPartLocation)cca.getOpenContext().getSide(), (GuiBridge)GuiBridge.GUI_CRAFTING_CONFIRM);
                    } else if (ah instanceof IInventorySlotAware) {
                        IInventorySlotAware i = (IInventorySlotAware)ah;
                        Platform.openGUI((EntityPlayer)player, (int)i.getInventorySlot(), (GuiBridge)GuiBridge.GUI_CRAFTING_CONFIRM, (boolean)i.isBaubleSlot());
                    }
                    Container container2 = player.field_71070_bA;
                    if (container2 instanceof ContainerCraftConfirm) {
                        ContainerCraftConfirm ccc = (ContainerCraftConfirm)container2;
                        ccc.setAutoStart(this.heldShift);
                        ccc.setJob(futureJob);
                        cca.func_75142_b();
                    }
                }
            }
            catch (Throwable e) {
                if (futureJob != null) {
                    futureJob.cancel(true);
                }
                AELog.debug((Throwable)e);
            }
        }
    }
}

