/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.mixins.core.crafting.container;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.parts.IPart;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import appeng.container.AEBaseContainer;
import appeng.container.implementations.ContainerCraftConfirm;
import appeng.container.interfaces.IInventorySlotAware;
import appeng.core.AELog;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketMEInventoryUpdate;
import appeng.crafting.CraftingJob;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.parts.reporting.PartCraftingTerminal;
import appeng.parts.reporting.PartExpandedProcessingPatternTerminal;
import appeng.parts.reporting.PartPatternTerminal;
import appeng.parts.reporting.PartTerminal;
import appeng.util.Platform;
import com.google.common.collect.ImmutableSet;
import dev.beecube31.crazyae2.common.interfaces.craftsystem.ICrazyCraftHost;
import dev.beecube31.crazyae2.core.cache.ICrazyAutocraftingSystem;
import dev.beecube31.crazyae2.craftsystem.CraftingHostType;
import dev.beecube31.crazyae2.craftsystem.CrazyCraftHostRecord;
import dev.beecube31.crazyae2.craftsystem.CrazyCraftingJob;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Future;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={ContainerCraftConfirm.class}, remap=false)
public abstract class MixinContainerCraftConfirm
extends AEBaseContainer {
    @Shadow
    private ICraftingJob result;
    @Shadow
    public int selectedCpu;
    @Unique
    private final ArrayList<CrazyCraftHostRecord> crazyae$allAvailableWorkers = new ArrayList();
    @Unique
    private final ArrayList<CrazyCraftHostRecord> crazyae$filteredWorkers = new ArrayList();

    public MixinContainerCraftConfirm(InventoryPlayer ip, TileEntity myTile, IPart myPart) {
        super(ip, myTile, myPart);
    }

    @Shadow
    protected abstract void setSelectedCpu(int var1);

    @Shadow
    public abstract int getSelectedCpu();

    @Shadow
    protected abstract void setCpuAvailableBytes(long var1);

    @Shadow
    protected abstract void setCpuCoProcessors(int var1);

    @Shadow
    protected abstract void setName(@NotNull String var1);

    @Shadow
    public abstract long getUsedBytes();

    @Shadow
    protected abstract void setNoCPU(boolean var1);

    @Shadow
    protected abstract Future<ICraftingJob> getJob();

    @Shadow
    protected abstract void setSimulation(boolean var1);

    @Shadow
    public abstract boolean isAutoStart();

    @Shadow
    protected abstract void setUsedBytes(long var1);

    @Shadow
    public abstract void setJob(Future<ICraftingJob> var1);

    @Shadow
    public abstract boolean isSimulation();

    @Shadow
    public abstract void setAutoStart(boolean var1);

    @Shadow
    public abstract World getWorld();

    @Shadow
    protected abstract IActionSource getActionSrc();

    @Unique
    public int crazyae$getCurrentCpu() {
        return this.selectedCpu != -1 ? this.selectedCpu : 0;
    }

    @Overwrite
    public void cycleCpu(boolean next) {
        int listSize = this.crazyae$filteredWorkers.size();
        if (listSize == 0) {
            this.setSelectedCpu(-1);
            this.crazyae$updateGuiForSelection();
            return;
        }
        if (next) {
            this.setSelectedCpu(this.getSelectedCpu() + 1);
        } else {
            this.setSelectedCpu(this.getSelectedCpu() - 1);
        }
        if (this.getSelectedCpu() < -1) {
            this.setSelectedCpu(listSize - 1);
        } else if (this.getSelectedCpu() >= listSize) {
            this.setSelectedCpu(-1);
        }
        this.crazyae$updateGuiForSelection();
    }

    @Overwrite
    private void sendCPUs() {
        Collections.sort(this.crazyae$filteredWorkers);
        if (this.getSelectedCpu() >= this.crazyae$filteredWorkers.size()) {
            this.setSelectedCpu(-1);
            this.setCpuAvailableBytes(0L);
            this.setCpuCoProcessors(0);
            this.setName("");
        } else if (this.getSelectedCpu() != -1) {
            this.setName(this.crazyae$filteredWorkers.get(this.getSelectedCpu()).getName());
            this.setCpuAvailableBytes(this.crazyae$filteredWorkers.get(this.getSelectedCpu()).getSize());
            this.setCpuCoProcessors(this.crazyae$filteredWorkers.get(this.getSelectedCpu()).getProcessors());
        }
    }

    @Overwrite
    public void func_75142_b() {
        if (Platform.isClient()) {
            return;
        }
        IActionHost h = (IActionHost)this.getTarget();
        if (h == null) {
            this.setValidContainer(false);
            return;
        }
        IGrid grid = h.getActionableNode().getGrid();
        ICraftingGrid cc = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
        ICrazyAutocraftingSystem sys = (ICrazyAutocraftingSystem)grid.getCache(ICrazyAutocraftingSystem.class);
        boolean listChanged = false;
        ImmutableSet currentCpus = cc.getCpus();
        Set<ICrazyCraftHost> currentWorkers = sys.getWorkers();
        if (this.crazyae$allAvailableWorkers.size() != currentCpus.size() + currentWorkers.size()) {
            listChanged = true;
        }
        if (listChanged) {
            this.crazyae$allAvailableWorkers.clear();
            for (ICraftingCPU iCraftingCPU : currentCpus) {
                if (iCraftingCPU.getAvailableStorage() < this.getUsedBytes() || iCraftingCPU.isBusy()) continue;
                this.crazyae$allAvailableWorkers.add(new CrazyCraftHostRecord((double)iCraftingCPU.getAvailableStorage(), (double)iCraftingCPU.getCoProcessors(), iCraftingCPU, CraftingHostType.AE_HOST));
            }
            for (ICrazyCraftHost iCrazyCraftHost : currentWorkers) {
                if (!(iCrazyCraftHost.getStorageCount() >= (double)this.getUsedBytes()) || iCrazyCraftHost.isBusy()) continue;
                this.crazyae$allAvailableWorkers.add(new CrazyCraftHostRecord(iCrazyCraftHost.getStorageCount(), (double)iCrazyCraftHost.getAcceleratorCount(), iCrazyCraftHost, CraftingHostType.CRAZYAE_HOST));
            }
            Collections.sort(this.crazyae$allAvailableWorkers);
        }
        this.crazyae$updateFilteredWorkers();
        this.setNoCPU(this.crazyae$filteredWorkers.isEmpty());
        super.func_75142_b();
        if (this.getJob() != null && this.getJob().isDone()) {
            try {
                this.result = this.getJob().get();
                this.crazyae$updateFilteredWorkers();
                this.crazyae$updateState(grid);
            }
            catch (Throwable e) {
                this.getPlayerInv().field_70458_d.func_145747_a((ITextComponent)new TextComponentString("Error: " + e));
                AELog.debug((Throwable)e);
                this.setValidContainer(false);
                this.result = null;
            }
            this.setJob(null);
        }
        this.verifyPermissions(SecurityPermissions.CRAFT, false);
    }

    @Unique
    private void crazyae$updateFilteredWorkers() {
        this.crazyae$filteredWorkers.clear();
        if (this.result == null) {
            this.crazyae$filteredWorkers.addAll(this.crazyae$allAvailableWorkers);
        } else if (this.result instanceof CrazyCraftingJob) {
            for (CrazyCraftHostRecord record : this.crazyae$allAvailableWorkers) {
                if (record.getType() != CraftingHostType.CRAZYAE_HOST) continue;
                this.crazyae$filteredWorkers.add(record);
            }
        } else {
            for (CrazyCraftHostRecord record : this.crazyae$allAvailableWorkers) {
                if (record.getType() != CraftingHostType.AE_HOST) continue;
                this.crazyae$filteredWorkers.add(record);
            }
        }
        if (this.getSelectedCpu() >= this.crazyae$filteredWorkers.size()) {
            this.setSelectedCpu(-1);
            this.crazyae$updateGuiForSelection();
        }
    }

    @Unique
    private void crazyae$updateState(IGrid grid) {
        if (!this.result.isSimulation()) {
            this.setSimulation(false);
            if (this.isAutoStart()) {
                this.startJob();
                return;
            }
        } else {
            this.setSimulation(true);
        }
        try {
            PacketMEInventoryUpdate a = new PacketMEInventoryUpdate(0);
            PacketMEInventoryUpdate b = new PacketMEInventoryUpdate(1);
            PacketMEInventoryUpdate c = this.result.isSimulation() ? new PacketMEInventoryUpdate(2) : null;
            IItemList plan = ((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createList();
            this.result.populatePlan(plan);
            this.setUsedBytes(this.result.getByteTotal());
            for (IAEItemStack out : plan) {
                IAEItemStack o = out.copy();
                o.reset();
                o.setStackSize(out.getStackSize());
                IAEItemStack p = out.copy();
                p.reset();
                p.setStackSize(out.getCountRequestable());
                IStorageGrid sg = (IStorageGrid)grid.getCache(IStorageGrid.class);
                IMEMonitor items = sg.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
                IAEItemStack m = null;
                if (c != null && this.result.isSimulation()) {
                    m = o.copy();
                    if ((o = (IAEItemStack)items.extractItems((IAEStack)o, Actionable.SIMULATE, this.getActionSrc())) == null) {
                        o = m.copy();
                        o.setStackSize(0L);
                    }
                    m.setStackSize(m.getStackSize() - o.getStackSize());
                }
                if (o.getStackSize() > 0L) {
                    a.appendItem(o);
                }
                if (p.getStackSize() > 0L) {
                    b.appendItem(p);
                }
                if (c == null || m == null || m.getStackSize() <= 0L) continue;
                c.appendItem(m);
            }
            for (Object g : this.field_75149_d) {
                if (!(g instanceof EntityPlayer)) continue;
                NetworkHandler.instance().sendTo((AppEngPacket)a, (EntityPlayerMP)g);
                NetworkHandler.instance().sendTo((AppEngPacket)b, (EntityPlayerMP)g);
                if (c == null) continue;
                NetworkHandler.instance().sendTo((AppEngPacket)c, (EntityPlayerMP)g);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Unique
    private void crazyae$updateGuiForSelection() {
        if (this.getSelectedCpu() == -1) {
            this.setCpuAvailableBytes(0L);
            this.setCpuCoProcessors(0);
            this.setName("");
        } else if (this.getSelectedCpu() < this.crazyae$filteredWorkers.size()) {
            CrazyCraftHostRecord selected = this.crazyae$filteredWorkers.get(this.getSelectedCpu());
            this.setName(selected.getName());
            this.setCpuAvailableBytes(selected.getSize());
            this.setCpuCoProcessors(selected.getProcessors());
        } else {
            this.setSelectedCpu(-1);
            this.crazyae$updateGuiForSelection();
        }
    }

    @Unique
    private boolean crazyae$validateState() {
        if (this.crazyae$filteredWorkers.isEmpty() || this.result == null) {
            return false;
        }
        int currentIndex = this.crazyae$getCurrentCpu();
        if (currentIndex < 0 || currentIndex >= this.crazyae$filteredWorkers.size()) {
            return false;
        }
        CrazyCraftHostRecord host = this.crazyae$filteredWorkers.get(currentIndex);
        if (host.getType() == CraftingHostType.AE_HOST) {
            return this.result instanceof CraftingJob;
        }
        if (host.getType() == CraftingHostType.CRAZYAE_HOST) {
            return this.result instanceof CrazyCraftingJob;
        }
        return false;
    }

    @Overwrite
    public void startJob() {
        IActionHost h;
        if (!this.crazyae$validateState()) {
            return;
        }
        GuiBridge originalGui = null;
        IActionHost ah = this.getActionHost();
        if (ah instanceof WirelessTerminalGuiObject) {
            ItemStack myIcon = ((WirelessTerminalGuiObject)ah).getItemStack();
            originalGui = (GuiBridge)AEApi.instance().registries().wireless().getWirelessTerminalHandler(myIcon).getGuiHandler(myIcon);
        }
        if (ah instanceof PartTerminal) {
            originalGui = GuiBridge.GUI_ME;
        }
        if (ah instanceof PartCraftingTerminal) {
            originalGui = GuiBridge.GUI_CRAFTING_TERMINAL;
        }
        if (ah instanceof PartPatternTerminal) {
            originalGui = GuiBridge.GUI_PATTERN_TERMINAL;
        }
        if (ah instanceof PartExpandedProcessingPatternTerminal) {
            originalGui = GuiBridge.GUI_EXPANDED_PROCESSING_PATTERN_TERMINAL;
        }
        if ((h = (IActionHost)this.getTarget()) == null) {
            return;
        }
        IGridNode node = h.getActionableNode();
        IGrid grid = node.getGrid();
        if (this.result != null && !this.isSimulation()) {
            ICraftingGrid cc = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
            ICrazyAutocraftingSystem sys = (ICrazyAutocraftingSystem)grid.getCache(ICrazyAutocraftingSystem.class);
            ICraftingLink g = null;
            CrazyCraftHostRecord host = this.crazyae$filteredWorkers.get(this.crazyae$getCurrentCpu());
            switch (host.getType()) {
                case CRAZYAE_HOST: {
                    g = sys.submitCraftingJob(this.result, null, host.getCrazyWorker(), this.getActionSrc());
                    break;
                }
                case AE_HOST: {
                    g = cc.submitJob(this.result, null, host.getCpu(), true, this.getActionSrc());
                }
            }
            this.setAutoStart(false);
            if (g == null) {
                switch (host.getType()) {
                    case CRAZYAE_HOST: {
                        this.setJob(sys.beginCraftingJob(this.getWorld(), grid, this.getActionSrc(), this.result.getOutput(), null));
                        break;
                    }
                    case AE_HOST: {
                        this.setJob(cc.beginCraftingJob(this.getWorld(), grid, this.getActionSrc(), this.result.getOutput(), null));
                    }
                }
            } else if (originalGui != null && this.getOpenContext() != null) {
                TileEntity te = this.getOpenContext().getTile();
                if (te != null) {
                    Platform.openGUI((EntityPlayer)this.getInventoryPlayer().field_70458_d, (TileEntity)te, (AEPartLocation)this.getOpenContext().getSide(), (GuiBridge)originalGui);
                } else if (ah instanceof IInventorySlotAware) {
                    IInventorySlotAware i = (IInventorySlotAware)ah;
                    Platform.openGUI((EntityPlayer)this.getInventoryPlayer().field_70458_d, (int)i.getInventorySlot(), (GuiBridge)originalGui, (boolean)i.isBaubleSlot());
                }
            }
        }
    }
}

