/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.mixins.core.crafting.container;

import appeng.api.networking.crafting.CraftingItemList;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.parts.IPart;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.AEBaseContainer;
import appeng.container.implementations.ContainerCraftingCPU;
import appeng.core.AELog;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketMEInventoryUpdate;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.helpers.ICustomNameObject;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.util.Platform;
import dev.beecube31.crazyae2.common.interfaces.craftsystem.ICrazyCraftHost;
import dev.beecube31.crazyae2.common.interfaces.mixin.crafting.IMixinContainerCraftingCPU;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.tileentity.TileEntity;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ContainerCraftingCPU.class}, remap=false)
public abstract class MixinContainerCraftingCPU
extends AEBaseContainer
implements IMEMonitorHandlerReceiver<IAEItemStack>,
ICustomNameObject,
IMixinContainerCraftingCPU {
    @Shadow
    private String cpuName;
    @Shadow
    @Final
    private IItemList<IAEItemStack> list;
    @Unique
    private ICrazyCraftHost crazyae$worker = null;

    public MixinContainerCraftingCPU(InventoryPlayer ip, TileEntity myTile, IPart myPart) {
        super(ip, myTile, myPart);
    }

    @Shadow
    abstract CraftingCPUCluster getMonitor();

    @Shadow
    protected abstract void setMonitor(CraftingCPUCluster var1);

    @Shadow
    protected abstract void setEstimatedTime(long var1);

    @Shadow
    public abstract long getEstimatedTime();

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, remap=false)
    private void crazyae$checkForOwnWorker(InventoryPlayer ip, Object te, CallbackInfo ci) {
        if (te instanceof ICrazyCraftHost) {
            ICrazyCraftHost c = (ICrazyCraftHost)te;
            this.setCPU(c);
        }
    }

    @Override
    public ICrazyCraftHost crazyae$getCurrentWorker() {
        return this.crazyae$worker;
    }

    @Overwrite
    protected void setCPU(ICraftingCPU c) {
        if (this.getMonitor() != null) {
            this.getMonitor().removeListener((IMEMonitorHandlerReceiver)this);
        }
        if (this.crazyae$worker != null) {
            this.crazyae$worker.removeListener(this);
        }
        this.setMonitor(null);
        this.crazyae$worker = null;
        this.crazyae$sendClearPacket();
        this.list.resetStatus();
        if (c == null) {
            this.cpuName = "";
            this.setEstimatedTime(-1L);
        } else {
            this.cpuName = c.getName();
            this.setEstimatedTime(0L);
            if (c instanceof ICrazyCraftHost) {
                ICrazyCraftHost h;
                this.crazyae$worker = h = (ICrazyCraftHost)c;
                this.crazyae$worker.getListOfItem(this.list, CraftingItemList.ALL);
                this.crazyae$worker.addListener(this, null);
            } else if (c instanceof CraftingCPUCluster) {
                CraftingCPUCluster cluster = (CraftingCPUCluster)c;
                this.setMonitor(cluster);
                this.getMonitor().getListOfItem(this.list, CraftingItemList.ALL);
                this.getMonitor().addListener((IMEMonitorHandlerReceiver)this, null);
            }
        }
    }

    @Unique
    private void crazyae$sendClearPacket() {
        if (Platform.isClient()) {
            return;
        }
        try {
            PacketValueConfig packet = new PacketValueConfig("CraftingStatus", "Clear");
            for (Object g : this.field_75149_d) {
                if (!(g instanceof EntityPlayerMP)) continue;
                EntityPlayerMP player = (EntityPlayerMP)g;
                NetworkHandler.instance().sendTo((AppEngPacket)packet, player);
            }
        }
        catch (IOException e) {
            AELog.debug((Throwable)e);
        }
    }

    @Overwrite
    public void cancelCrafting() {
        if (this.getMonitor() != null) {
            this.getMonitor().cancel();
        } else if (this.crazyae$worker != null) {
            this.crazyae$worker.cancel(this.getActionSource());
        }
        this.setEstimatedTime(-1L);
    }

    @Overwrite
    public void func_82847_b(@NotNull IContainerListener c) {
        super.func_82847_b(c);
        if (this.field_75149_d.isEmpty()) {
            if (this.getMonitor() != null) {
                this.getMonitor().removeListener((IMEMonitorHandlerReceiver)this);
            }
            if (this.crazyae$worker != null) {
                this.crazyae$worker.removeListener(this);
            }
        }
    }

    @Overwrite
    public void func_75134_a(@NotNull EntityPlayer player) {
        super.func_75134_a(player);
        if (this.getMonitor() != null) {
            this.getMonitor().removeListener((IMEMonitorHandlerReceiver)this);
        }
        if (this.crazyae$worker != null) {
            this.crazyae$worker.removeListener(this);
        }
    }

    @Overwrite
    public void func_75142_b() {
        if (Platform.isServer()) {
            long elapsedTime;
            Object currentCpu = this.getMonitor() != null ? this.getMonitor() : this.crazyae$worker;
            long l = elapsedTime = this.getMonitor() != null ? this.getMonitor().getElapsedTime() : this.crazyae$worker.getElapsedTime();
            if (currentCpu != null) {
                if (this.getEstimatedTime() >= 0L) {
                    double remainingItems = currentCpu.getRemainingItemCount();
                    double startItems = currentCpu.getStartItemCount();
                    long eta = (long)((double)elapsedTime / Math.max(1.0, startItems - remainingItems) * remainingItems);
                    this.setEstimatedTime(eta);
                }
                if (!this.list.isEmpty()) {
                    try {
                        PacketMEInventoryUpdate storagePacket = new PacketMEInventoryUpdate(0);
                        PacketMEInventoryUpdate activePacket = new PacketMEInventoryUpdate(1);
                        PacketMEInventoryUpdate pendingPacket = new PacketMEInventoryUpdate(2);
                        for (IAEItemStack out : this.list) {
                            storagePacket.appendItem(this.getMonitor() != null ? this.getMonitor().getItemStack(out, CraftingItemList.STORAGE) : this.crazyae$worker.getItemStack(out, CraftingItemList.STORAGE));
                            activePacket.appendItem(this.getMonitor() != null ? this.getMonitor().getItemStack(out, CraftingItemList.ACTIVE) : this.crazyae$worker.getItemStack(out, CraftingItemList.ACTIVE));
                            pendingPacket.appendItem(this.getMonitor() != null ? this.getMonitor().getItemStack(out, CraftingItemList.PENDING) : this.crazyae$worker.getItemStack(out, CraftingItemList.PENDING));
                        }
                        this.list.resetStatus();
                        for (Object g : this.field_75149_d) {
                            if (!(g instanceof EntityPlayerMP)) continue;
                            EntityPlayerMP player = (EntityPlayerMP)g;
                            if (!storagePacket.isEmpty()) {
                                NetworkHandler.instance().sendTo((AppEngPacket)storagePacket, player);
                            }
                            if (!activePacket.isEmpty()) {
                                NetworkHandler.instance().sendTo((AppEngPacket)activePacket, player);
                            }
                            if (pendingPacket.isEmpty()) continue;
                            NetworkHandler.instance().sendTo((AppEngPacket)pendingPacket, player);
                        }
                    }
                    catch (IOException e) {
                        AELog.debug((Throwable)e);
                    }
                }
            }
        }
        super.func_75142_b();
    }
}

