/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.mixins.core.crafting.container;

import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.container.implementations.ContainerCraftingCPU;
import appeng.container.implementations.ContainerCraftingStatus;
import appeng.container.implementations.CraftingCPUStatus;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.util.Platform;
import dev.beecube31.crazyae2.common.interfaces.mixin.crafting.IMixinContainerCraftingCPU;
import dev.beecube31.crazyae2.common.interfaces.mixin.crafting.IMixinCraftingCPUStatus;
import dev.beecube31.crazyae2.core.cache.ICrazyAutocraftingSystem;
import dev.beecube31.crazyae2.mixins.core.crafting.container.AccessorContainerCraftingCPU;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.entity.player.InventoryPlayer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={ContainerCraftingStatus.class}, remap=false, priority=996)
public abstract class MixinContainerCraftingStatus
extends ContainerCraftingCPU {
    @Shadow
    private int lastUpdate;
    @Shadow
    public int selectedCpuSerial;
    @Shadow
    private List<CraftingCPUStatus> cpus;
    @Shadow
    @Final
    private WeakHashMap<ICraftingCPU, Integer> cpuSerialMap;
    @Unique
    private Set<ICraftingCPU> crazyae$lastKnownCpuSet = new HashSet<ICraftingCPU>();
    @Shadow
    @Final
    private static Comparator<CraftingCPUStatus> CPU_COMPARATOR;

    @Shadow
    protected abstract void sendCPUs();

    @Shadow
    protected abstract int getOrAssignCpuSerial(ICraftingCPU var1);

    public MixinContainerCraftingStatus(InventoryPlayer ip, Object te) {
        super(ip, te);
    }

    @Overwrite
    public void func_75142_b() {
        IGrid network = ((AccessorContainerCraftingCPU)((Object)this)).getNetwork();
        if (Platform.isServer() && network != null) {
            ICraftingGrid cc = (ICraftingGrid)network.getCache(ICraftingGrid.class);
            ICrazyAutocraftingSystem sys = (ICrazyAutocraftingSystem)network.getCache(ICrazyAutocraftingSystem.class);
            HashSet<ICraftingCPU> currentCpuSet = new HashSet<ICraftingCPU>();
            currentCpuSet.addAll((Collection<ICraftingCPU>)cc.getCpus());
            currentCpuSet.addAll(sys.getWorkers());
            ++this.lastUpdate;
            if (!currentCpuSet.equals(this.crazyae$lastKnownCpuSet) || this.lastUpdate > 20) {
                this.lastUpdate = 0;
                this.crazyae$lastKnownCpuSet = currentCpuSet;
                this.updateCpuList();
                this.sendCPUs();
            }
        }
        if (this.selectedCpuSerial != -1 && this.cpus.stream().noneMatch(c -> c.getSerial() == this.selectedCpuSerial)) {
            this.selectCPU(-1);
        }
        if (this.selectedCpuSerial == -1) {
            this.cpus.stream().filter(c -> c.getRemainingItems() > 0L).findFirst().ifPresent(c -> this.selectCPU(c.getSerial()));
            if (this.selectedCpuSerial == -1 && !this.cpus.isEmpty()) {
                this.selectCPU(this.cpus.get(0).getSerial());
            }
        }
        super.func_75142_b();
    }

    @Overwrite
    private void updateCpuList() {
        this.cpus.clear();
        for (ICraftingCPU cpu : this.crazyae$lastKnownCpuSet) {
            String string;
            long l;
            IMixinCraftingCPUStatus s;
            int serial = this.getOrAssignCpuSerial(cpu);
            IMixinCraftingCPUStatus status = (IMixinCraftingCPUStatus)new CraftingCPUStatus(cpu, serial);
            if (cpu instanceof IMixinCraftingCPUStatus) {
                s = (IMixinCraftingCPUStatus)cpu;
                l = s.crazyae$whenJobStarted();
            } else {
                l = -1L;
            }
            status.crazyae$setWhenJobStarted(l);
            if (cpu instanceof IMixinCraftingCPUStatus) {
                s = (IMixinCraftingCPUStatus)cpu;
                string = s.crazyae$jobInitiator();
            } else {
                string = "N/A";
            }
            status.crazyae$setJobInitiator(string);
            this.cpus.add((CraftingCPUStatus)status);
        }
        this.cpus.sort(CPU_COMPARATOR);
    }

    @Overwrite
    public void selectCPU(int serial) {
        if (Platform.isServer()) {
            CraftingCPUCluster monitor;
            CraftingCPUCluster currentlySelected;
            this.selectedCpuSerial = serial;
            ICraftingCPU newSelectedCpu = null;
            if (serial != -1) {
                for (ICraftingCPU cpu : this.crazyae$lastKnownCpuSet) {
                    if (this.cpuSerialMap.getOrDefault(cpu, -1) != serial) continue;
                    newSelectedCpu = cpu;
                    break;
                }
            }
            Object object = currentlySelected = (monitor = ((AccessorContainerCraftingCPU)((Object)this)).getMonitor()) != null ? monitor : ((IMixinContainerCraftingCPU)((Object)this)).crazyae$getCurrentWorker();
            if (newSelectedCpu != currentlySelected) {
                this.setCPU(newSelectedCpu);
            }
        }
    }
}

