/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.mixins.core.inv;

import appeng.util.InventoryAdaptor;
import appeng.util.inv.AdaptorItemHandler;
import dev.beecube31.crazyae2.common.interfaces.mixin.inv.IMixinAdaptorItemHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={AdaptorItemHandler.class}, remap=false)
public abstract class MixinAdaptorItemHandler
extends InventoryAdaptor
implements IMixinAdaptorItemHandler {
    @Shadow
    @Final
    protected IItemHandler itemHandler;

    @Override
    public boolean crazyae$isInventoryFull() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.itemHandler.getStackInSlot(i);
            if (stackInSlot.func_190926_b()) {
                return false;
            }
            if (!stackInSlot.func_77985_e() || stackInSlot.func_190916_E() >= this.itemHandler.getSlotLimit(i) || stackInSlot.func_190916_E() >= stackInSlot.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    @Override
    public long crazyae$estimateInsertableAmount(ItemStack template) {
        if (template == null || template.func_190926_b()) {
            return 0L;
        }
        long totalCanInsert = 0L;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (!this.itemHandler.isItemValid(i, template)) continue;
            ItemStack stackInSlot = this.itemHandler.getStackInSlot(i);
            int slotLimit = this.itemHandler.getSlotLimit(i);
            int itemMaxStack = template.func_77976_d();
            int actualLimit = Math.min(slotLimit, itemMaxStack);
            if (stackInSlot.func_190926_b()) {
                totalCanInsert += (long)actualLimit;
                continue;
            }
            int canAddToSlot = actualLimit - stackInSlot.func_190916_E();
            if (canAddToSlot <= 0) continue;
            totalCanInsert += (long)canAddToSlot;
        }
        return totalCanInsert;
    }
}

