/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.mixins.features.interfaceterm;

import appeng.api.config.ActionItems;
import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.implementations.GuiInterfaceTerminal;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.ITooltip;
import appeng.client.gui.widgets.MEGuiTooltipTextField;
import appeng.client.me.ClientDCInternalInv;
import appeng.client.me.SlotDisconnected;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@SideOnly(value=Side.CLIENT)
@Mixin(value={GuiInterfaceTerminal.class}, remap=false, priority=990)
public abstract class MixinGuiInterfaceTerminal
extends AEBaseGui {
    @Shadow
    @Final
    private HashMap<Long, ClientDCInternalInv> byId;
    @Shadow
    private boolean refreshList;
    @Shadow
    @Final
    private Map<String, Set<Object>> cachedSearches;
    @Shadow
    @Final
    private HashMultimap<String, ClientDCInternalInv> byName;
    @Shadow
    @Final
    private ArrayList<String> names;
    @Shadow
    @Final
    private MEGuiTooltipTextField searchFieldInputs;
    @Shadow
    @Final
    private MEGuiTooltipTextField searchFieldOutputs;
    @Shadow
    private int rows;
    @Shadow
    @Final
    private ArrayList<Object> lines;
    @Shadow
    @Final
    private Map<ClientDCInternalInv, Integer> numUpgradesMap;
    @Shadow
    @Final
    private HashMap<ClientDCInternalInv, BlockPos> blockPosHashMap;
    @Shadow
    @Final
    private Map<ClientDCInternalInv, Integer> dimHashMap;
    @Shadow
    @Final
    private Set<Object> matchedStacks;
    @Shadow
    @Final
    private MEGuiTooltipTextField searchFieldNames;
    @Shadow
    @Final
    private HashMap<GuiButton, ClientDCInternalInv> guiButtonHashMap;
    @Shadow
    @Final
    private GuiImgButton guiButtonAssemblersOnly;
    @Shadow
    private boolean onlyMolecularAssemblers;
    @Shadow
    @Final
    private GuiImgButton guiButtonHideFull;
    @Shadow
    private boolean onlyShowWithSpace;
    @Shadow
    private boolean onlyBrokenRecipes;
    @Shadow
    @Final
    private GuiImgButton guiButtonBrokenRecipes;
    @Shadow
    @Final
    private GuiImgButton terminalStyleBox;
    @Shadow
    @Final
    private static String MOLECULAR_ASSEMBLER;
    @Unique
    @Final
    private final Map<ClientDCInternalInv, Boolean> crazyae$patterns = new HashMap<ClientDCInternalInv, Boolean>();
    @Unique
    @Final
    private final Map<ClientDCInternalInv, Boolean> crazyae$macs = new HashMap<ClientDCInternalInv, Boolean>();

    @Shadow
    protected abstract boolean recipeIsBroken(ItemStack var1);

    @Shadow
    protected abstract boolean itemStackMatchesSearchTerm(ItemStack var1, String var2, int var3);

    @Shadow
    protected abstract void setScrollBar();

    @Shadow
    protected abstract Set<Object> getCacheForSearchTerm(String var1);

    public MixinGuiInterfaceTerminal(Container container) {
        super(container);
    }

    @Overwrite
    private int getMaxRows() {
        return AEConfig.instance().getConfigManager().getSetting(Settings.TERMINAL_STYLE) != TerminalStyle.TALL ? 8 : Integer.MAX_VALUE;
    }

    @Overwrite
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.getGuiDisplayName(GuiText.InterfaceTerminal.getLocal()), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.inventory.getLocal(), 24, this.field_147000_g - 96, 0x404040);
        int currentScroll = this.getScrollBar().getCurrentScroll();
        int offset = 51;
        int linesDraw = 0;
        for (int x = 0; x < this.rows && linesDraw < this.rows && currentScroll + x < this.lines.size(); ++x) {
            Object lineObj = this.lines.get(currentScroll + x);
            if (lineObj instanceof ClientDCInternalInv) {
                ClientDCInternalInv inv = (ClientDCInternalInv)lineObj;
                int extraLines = this.numUpgradesMap.get(inv);
                boolean isPatternTile = this.crazyae$patterns.get(inv);
                boolean isMAC = this.crazyae$macs.get(inv);
                for (int row = 0; row < 1 + (isPatternTile ? 7 : (isMAC ? 4 : extraLines)) && linesDraw < this.rows; ++row) {
                    for (int z = 0; z < 9; ++z) {
                        if (!this.matchedStacks.contains(inv.getInventory().getStackInSlot(z + row * 9))) continue;
                        MixinGuiInterfaceTerminal.func_73734_a((int)(z * 18 + 22), (int)(1 + offset), (int)(z * 18 + 22 + 16), (int)(1 + offset + 16), (int)704708352);
                    }
                    ++linesDraw;
                    offset += 18;
                }
                continue;
            }
            if (!(lineObj instanceof String)) continue;
            String name = (String)lineObj;
            int rows = this.byName.get((Object)name).size();
            if (rows > 1) {
                name = name + " (" + rows + ')';
            }
            while (name.length() > 2 && this.field_146289_q.func_78256_a(name) > 158) {
                name = name.substring(0, name.length() - 1);
            }
            this.field_146289_q.func_78276_b(name, 24, 6 + offset, 0x404040);
            ++linesDraw;
            offset += 18;
        }
    }

    @Overwrite
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.bindTexture("guis/newinterfaceterminal.png");
        this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, 53);
        for (int x = 0; x < this.rows; ++x) {
            this.func_73729_b(offsetX, offsetY + 53 + x * 18, 0, 52, this.field_146999_f, 18);
        }
        int offset = 51;
        int ex = this.getScrollBar().getCurrentScroll();
        int linesDraw = 0;
        for (int x = 0; x < this.rows && linesDraw < this.rows && ex + x < this.lines.size(); ++x) {
            Object lineObj = this.lines.get(ex + x);
            if (lineObj instanceof ClientDCInternalInv) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int width = 162;
                int extraLines = this.numUpgradesMap.get(lineObj);
                boolean isPatternTile = this.crazyae$patterns.get(lineObj);
                boolean isMAC = this.crazyae$macs.get(lineObj);
                for (int row = 0; row < 1 + (isPatternTile ? 7 : (isMAC ? 4 : extraLines)) && linesDraw < this.rows; ++linesDraw, ++row) {
                    this.func_73729_b(offsetX + 20, offsetY + offset, 20, 173, 162, 18);
                    offset += 18;
                }
                continue;
            }
            offset += 18;
            ++linesDraw;
        }
        this.func_73729_b(offsetX, offsetY + 50 + this.rows * 18, 0, 158, this.field_146999_f, 99);
        this.searchFieldInputs.drawTextBox();
        this.searchFieldOutputs.drawTextBox();
        this.searchFieldNames.drawTextBox();
    }

    @Overwrite
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.field_146292_n.clear();
        this.guiButtonHashMap.clear();
        this.field_147002_h.field_75151_b.removeIf(slot -> slot instanceof SlotDisconnected);
        this.guiButtonAssemblersOnly.set((Enum)(this.onlyMolecularAssemblers ? ActionItems.MOLECULAR_ASSEMBLERS_ON : ActionItems.MOLECULAR_ASSEMBLERS_OFF));
        this.guiButtonHideFull.set((Enum)(this.onlyShowWithSpace ? ActionItems.TOGGLE_SHOW_FULL_INTERFACES_OFF : ActionItems.TOGGLE_SHOW_FULL_INTERFACES_ON));
        this.guiButtonBrokenRecipes.set((Enum)(this.onlyBrokenRecipes ? ActionItems.TOGGLE_SHOW_ONLY_INVALID_PATTERNS_ON : ActionItems.TOGGLE_SHOW_ONLY_INVALID_PATTERNS_OFF));
        this.terminalStyleBox.set(AEConfig.instance().getConfigManager().getSetting(Settings.TERMINAL_STYLE));
        this.field_146292_n.add(this.guiButtonAssemblersOnly);
        this.field_146292_n.add(this.guiButtonHideFull);
        this.field_146292_n.add(this.guiButtonBrokenRecipes);
        this.field_146292_n.add(this.terminalStyleBox);
        int offset = 51;
        int currentScroll = this.getScrollBar().getCurrentScroll();
        int linesDraw = 0;
        for (int x = 0; x < this.rows && linesDraw < this.rows && currentScroll + x < this.lines.size(); ++x) {
            Object lineObj = this.lines.get(currentScroll + x);
            if (lineObj instanceof ClientDCInternalInv) {
                ClientDCInternalInv inv = (ClientDCInternalInv)lineObj;
                GuiImgButton guiButton = new GuiImgButton(this.field_147003_i + 4, this.field_147009_r + offset + 1, (Enum)Settings.ACTIONS, (Enum)ActionItems.HIGHLIGHT_INTERFACE);
                this.guiButtonHashMap.put((GuiButton)guiButton, inv);
                this.field_146292_n.add(guiButton);
                int extraLines = this.numUpgradesMap.get(lineObj);
                boolean isPatternTile = this.crazyae$patterns.get(lineObj);
                boolean isMAC = this.crazyae$macs.get(lineObj);
                for (int row = 0; row < 1 + (isPatternTile ? 7 : (isMAC ? 4 : extraLines)) && linesDraw < this.rows; ++row) {
                    for (int z = 0; z < 9; ++z) {
                        this.field_147002_h.field_75151_b.add(new SlotDisconnected(inv, z + row * 9, z * 18 + 22, 1 + offset));
                    }
                    ++linesDraw;
                    offset += 18;
                }
                continue;
            }
            if (!(lineObj instanceof String)) continue;
            ++linesDraw;
            offset += 18;
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawTooltip((ITooltip)this.searchFieldInputs, mouseX, mouseY);
        this.drawTooltip((ITooltip)this.searchFieldOutputs, mouseX, mouseY);
        this.drawTooltip((ITooltip)this.searchFieldNames, mouseX, mouseY);
    }

    @Overwrite
    public void postUpdate(NBTTagCompound in) {
        if (in.func_74767_n("clear")) {
            this.byId.clear();
            this.refreshList = true;
        }
        for (String oKey : in.func_150296_c()) {
            if (!oKey.startsWith("=")) continue;
            try {
                long id = Long.parseLong(oKey.substring(1), 36);
                NBTTagCompound invData = in.func_74775_l(oKey);
                ClientDCInternalInv current = this.crazyae$getById(invData.func_74762_e("patternsNum"), id, invData.func_74763_f("sortBy"), invData.func_74779_i("un"));
                this.blockPosHashMap.put(current, NBTUtil.func_186861_c((NBTTagCompound)invData.func_74775_l("pos")));
                this.dimHashMap.put(current, invData.func_74762_e("dim"));
                this.numUpgradesMap.put(current, invData.func_74762_e("numUpgrades"));
                this.crazyae$patterns.put(current, !invData.func_74767_n("isMAC") && invData.func_74762_e("patternsNum") == 72);
                this.crazyae$macs.put(current, invData.func_74767_n("isMAC") && invData.func_74762_e("patternsNum") == 45);
                for (int x = 0; x < current.getInventory().getSlots(); ++x) {
                    String which = Integer.toString(x);
                    if (!invData.func_74764_b(which)) continue;
                    current.getInventory().setStackInSlot(x, new ItemStack(invData.func_74775_l(which)));
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        if (this.refreshList) {
            this.refreshList = false;
            this.cachedSearches.clear();
            this.refreshList();
        }
    }

    @Overwrite
    private void refreshList() {
        this.byName.clear();
        this.field_146292_n.clear();
        this.matchedStacks.clear();
        String searchFieldInputs = this.searchFieldInputs.getText().toLowerCase();
        String searchFieldOutputs = this.searchFieldOutputs.getText().toLowerCase();
        String searchFieldNames = this.searchFieldNames.getText().toLowerCase();
        Set<Object> cachedSearch = this.getCacheForSearchTerm("IN:" + searchFieldInputs + " OUT:" + searchFieldOutputs + "NAME:" + searchFieldNames + this.onlyShowWithSpace + this.onlyMolecularAssemblers + this.onlyBrokenRecipes);
        boolean rebuild = cachedSearch.isEmpty();
        for (ClientDCInternalInv entry : this.byId.values()) {
            if (!rebuild && !cachedSearch.contains(entry)) continue;
            boolean found = searchFieldInputs.isEmpty() && searchFieldOutputs.isEmpty();
            boolean interfaceHasFreeSlots = false;
            boolean interfaceHasBrokenRecipes = false;
            if (!found || this.onlyShowWithSpace || this.onlyBrokenRecipes) {
                int slot = 0;
                for (ItemStack itemStack : entry.getInventory()) {
                    if (this.crazyae$patterns.get(entry) == false ? (this.crazyae$macs.get(entry) == false ? slot > 8 + this.numUpgradesMap.get(entry) * 9 : slot > 45) : slot > 72) break;
                    if (itemStack.func_190926_b()) {
                        interfaceHasFreeSlots = true;
                    }
                    if (this.onlyBrokenRecipes && this.recipeIsBroken(itemStack)) {
                        interfaceHasBrokenRecipes = true;
                    }
                    if (!searchFieldInputs.isEmpty() && this.itemStackMatchesSearchTerm(itemStack, searchFieldInputs, 0) || !searchFieldOutputs.isEmpty() && this.itemStackMatchesSearchTerm(itemStack, searchFieldOutputs, 1)) {
                        found = true;
                        this.matchedStacks.add(itemStack);
                    }
                    ++slot;
                }
            }
            if (!found) {
                cachedSearch.remove(entry);
                continue;
            }
            if (!entry.getName().toLowerCase().contains(searchFieldNames)) {
                cachedSearch.remove(entry);
                continue;
            }
            if (this.onlyMolecularAssemblers && !entry.getName().toLowerCase().contains(MOLECULAR_ASSEMBLER)) {
                cachedSearch.remove(entry);
                continue;
            }
            if (this.onlyShowWithSpace && !interfaceHasFreeSlots) {
                cachedSearch.remove(entry);
                continue;
            }
            if (this.onlyBrokenRecipes && !interfaceHasBrokenRecipes) {
                cachedSearch.remove(entry);
                continue;
            }
            this.byName.put((Object)entry.getName(), (Object)entry);
            cachedSearch.add(entry);
        }
        this.names.clear();
        this.names.addAll(this.byName.keySet());
        Collections.sort(this.names);
        this.lines.clear();
        this.lines.ensureCapacity(this.names.size() + this.byId.size());
        for (String n : this.names) {
            this.lines.add(n);
            ArrayList clientInventories = new ArrayList(this.byName.get((Object)n));
            Collections.sort(clientInventories);
            this.lines.addAll(clientInventories);
        }
        this.setScrollBar();
    }

    @Unique
    private ClientDCInternalInv crazyae$getById(int length, long id, long sortBy, String string) {
        ClientDCInternalInv o = this.byId.get(id);
        if (o == null) {
            o = new ClientDCInternalInv(length, id, sortBy, string);
            this.byId.put(id, o);
            this.refreshList = true;
        }
        return o;
    }
}

