/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.entitydetector;

import com.lothrazar.cyclicmagic.block.entitydetector.ContainerDetector;
import com.lothrazar.cyclicmagic.block.entitydetector.TileEntityDetector;
import com.lothrazar.cyclicmagic.gui.GuiBaseContainer;
import com.lothrazar.cyclicmagic.gui.button.ButtonTileEntityField;
import com.lothrazar.cyclicmagic.gui.button.ButtonTriggerWrapper;
import com.lothrazar.cyclicmagic.gui.component.GuiSliderInteger;
import com.lothrazar.cyclicmagic.util.UtilChat;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class GuiDetector
extends GuiBaseContainer {
    static final int GUI_ROWS = 2;
    private TileEntityDetector tile;
    private int leftColX;
    private int sizeY;
    private int limitColX;
    private ButtonTileEntityField greaterLessBtn;
    private ButtonTileEntityField entityBtn;
    private GuiSliderInteger sliderX;
    private GuiSliderInteger sliderY;
    private GuiSliderInteger sliderZ;

    public GuiDetector(InventoryPlayer inventoryPlayer, TileEntityDetector tileEntity) {
        super(new ContainerDetector(inventoryPlayer, tileEntity), tileEntity);
        this.tile = tileEntity;
        this.fieldPreviewBtn = TileEntityDetector.Fields.RENDERPARTICLES.ordinal();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int id = 1;
        int vButtonSpacing = 12;
        this.sizeY = 58;
        this.leftColX = 28;
        this.limitColX = this.leftColX + 126;
        this.addPatternButtonAt(id++, this.limitColX, this.sizeY - vButtonSpacing, true, TileEntityDetector.Fields.LIMIT);
        ButtonTileEntityField btnDown = this.addPatternButtonAt(id++, this.limitColX, this.sizeY + vButtonSpacing, false, TileEntityDetector.Fields.LIMIT);
        this.registerButtonDisableTrigger((GuiButton)btnDown, ButtonTriggerWrapper.ButtonTriggerType.EQUAL, TileEntityDetector.Fields.LIMIT.ordinal(), 0);
        int x = this.leftColX + 40;
        int y = 56;
        this.greaterLessBtn = this.addPatternButtonAt(id++, x + 8, y, true, TileEntityDetector.Fields.GREATERTHAN, 60, 20);
        this.entityBtn = this.addPatternButtonAt(id++, 8, y, true, TileEntityDetector.Fields.ENTITYTYPE, 60, 20);
        int MIN = 1;
        int MAX = 32;
        this.sliderX = new GuiSliderInteger(this.tile, id++, this.field_147003_i + 28, this.field_147009_r + 20, 122, 10, MIN, MAX, TileEntityDetector.Fields.RANGEX.ordinal());
        this.sliderX.setTooltip("tile.entity_detector.rangex");
        this.func_189646_b(this.sliderX);
        this.sliderY = new GuiSliderInteger(this.tile, id++, this.field_147003_i + 28, this.field_147009_r + 32, 122, 10, MIN, MAX, TileEntityDetector.Fields.RANGEY.ordinal());
        this.sliderY.setTooltip("tile.entity_detector.rangey");
        this.func_189646_b(this.sliderY);
        this.sliderZ = new GuiSliderInteger(this.tile, id++, this.field_147003_i + 28, this.field_147009_r + 44, 122, 10, MIN, MAX, TileEntityDetector.Fields.RANGEZ.ordinal());
        this.sliderZ.setTooltip("tile.entity_detector.rangez");
        this.func_189646_b(this.sliderZ);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.sliderX.keyTyped(typedChar, keyCode);
        this.sliderY.keyTyped(typedChar, keyCode);
        this.sliderZ.keyTyped(typedChar, keyCode);
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.sliderX.updateScreen();
        this.sliderY.updateScreen();
        this.sliderZ.updateScreen();
    }

    private ButtonTileEntityField addPatternButtonAt(int id, int x, int y, boolean isUp, TileEntityDetector.Fields f) {
        return this.addPatternButtonAt(id, x, y, isUp, f, 15, 10);
    }

    private ButtonTileEntityField addPatternButtonAt(int id, int x, int y, boolean isUp, TileEntityDetector.Fields f, int w, int h) {
        int val = isUp ? 1 : -1;
        ButtonTileEntityField btn = new ButtonTileEntityField(id, this.field_147003_i + x, this.field_147009_r + y, this.tile.func_174877_v(), f.ordinal(), val, w, h);
        btn.field_146126_j = isUp ? "+" : "-";
        String ud = "";
        if (f != TileEntityDetector.Fields.ENTITYTYPE && f != TileEntityDetector.Fields.GREATERTHAN) {
            ud = isUp ? "up" : "down";
        }
        btn.setTooltip("tile.entity_detector." + f.name().toLowerCase() + ud);
        this.func_189646_b(btn);
        return btn;
    }

    private void drawFieldAt(int x, int y, TileEntityDetector.Fields f) {
        this.drawFieldAt(x, y, f.ordinal());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawFieldAt(this.limitColX + 3, this.sizeY, TileEntityDetector.Fields.LIMIT);
        TileEntityDetector.EntityType t = this.tile.getEntityType();
        this.entityBtn.field_146126_j = UtilChat.lang("tile.entity_detector." + t.name().toLowerCase());
        int greater = this.tile.getField(TileEntityDetector.Fields.GREATERTHAN);
        String dir = TileEntityDetector.CompareType.values()[greater].name().toLowerCase();
        this.greaterLessBtn.field_146126_j = UtilChat.lang("tile.entity_detector." + dir);
        super.func_146979_b(mouseX, mouseY);
    }
}

