/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.melter;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeMelter
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public static ArrayList<RecipeMelter> recipes = new ArrayList();
    private NonNullList<ItemStack> recipeInput = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private Fluid fluidResult = null;
    private int fluidSize;
    private int size = 0;
    private String fluidName;

    public RecipeMelter(ItemStack[] in, String fluidName, int fluid) {
        this.fluidName = fluidName;
        this.setFluidResult(FluidRegistry.getFluid((String)fluidName));
        if (in.length > 4 || in.length == 0) {
            throw new IllegalArgumentException("Input array must be length 4 or less");
        }
        for (ItemStack itemStack : in) {
            if (itemStack == null || itemStack.func_190926_b()) continue;
            this.recipeInput.set(this.size, (Object)itemStack);
            ++this.size;
        }
        this.fluidSize = fluid;
        this.setRegistryName(new ResourceLocation("cyclicmagic", "melter_" + UUID.randomUUID().toString() + fluidName));
    }

    public String getFluidString() {
        return this.fluidName;
    }

    public int getSize() {
        return this.size;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        this.sanityCheckInput();
        int countFull = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b()) continue;
            ++countFull;
        }
        if (countFull != this.size) {
            return false;
        }
        boolean match0 = RecipeMelter.recipeSlotMatches(inv.func_70301_a(0), (ItemStack)this.recipeInput.get(0));
        boolean match1 = RecipeMelter.recipeSlotMatches(inv.func_70301_a(1), (ItemStack)this.recipeInput.get(1));
        boolean match2 = RecipeMelter.recipeSlotMatches(inv.func_70301_a(2), (ItemStack)this.recipeInput.get(2));
        boolean match3 = RecipeMelter.recipeSlotMatches(inv.func_70301_a(3), (ItemStack)this.recipeInput.get(3));
        boolean all = match0 && match1 && match2 && match3;
        return all;
    }

    private void sanityCheckInput() {
        for (int i = 0; i < this.recipeInput.size(); ++i) {
            ItemStack s = (ItemStack)this.recipeInput.get(i);
            if (s.func_190926_b() || s.func_77960_j() != Short.MAX_VALUE) continue;
            ItemStack snew = new ItemStack(s.func_77973_b(), 1, 0);
            snew.func_77982_d(s.func_77978_p());
            this.recipeInput.set(i, (Object)snew);
        }
    }

    public static boolean recipeSlotMatches(ItemStack sInvo, ItemStack sRecipe) {
        if (sInvo.func_190926_b() != sRecipe.func_190926_b()) {
            return false;
        }
        return sInvo.func_190916_E() >= sRecipe.func_190916_E() && (sInvo.func_77969_a(sRecipe) || OreDictionary.itemMatches((ItemStack)sInvo, (ItemStack)sRecipe, (boolean)false));
    }

    public boolean tryPayCost(IInventory invoSource, boolean keepOneMinimum) {
        int i;
        int minimum = keepOneMinimum ? 2 : 1;
        for (i = 0; i < this.recipeInput.size(); ++i) {
            if (((ItemStack)this.recipeInput.get(i)).func_190926_b() || invoSource.func_70301_a(i).func_190916_E() >= ((ItemStack)this.recipeInput.get(i)).func_190916_E() + (minimum - 1)) continue;
            return false;
        }
        for (i = 0; i < this.recipeInput.size(); ++i) {
            if (((ItemStack)this.recipeInput.get(i)).func_190926_b()) continue;
            invoSource.func_70298_a(i, ((ItemStack)this.recipeInput.get(i)).func_190916_E());
        }
        return true;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width <= 2 && height <= 2;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public FluidStack getOutputFluid() {
        return new FluidStack(this.fluidResult, this.fluidSize);
    }

    public List<ItemStack> getRecipeInput() {
        return this.recipeInput;
    }

    public int getFluidSize() {
        return this.fluidSize;
    }

    public void setFluidCost(int fluidCost) {
        this.fluidSize = fluidCost;
    }

    public static void initAllRecipes() {
        RecipeMelter.addRecipe(new RecipeMelter(new ItemStack[]{new ItemStack(Blocks.field_150433_aE)}, "water", 100));
        RecipeMelter.addRecipe(new RecipeMelter(new ItemStack[]{new ItemStack(Blocks.field_150432_aD)}, "water", 1000));
        RecipeMelter.addRecipe(new RecipeMelter(new ItemStack[]{new ItemStack(Blocks.field_150343_Z)}, "lava", 1000));
        RecipeMelter.addRecipe(new RecipeMelter(new ItemStack[]{new ItemStack(Items.field_151073_bk)}, "xpjuice", 10));
        RecipeMelter.addRecipe(new RecipeMelter(new ItemStack[]{new ItemStack(Items.field_151103_aS), new ItemStack(Items.field_151078_bh), new ItemStack(Items.field_151070_bp), new ItemStack(Items.field_151016_H)}, "xpjuice", 10));
        RecipeMelter.addRecipe(new RecipeMelter(new ItemStack[]{new ItemStack(Blocks.field_150363_s)}, "amber", 100));
        RecipeMelter.addRecipe(new RecipeMelter(new ItemStack[]{new ItemStack(Blocks.field_150363_s), new ItemStack(Blocks.field_150363_s), new ItemStack(Blocks.field_150395_bd), new ItemStack(Blocks.field_150424_aL)}, "amber", 1000));
        Item amber = Item.func_111206_d((String)"cyclicmagic:crystallized_amber");
        RecipeMelter.addRecipe(new RecipeMelter(new ItemStack[]{new ItemStack(amber)}, "amber", 1000));
        RecipeMelter.addRecipe(new RecipeMelter(new ItemStack[]{new ItemStack(Items.field_151170_bI)}, "poison", 2000));
        RecipeMelter.addRecipe(new RecipeMelter(new ItemStack[]{new ItemStack(Items.field_151071_bq), new ItemStack(Items.field_151071_bq), new ItemStack(Items.field_151078_bh), new ItemStack(Items.field_151078_bh)}, "poison", 500));
        RecipeMelter.addRecipe(new RecipeMelter(new ItemStack[]{new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150343_Z), new ItemStack(Items.field_151166_bC), new ItemStack(amber)}, "crystal", 1000));
        Item crystal = Item.func_111206_d((String)"cyclicmagic:crystallized_obsidian");
        RecipeMelter.addRecipe(new RecipeMelter(new ItemStack[]{new ItemStack(crystal)}, "crystal", 1000));
        Item biomass = Item.func_111206_d((String)"cyclicmagic:peat_biomass");
        RecipeMelter.addRecipe(new RecipeMelter(new ItemStack[]{new ItemStack(biomass)}, "biomass", 1000));
        RecipeMelter.addRecipe(new RecipeMelter(new ItemStack[]{new ItemStack(Blocks.field_150392_bi)}, "biomass", 100));
        RecipeMelter.addRecipe(new RecipeMelter(new ItemStack[]{new ItemStack(Items.field_151172_bF)}, "biomass", 100));
        RecipeMelter.addRecipe(new RecipeMelter(new ItemStack[]{new ItemStack(Blocks.field_150395_bd)}, "biomass", 50));
        RecipeMelter.addRecipe(new RecipeMelter(new ItemStack[]{new ItemStack((Block)Blocks.field_150434_aF)}, "biomass", 50));
        RecipeMelter.addRecipe(new RecipeMelter(new ItemStack[]{new ItemStack((Block)Blocks.field_150329_H)}, "biomass", 25));
        RecipeMelter.addRecipe(new RecipeMelter(new ItemStack[]{new ItemStack(Items.field_151014_N)}, "biomass", 25));
        RecipeMelter.addRecipe(new RecipeMelter(new ItemStack[]{new ItemStack(Items.field_151034_e)}, "biomass", 100));
    }

    public static void addRecipe(RecipeMelter rec) {
        recipes.add(rec);
    }

    public Fluid getFluidResult() {
        return this.fluidResult;
    }

    public void setFluidResult(Fluid fluidResult) {
        this.fluidResult = fluidResult;
    }
}

