/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.gui.component;

import com.lothrazar.cyclicmagic.gui.GuiBaseContainer;
import com.lothrazar.cyclicmagic.util.Const;
import net.minecraft.client.gui.Gui;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyBar {
    private int x = 156;
    private int y = 16;
    private int width = 10;
    private int height = 60;
    private int border = 1;
    private GuiBaseContainer parent;
    private boolean visible = true;

    public EnergyBar(GuiBaseContainer p, boolean alwaysVisible) {
        this.parent = p;
        this.visible = alwaysVisible;
    }

    public EnergyBar(GuiBaseContainer p, int cost) {
        this.parent = p;
        this.visible = cost > 0;
    }

    public EnergyBar setX(int x) {
        this.x = x;
        return this;
    }

    public EnergyBar setY(int y) {
        this.y = y;
        return this;
    }

    public EnergyBar setWidth(int width) {
        this.width = width;
        return this;
    }

    public EnergyBar setHeight(int height) {
        this.height = height;
        return this;
    }

    public EnergyBar setBorder(int border) {
        this.border = border;
        return this;
    }

    public boolean isMouseover(int mouseX, int mouseY) {
        if (!this.visible) {
            return false;
        }
        return this.parent.getGuiLeft() + this.x < mouseX && mouseX < this.parent.getGuiLeft() + this.x + this.width && this.parent.getGuiTop() + this.y < mouseY && mouseY < this.parent.getGuiTop() + this.y + this.height;
    }

    public void draw(IEnergyStorage energy) {
        if (!this.visible || energy == null) {
            return;
        }
        boolean u = false;
        boolean v = false;
        float percent = (float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored();
        int outerLength = this.height + 2 * this.border;
        int outerWidth = this.width + 2 * this.border;
        this.parent.field_146297_k.func_110434_K().func_110577_a(Const.Res.ENERGY_CTR);
        Gui.func_146110_a((int)(this.parent.getGuiLeft() + this.x), (int)(this.parent.getGuiTop() + this.y), (float)((float)u), (float)((float)v), (int)outerWidth, (int)outerLength, (float)outerWidth, (float)outerLength);
        this.parent.field_146297_k.func_110434_K().func_110577_a(Const.Res.ENERGY_INNER);
        Gui.func_146110_a((int)(this.parent.getGuiLeft() + this.x + this.border), (int)(this.parent.getGuiTop() + this.y + this.border), (float)((float)u), (float)((float)v), (int)this.width, (int)((int)((float)this.height * percent)), (float)this.width, (float)this.height);
    }
}

