/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures;

import com.mojang.authlib.GameProfile;
import drzhark.mocreatures.MoCConstants;
import drzhark.mocreatures.client.MoCKeyHandler;
import drzhark.mocreatures.compat.CompatHandler;
import drzhark.mocreatures.compat.datafixes.BlockIDFixer;
import drzhark.mocreatures.compat.datafixes.EntityIDFixer;
import drzhark.mocreatures.compat.datafixes.ItemIDFixer;
import drzhark.mocreatures.compat.tinkers.TinkersConstructIntegration;
import drzhark.mocreatures.dimension.MoCWorldProviderWyvernSkylands;
import drzhark.mocreatures.entity.MoCEntityData;
import drzhark.mocreatures.entity.tameable.MoCPetMapData;
import drzhark.mocreatures.event.MoCEventHooks;
import drzhark.mocreatures.event.MoCEventHooksClient;
import drzhark.mocreatures.event.MoCEventHooksTerrain;
import drzhark.mocreatures.init.MoCCreativeTabs;
import drzhark.mocreatures.init.MoCEntities;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.command.CommandMoCPets;
import drzhark.mocreatures.network.command.CommandMoCSpawn;
import drzhark.mocreatures.network.command.CommandMoCTP;
import drzhark.mocreatures.network.command.CommandMoCreatures;
import drzhark.mocreatures.proxy.MoCProxy;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.UUID;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="mocreatures", name="DrZhark's Mo'Creatures Extended", version="12.4.6", acceptableRemoteVersions="[12.4.6]", dependencies="after:thaumcraft;after:thermalexpansion;after:tconstruct;after:conarm;after:traverse")
public class MoCreatures {
    public static final Logger LOGGER = LogManager.getLogger((String)"mocreatures");
    public static final CreativeTabs tabMoC = new MoCCreativeTabs(CreativeTabs.field_78032_a.length, "MoCreaturesTab");
    public static final String MOC_LOGO = TextFormatting.WHITE + "[" + TextFormatting.AQUA + "DrZhark's Mo'Creatures Extended" + TextFormatting.WHITE + "]";
    @Mod.Instance(value="mocreatures")
    public static MoCreatures instance;
    @SidedProxy(clientSide="drzhark.mocreatures.proxy.MoCProxyClient", serverSide="drzhark.mocreatures.proxy.MoCProxy")
    public static MoCProxy proxy;
    public static GameProfile MOCFAKEPLAYER;
    public static DimensionType WYVERN_SKYLANDS;
    public static int wyvernSkylandsDimensionID;
    public static Object2ObjectLinkedOpenHashMap<String, MoCEntityData> mocEntityMap;
    public static Object2ObjectOpenHashMap<Class<? extends EntityLiving>, MoCEntityData> entityMap;
    public static Int2ObjectOpenHashMap<Class<? extends EntityLiving>> instaSpawnerMap;
    public MoCPetMapData mapData;

    public static boolean isServer() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MoCMessageHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)new MoCEventHooks());
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new MoCEventHooksTerrain());
        proxy.configInit(event);
        if (!MoCreatures.isServer()) {
            MinecraftForge.EVENT_BUS.register((Object)new MoCEventHooksClient());
            MinecraftForge.EVENT_BUS.register((Object)new MoCKeyHandler());
            if (Loader.isModLoaded((String)"tconstruct")) {
                MinecraftForge.EVENT_BUS.register((Object)new TinkersConstructIntegration());
            }
        }
        MoCEntities.registerEntities();
        CompatHandler.preInit();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        wyvernSkylandsDimensionID = MoCreatures.proxy.wyvernDimension;
        MoCreatures.proxy.mocSettingsConfig.save();
        proxy.registerRenderers();
        proxy.registerRenderInformation();
        WYVERN_SKYLANDS = DimensionType.register((String)"Wyvern Skylands", (String)"_wyvern_skylands", (int)wyvernSkylandsDimensionID, MoCWorldProviderWyvernSkylands.class, (boolean)false);
        DimensionManager.registerDimension((int)wyvernSkylandsDimensionID, (DimensionType)WYVERN_SKYLANDS);
        MoCEventHooksTerrain.addBiomeTypes();
        MoCEntities.registerSpawns();
        MoCEventHooksTerrain.buildWorldGenSpawnLists();
        CompatHandler.init();
        ModFixs modFixer = FMLCommonHandler.instance().getDataFixer().init("mocreatures", MoCConstants.DATAFIXER_VERSION.intValue());
        modFixer.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new BlockIDFixer());
        modFixer.registerFix((IFixType)FixTypes.ENTITY, (IFixableData)new EntityIDFixer());
        modFixer.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new ItemIDFixer());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        CompatHandler.postInit();
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        if (MoCreatures.proxy.debug) {
            for (Biome biome : ForgeRegistries.BIOMES.getValuesCollection()) {
                for (Biome.SpawnListEntry entry : biome.func_76747_a(EnumCreatureType.CREATURE)) {
                    LOGGER.info("Creature is spawnable in biome " + biome.field_76791_y + ": " + entry.field_76300_b);
                }
                for (Biome.SpawnListEntry entry : biome.func_76747_a(EnumCreatureType.WATER_CREATURE)) {
                    LOGGER.info("Water Creature is spawnable in biome " + biome.field_76791_y + ": " + entry.field_76300_b);
                }
                for (Biome.SpawnListEntry entry : biome.func_76747_a(EnumCreatureType.MONSTER)) {
                    LOGGER.info("Monster is spawnable in biome " + biome.field_76791_y + ": " + entry.field_76300_b);
                }
                for (Biome.SpawnListEntry entry : biome.func_76747_a(EnumCreatureType.AMBIENT)) {
                    LOGGER.info("Ambient is spawnable in biome " + biome.field_76791_y + ": " + entry.field_76300_b);
                }
            }
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandMoCreatures());
        event.registerServerCommand((ICommand)new CommandMoCTP());
        event.registerServerCommand((ICommand)new CommandMoCPets());
        if (MoCreatures.isServer() && FMLCommonHandler.instance().getMinecraftServerInstance().func_71262_S()) {
            event.registerServerCommand((ICommand)new CommandMoCSpawn());
        }
    }

    static {
        MOCFAKEPLAYER = new GameProfile(UUID.fromString("6E379B45-1111-2222-3333-2FE1A88BCD66"), "[MoCreatures]");
        mocEntityMap = new Object2ObjectLinkedOpenHashMap();
        entityMap = new Object2ObjectOpenHashMap();
        instaSpawnerMap = new Int2ObjectOpenHashMap();
    }
}

