/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public abstract class MoCBlockSlab
extends BlockSlab {
    public static final PropertyEnum<Variant> VARIANT = PropertyEnum.func_177709_a((String)"variant", Variant.class);
    public boolean flammable;

    public MoCBlockSlab(Material material, MapColor mapColor, boolean flammable) {
        super(material, mapColor);
        IBlockState iblockstate = this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Variant.DEFAULT));
        if (!this.func_176552_j()) {
            iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        }
        this.func_180632_j(iblockstate);
        this.field_149783_u = !this.func_176552_j();
        this.func_149672_a(material == Material.field_151575_d ? SoundType.field_185848_a : SoundType.field_185851_d);
        this.flammable = flammable;
    }

    public boolean isFlammable() {
        return this.flammable;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.isFlammable()) {
            return Blocks.field_150344_f.getFlammability(world, pos, face);
        }
        return 0;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.isFlammable()) {
            return Blocks.field_150344_f.getFireSpreadSpeed(world, pos, face);
        }
        return 0;
    }

    public String func_150002_b(int meta) {
        return super.func_149739_a();
    }

    public IProperty<?> func_176551_l() {
        return VARIANT;
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        return Variant.DEFAULT;
    }

    public final IBlockState func_176203_a(int meta) {
        IBlockState blockstate = this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Variant.DEFAULT));
        if (!this.func_176552_j()) {
            blockstate = blockstate.func_177226_a((IProperty)field_176554_a, (Comparable)((meta & 8) != 0 ? BlockSlab.EnumBlockHalf.TOP : BlockSlab.EnumBlockHalf.BOTTOM));
        }
        return blockstate;
    }

    public final int func_176201_c(IBlockState state) {
        int meta = 0;
        if (!this.func_176552_j() && state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            meta |= 8;
        }
        return meta;
    }

    protected BlockStateContainer func_180661_e() {
        if (!this.func_176552_j()) {
            return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, field_176554_a});
        }
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public static class Half
    extends MoCBlockSlab {
        public Half(Material material, MapColor mapColor, boolean flammable) {
            super(material, mapColor, flammable);
        }

        public boolean func_176552_j() {
            return false;
        }
    }

    public static class Double
    extends MoCBlockSlab {
        public Double(Material material, MapColor mapColor, boolean flammable) {
            super(material, mapColor, flammable);
        }

        public boolean func_176552_j() {
            return true;
        }
    }

    public static enum Variant implements IStringSerializable
    {
        DEFAULT;


        public String func_176610_l() {
            return "default";
        }
    }
}

