/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.config;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableSet;
import drzhark.mocreatures.config.MoCConfigCategory;
import drzhark.mocreatures.config.MoCProperty;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.FMLInjectionData;

public class MoCConfiguration {
    public static final String CATEGORY_GENERAL = "general";
    public static final String CATEGORY_BLOCK = "block";
    public static final String CATEGORY_ITEM = "item";
    public static final String ALLOWED_CHARS = "._-";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String CATEGORY_SPLITTER = ".";
    public static final String NEW_LINE;
    public static final CharMatcher allowedProperties;
    private static final Pattern CONFIG_START;
    private static final Pattern CONFIG_END;
    private static MoCConfiguration PARENT;
    private final Object2ObjectLinkedOpenHashMap<String, MoCConfiguration> children = new Object2ObjectLinkedOpenHashMap();
    public Object2ObjectLinkedOpenHashMap<String, MoCConfigCategory> categories = new Object2ObjectLinkedOpenHashMap();
    public String defaultEncoding = "UTF-8";
    public boolean isChild = false;
    File file;
    private boolean caseSensitiveCustomCategories;
    private String fileName = null;
    private boolean changed = false;

    public MoCConfiguration() {
    }

    public MoCConfiguration(File file) {
        this.file = file;
        String basePath = ((File)FMLInjectionData.data()[6]).getAbsolutePath().replace(File.separatorChar, '/').replace("/.", "");
        String path = file.getAbsolutePath().replace(File.separatorChar, '/').replace("/./", "/").replace(basePath, "");
        if (PARENT != null) {
            PARENT.setChild(path, this);
            this.isChild = true;
        } else {
            this.fileName = path;
            this.load();
        }
    }

    public MoCConfiguration(File file, boolean caseSensitiveCustomCategories) {
        this(file);
        this.caseSensitiveCustomCategories = caseSensitiveCustomCategories;
    }

    public MoCConfiguration(File file, boolean caseSensitiveCustomCategories, boolean useNewLine) {
        this(file);
    }

    public static void enableGlobalConfig() {
        PARENT = new MoCConfiguration(new File(Loader.instance().getConfigDir(), "global.cfg"));
        PARENT.load();
    }

    public MoCProperty get(String category, String key) {
        MoCConfigCategory cat = this.getCategory(category);
        if (cat.containsKey(key)) {
            return cat.get(key);
        }
        return null;
    }

    public MoCProperty get(String category, String key, int defaultValue) {
        return this.get(category, key, defaultValue, (String)null);
    }

    public MoCProperty get(String category, String key, int defaultValue, String comment) {
        MoCProperty prop = this.get(category, key, Integer.toString(defaultValue), comment, MoCProperty.Type.INTEGER);
        if (!prop.isIntValue()) {
            prop.set(defaultValue);
        }
        return prop;
    }

    public MoCProperty get(String category, String key, boolean defaultValue) {
        return this.get(category, key, defaultValue, null);
    }

    public MoCProperty get(String category, String key, boolean defaultValue, String comment) {
        MoCProperty prop = this.get(category, key, Boolean.toString(defaultValue), comment, MoCProperty.Type.BOOLEAN);
        if (!prop.isBooleanValue()) {
            prop.set(defaultValue);
        }
        return prop;
    }

    public MoCProperty get(String category, String key, double defaultValue) {
        return this.get(category, key, defaultValue, null);
    }

    public MoCProperty get(String category, String key, double defaultValue, String comment) {
        MoCProperty prop = this.get(category, key, Double.toString(defaultValue), comment, MoCProperty.Type.DOUBLE);
        if (!prop.isDoubleValue()) {
            prop.set(defaultValue);
        }
        return prop;
    }

    public MoCProperty get(String category, String key, String defaultValue) {
        return this.get(category, key, defaultValue, null);
    }

    public MoCProperty get(String category, String key, String defaultValue, String comment) {
        return this.get(category, key, defaultValue, comment, MoCProperty.Type.STRING);
    }

    public MoCProperty get(String category, String key, List<String> defaultValue) {
        return this.get(category, key, defaultValue, null);
    }

    public MoCProperty get(String category, String key, List<String> defaultValue, String comment) {
        return this.get(category, key, defaultValue, comment, MoCProperty.Type.STRING);
    }

    public MoCProperty get(String category, String key, int[] defaultValue) {
        return this.get(category, key, defaultValue, (String)null);
    }

    public MoCProperty get(String category, String key, int[] defaultValue, String comment) {
        ArrayList<String> values = new ArrayList<String>();
        for (int j : defaultValue) {
            values.add(Integer.toString(j));
        }
        MoCProperty prop = this.get(category, key, values, comment, MoCProperty.Type.INTEGER);
        if (!prop.isIntList()) {
            prop.valueList = values;
        }
        return prop;
    }

    public MoCProperty get(String category, String key, double[] defaultValue) {
        return this.get(category, key, defaultValue, null);
    }

    public MoCProperty get(String category, String key, double[] defaultValue, String comment) {
        ArrayList<String> values = new ArrayList<String>();
        for (double v : defaultValue) {
            values.add(Double.toString(v));
        }
        MoCProperty prop = this.get(category, key, values, comment, MoCProperty.Type.DOUBLE);
        if (!prop.isDoubleList()) {
            prop.valueList = values;
        }
        return prop;
    }

    public MoCProperty get(String category, String key, boolean[] defaultValue) {
        return this.get(category, key, defaultValue, null);
    }

    public MoCProperty get(String category, String key, boolean[] defaultValue, String comment) {
        ArrayList<String> values = new ArrayList<String>();
        for (boolean b : defaultValue) {
            values.add(Boolean.toString(b));
        }
        MoCProperty prop = this.get(category, key, values, comment, MoCProperty.Type.BOOLEAN);
        if (!prop.isBooleanList()) {
            prop.valueList = values;
        }
        return prop;
    }

    public MoCProperty get(String category, String key, String defaultValue, String comment, MoCProperty.Type type) {
        MoCConfigCategory cat;
        if (!this.caseSensitiveCustomCategories) {
            category = category.toLowerCase(Locale.ENGLISH);
        }
        if ((cat = this.getCategory(category)).containsKey(key)) {
            MoCProperty prop = cat.get(key);
            if (prop.getType() == null) {
                prop = new MoCProperty(prop.getName(), prop.value, type);
                cat.set(key, prop);
            }
            prop.comment = comment;
            return prop;
        }
        if (defaultValue != null) {
            MoCProperty prop = new MoCProperty(key, defaultValue, type);
            prop.set(defaultValue);
            cat.put(key, prop);
            prop.comment = comment;
            return prop;
        }
        return null;
    }

    public MoCProperty get(String category, String key, List<String> defaultValue, String comment, MoCProperty.Type type) {
        MoCConfigCategory cat;
        if (!this.caseSensitiveCustomCategories) {
            category = category.toLowerCase(Locale.ENGLISH);
        }
        if ((cat = this.getCategory(category)).containsKey(key)) {
            MoCProperty prop = cat.get(key);
            if (prop.getType() == null) {
                prop = new MoCProperty(prop.getName(), prop.getString(), type);
                cat.put(key, prop);
            }
            prop.comment = comment;
            return prop;
        }
        if (defaultValue != null) {
            MoCProperty prop = new MoCProperty(key, defaultValue, type);
            prop.comment = comment;
            cat.put(key, prop);
            return prop;
        }
        return null;
    }

    public boolean hasCategory(String category) {
        return this.categories.get((Object)category) != null;
    }

    public boolean hasKey(String category, String key) {
        MoCConfigCategory cat = (MoCConfigCategory)this.categories.get((Object)category);
        return cat != null && cat.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        block57: {
            if (PARENT != null && PARENT != this) {
                return;
            }
            BufferedReader buffer = null;
            UnicodeInputStreamReader input = null;
            try {
                if (this.file.getParentFile() != null) {
                    this.file.getParentFile().mkdirs();
                }
                if (!this.file.exists() && !this.file.createNewFile()) {
                    return;
                }
                if (!this.file.canRead()) break block57;
                input = new UnicodeInputStreamReader(Files.newInputStream(this.file.toPath(), new OpenOption[0]), this.defaultEncoding);
                this.defaultEncoding = input.getEncoding();
                buffer = new BufferedReader(input);
                MoCConfigCategory currentCat = null;
                MoCProperty.Type type = null;
                ArrayList<String> tmpList = null;
                int lineNum = 0;
                String name = null;
                while (true) {
                    ++lineNum;
                    String line = buffer.readLine();
                    if (line == null) {
                        break;
                    }
                    Matcher start = CONFIG_START.matcher(line);
                    Matcher end = CONFIG_END.matcher(line);
                    if (start.matches()) {
                        this.fileName = start.group(1);
                        this.categories = new Object2ObjectLinkedOpenHashMap();
                        continue;
                    }
                    if (end.matches()) {
                        this.fileName = end.group(1);
                        MoCConfiguration child = new MoCConfiguration();
                        child.categories = this.categories;
                        this.children.put((Object)this.fileName, (Object)child);
                        continue;
                    }
                    int nameStart = -1;
                    int nameEnd = -1;
                    boolean skip = false;
                    boolean quoted = false;
                    block33: for (int i = 0; i < line.length() && !skip; ++i) {
                        if (Character.isLetterOrDigit(line.charAt(i)) || ALLOWED_CHARS.indexOf(line.charAt(i)) != -1 || quoted && line.charAt(i) != '\"') {
                            if (nameStart == -1) {
                                nameStart = i;
                            }
                            nameEnd = i;
                            continue;
                        }
                        if (Character.isWhitespace(line.charAt(i))) continue;
                        switch (line.charAt(i)) {
                            case '#': {
                                skip = true;
                                continue block33;
                            }
                            case '\"': {
                                if (quoted) {
                                    quoted = false;
                                }
                                if (nameStart != -1) continue block33;
                                quoted = true;
                                continue block33;
                            }
                            case '{': {
                                name = line.substring(nameStart, nameEnd + 1);
                                String qualifiedName = MoCConfigCategory.getQualifiedName(name, currentCat);
                                MoCConfigCategory cat = (MoCConfigCategory)this.categories.get((Object)qualifiedName);
                                if (cat == null) {
                                    currentCat = new MoCConfigCategory(name, currentCat);
                                    this.categories.put((Object)qualifiedName, (Object)currentCat);
                                } else {
                                    currentCat = cat;
                                }
                                name = null;
                                continue block33;
                            }
                            case '}': {
                                if (currentCat == null) {
                                    throw new RuntimeException(String.format("Config file corrupt, attepted to close to many categories '%s:%d'", this.fileName, lineNum));
                                }
                                currentCat = currentCat.parent;
                                continue block33;
                            }
                            case '=': {
                                name = line.substring(nameStart, nameEnd + 1);
                                if (currentCat == null) {
                                    throw new RuntimeException(String.format("'%s' has no scope in '%s:%d'", name, this.fileName, lineNum));
                                }
                                MoCProperty prop = new MoCProperty(name, line.substring(i + 1), type, true);
                                i = line.length();
                                currentCat.set(name, prop);
                                continue block33;
                            }
                            case ':': {
                                type = MoCProperty.Type.tryParse(line.substring(nameStart, nameEnd + 1).charAt(0));
                                nameEnd = -1;
                                nameStart = -1;
                                continue block33;
                            }
                            case '<': {
                                if (tmpList != null) {
                                    throw new RuntimeException(String.format("Malformed list MoCProperty \"%s:%d\"", this.fileName, lineNum));
                                }
                                name = line.substring(nameStart, nameEnd + 1);
                                if (currentCat == null) {
                                    throw new RuntimeException(String.format("'%s' has no scope in '%s:%d'", name, this.fileName, lineNum));
                                }
                                tmpList = new ArrayList<String>();
                                if (line.length() > i + 1) {
                                    if (line.charAt(i + 1) == '>') {
                                        ++i;
                                    } else {
                                        line = line.substring(i + 1);
                                        String[] values = line.split("[:>]");
                                        Collections.addAll(tmpList, values);
                                        i = line.length() - 1;
                                    }
                                } else {
                                    skip = true;
                                    continue block33;
                                }
                            }
                            case '>': {
                                if (tmpList == null) {
                                    throw new RuntimeException(String.format("Corrupted config detected! Malformed list MoCProperty \"%s:%d\". Please delete your MoCreatures configs and restart to fix error.", this.fileName, lineNum));
                                }
                                currentCat.set(name, new MoCProperty(name, (List<String>)tmpList, type));
                                name = null;
                                tmpList = null;
                                type = null;
                                continue block33;
                            }
                            default: {
                                throw new RuntimeException(String.format("Corrupted config detected! Unknown character '%s' in '%s:%d'. Please delete your MoCreatures configs and restart to fix error.", Character.valueOf(line.charAt(i)), this.fileName, lineNum));
                            }
                        }
                    }
                    if (quoted) {
                        throw new RuntimeException(String.format("Corrupted config detected! Unmatched quote in '%s:%d'. Please delete your MoCreatures configs and restart to fix error.", this.fileName, lineNum));
                    }
                    if (tmpList == null || skip) continue;
                    tmpList.add(line.trim());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (buffer != null) {
                    try {
                        buffer.close();
                    }
                    catch (IOException iOException) {}
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.resetChangedState();
    }

    public void save() {
        if (PARENT != null && PARENT != this) {
            PARENT.save();
            return;
        }
        try {
            if (this.file.getParentFile() != null) {
                this.file.getParentFile().mkdirs();
            }
            if (!this.file.exists() && !this.file.createNewFile()) {
                return;
            }
            if (this.file.canWrite()) {
                FileOutputStream fos = new FileOutputStream(this.file);
                BufferedWriter buffer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, this.defaultEncoding));
                buffer.write("# Configuration file" + NEW_LINE + NEW_LINE);
                if (this.fileName.contains("MoCreatures.cfg")) {
                    buffer.write("# Valid biome types:" + NEW_LINE);
                    buffer.write("# " + BiomeDictionary.Type.getAll() + NEW_LINE + NEW_LINE);
                }
                if (this.children.isEmpty()) {
                    this.save(buffer);
                } else {
                    for (Map.Entry entry : this.children.entrySet()) {
                        buffer.write("START: \"" + (String)entry.getKey() + "\"" + NEW_LINE);
                        ((MoCConfiguration)entry.getValue()).save(buffer);
                        buffer.write("END: \"" + (String)entry.getKey() + "\"" + NEW_LINE + NEW_LINE);
                    }
                }
                buffer.close();
                fos.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void save(BufferedWriter out) throws IOException {
        for (MoCConfigCategory cat : this.categories.values()) {
            if (cat.isChild()) continue;
            cat.write(out, 0);
            out.newLine();
        }
    }

    public MoCConfigCategory getCategory(String category) {
        MoCConfigCategory ret = (MoCConfigCategory)this.categories.get((Object)category.toLowerCase());
        if (ret == null) {
            if (category.contains(CATEGORY_SPLITTER)) {
                String[] hierarchy = category.split("\\.");
                MoCConfigCategory parent = (MoCConfigCategory)this.categories.get((Object)hierarchy[0]);
                if (parent == null) {
                    parent = new MoCConfigCategory(hierarchy[0]);
                    this.categories.put((Object)parent.getQualifiedName(), (Object)parent);
                    this.changed = true;
                }
                for (int i = 1; i < hierarchy.length; ++i) {
                    String name = MoCConfigCategory.getQualifiedName(hierarchy[i], parent);
                    MoCConfigCategory child = (MoCConfigCategory)this.categories.get((Object)name);
                    if (child == null) {
                        child = new MoCConfigCategory(hierarchy[i], parent);
                        this.categories.put((Object)name, (Object)child);
                        this.changed = true;
                    }
                    ret = child;
                    parent = child;
                }
            } else {
                ret = new MoCConfigCategory(category);
                this.categories.put((Object)category, (Object)ret);
                this.changed = true;
            }
        }
        return ret;
    }

    public void removeCategory(MoCConfigCategory category) {
        for (MoCConfigCategory child : category.getChildren()) {
            this.removeCategory(child);
        }
        if (this.categories.containsKey((Object)category.getQualifiedName())) {
            this.categories.remove((Object)category.getQualifiedName());
            if (category.parent != null) {
                category.parent.removeChild(category);
            }
            this.changed = true;
        }
    }

    public void addCustomCategoryComment(String category, String comment) {
        if (!this.caseSensitiveCustomCategories) {
            category = category.toLowerCase(Locale.ENGLISH);
        }
        this.getCategory(category).setComment(comment);
    }

    private void setChild(String name, MoCConfiguration child) {
        if (!this.children.containsKey((Object)name)) {
            this.children.put((Object)name, (Object)child);
            this.changed = true;
        } else {
            MoCConfiguration old = (MoCConfiguration)this.children.get((Object)name);
            child.categories = old.categories;
            child.fileName = old.fileName;
            old.changed = true;
        }
    }

    public boolean hasChanged() {
        if (this.changed) {
            return true;
        }
        for (MoCConfigCategory cat : this.categories.values()) {
            if (!cat.hasChanged()) continue;
            return true;
        }
        for (MoCConfiguration child : this.children.values()) {
            if (!child.hasChanged()) continue;
            return true;
        }
        return false;
    }

    private void resetChangedState() {
        this.changed = false;
        for (MoCConfigCategory cat : this.categories.values()) {
            cat.resetChangedState();
        }
        for (MoCConfiguration child : this.children.values()) {
            child.resetChangedState();
        }
    }

    public Set<String> getCategoryNames() {
        return ImmutableSet.copyOf((Collection)this.categories.keySet());
    }

    public String getFileName() {
        if (this.file != null) {
            String fullName = this.file.getName();
            return fullName.substring(0, fullName.indexOf(46));
        }
        return "undefined";
    }

    public File getFile() {
        return this.file;
    }

    static {
        allowedProperties = CharMatcher.javaLetterOrDigit().or(CharMatcher.anyOf((CharSequence)ALLOWED_CHARS));
        CONFIG_START = Pattern.compile("START: \"([^\"]+)\"");
        CONFIG_END = Pattern.compile("END: \"([^\"]+)\"");
        PARENT = null;
        NEW_LINE = System.getProperty("line.separator");
    }

    public static class UnicodeInputStreamReader
    extends Reader {
        private final InputStreamReader input;

        public UnicodeInputStreamReader(InputStream source, String encoding) throws IOException {
            String enc = encoding;
            byte[] data = new byte[4];
            PushbackInputStream pbStream = new PushbackInputStream(source, data.length);
            int read = pbStream.read(data, 0, data.length);
            int size = 0;
            int bom16 = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
            int bom24 = bom16 << 8 | data[2] & 0xFF;
            int bom32 = bom24 << 8 | data[3] & 0xFF;
            if (bom24 == 0xEFBBBF) {
                enc = MoCConfiguration.DEFAULT_ENCODING;
                size = 3;
            } else if (bom16 == 65279) {
                enc = "UTF-16BE";
                size = 2;
            } else if (bom16 == 65534) {
                enc = "UTF-16LE";
                size = 2;
            } else if (bom32 == 65279) {
                enc = "UTF-32BE";
                size = 4;
            } else if (bom32 == -131072) {
                enc = "UTF-32LE";
                size = 4;
            }
            if (size < read) {
                pbStream.unread(data, size, read - size);
            }
            this.input = new InputStreamReader((InputStream)pbStream, enc);
        }

        public String getEncoding() {
            return this.input.getEncoding();
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            return this.input.read(cbuf, off, len);
        }

        @Override
        public void close() throws IOException {
            this.input.close();
        }
    }
}

