/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.dimension.chunk;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.init.MoCBlocks;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraftforge.event.ForgeEventFactory;

public class MoCChunkGeneratorWyvernSkylandsOld
implements IChunkGenerator {
    private final World world;
    private final Random rand;
    private final NoiseGeneratorOctaves terrainNoise1;
    private final NoiseGeneratorOctaves terrainNoise2;
    private final NoiseGeneratorOctaves terrainNoise3;
    private final NoiseGeneratorOctaves biomeBlocksNoise;
    private final MapGenCaves mapGenCaves = new MapGenCaves();

    public MoCChunkGeneratorWyvernSkylandsOld(World world, long seed) {
        this.world = world;
        this.rand = new Random(seed);
        this.terrainNoise1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.terrainNoise2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.terrainNoise3 = new NoiseGeneratorOctaves(this.rand, 8);
        this.biomeBlocksNoise = new NoiseGeneratorOctaves(this.rand, 4);
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        ChunkPrimer primer = new ChunkPrimer();
        Biome[] biomes = this.world.func_72959_q().func_76933_b(new Biome[0], chunkX * 16, chunkZ * 16, 16, 16);
        this.setBlocksInChunk(chunkX, chunkZ, primer);
        this.replaceBiomeBlocks(chunkX, chunkZ, primer, biomes);
        this.mapGenCaves.func_186125_a(this.world, chunkX, chunkZ, primer);
        Chunk chunk = new Chunk(this.world, primer, chunkX, chunkZ);
        chunk.func_76603_b();
        return chunk;
    }

    private double[] getNoiseArray(int xOffset, int yOffset, int zOffset, int xSize, int ySize, int zSize) {
        double[] noiseArray = new double[xSize * ySize * zSize];
        double hScale = 1368.824;
        double vScale = 684.412;
        double[] terrainNoiseArray1 = this.terrainNoise1.func_76304_a(null, xOffset, yOffset, zOffset, xSize, ySize, zSize, hScale, vScale, hScale);
        double[] terrainNoiseArray2 = this.terrainNoise2.func_76304_a(null, xOffset, yOffset, zOffset, xSize, ySize, zSize, hScale, vScale, hScale);
        double[] terrainNoiseArray3 = this.terrainNoise3.func_76304_a(null, xOffset, yOffset, zOffset, xSize, ySize, zSize, hScale / 80.0, vScale / 160.0, hScale / 80.0);
        int index = 0;
        for (int x = 0; x < xSize; ++x) {
            for (int z = 0; z < zSize; ++z) {
                for (int y = 0; y < ySize; ++y) {
                    double multiplicator;
                    double terrainNoiseValue1 = terrainNoiseArray1[index] / 512.0;
                    double terrainNoiseValue2 = terrainNoiseArray2[index] / 512.0;
                    double terrainNoiseValue3 = (terrainNoiseArray3[index] / 10.0 + 1.0) / 2.0;
                    double noise = terrainNoiseValue3 < 0.0 ? terrainNoiseValue1 : (terrainNoiseValue3 > 1.0 ? terrainNoiseValue2 : terrainNoiseValue1 + (terrainNoiseValue2 - terrainNoiseValue1) * terrainNoiseValue3);
                    noise -= 8.0;
                    if (y > ySize - 32) {
                        multiplicator = (double)(y - (ySize - 32)) / 31.0;
                        noise = noise * (1.0 - multiplicator) + -30.0 * multiplicator;
                    }
                    if (y < 8) {
                        multiplicator = (double)(8 - y) / 7.0;
                        noise = noise * (1.0 - multiplicator) + -30.0 * multiplicator;
                    }
                    noiseArray[index] = noise;
                    ++index;
                }
            }
        }
        return noiseArray;
    }

    private void setBlocksInChunk(int chunkX, int chunkZ, ChunkPrimer primer) {
        double[] noiseArray = this.getNoiseArray(chunkX * 2, 0, chunkZ * 2, 3, 33, 3);
        for (int i1 = 0; i1 < 2; ++i1) {
            for (int j1 = 0; j1 < 2; ++j1) {
                for (int k1 = 0; k1 < 32; ++k1) {
                    double noiseOffset1 = noiseArray[(i1 * 3 + j1) * 33 + k1];
                    double noiseOffset2 = noiseArray[(i1 * 3 + (j1 + 1)) * 33 + k1];
                    double noiseOffset3 = noiseArray[((i1 + 1) * 3 + j1) * 33 + k1];
                    double noiseOffset4 = noiseArray[((i1 + 1) * 3 + (j1 + 1)) * 33 + k1];
                    double noiseIncreaseScale = 0.25;
                    double noiseIncrease1 = (noiseArray[(i1 * 3 + j1) * 33 + (k1 + 1)] - noiseOffset1) * noiseIncreaseScale;
                    double noiseIncrease2 = (noiseArray[(i1 * 3 + (j1 + 1)) * 33 + (k1 + 1)] - noiseOffset2) * noiseIncreaseScale;
                    double noiseIncrease3 = (noiseArray[((i1 + 1) * 3 + j1) * 33 + (k1 + 1)] - noiseOffset3) * noiseIncreaseScale;
                    double noiseIncrease4 = (noiseArray[((i1 + 1) * 3 + (j1 + 1)) * 33 + (k1 + 1)] - noiseOffset4) * noiseIncreaseScale;
                    for (int l1 = 0; l1 < 4; ++l1) {
                        double noiseIncrease2Scale = 0.125;
                        double noiseValue1 = noiseOffset1;
                        double noiseValue2 = noiseOffset2;
                        double noiseIncrease21 = (noiseOffset3 - noiseOffset1) * noiseIncrease2Scale;
                        double noiseIncrease22 = (noiseOffset4 - noiseOffset2) * noiseIncrease2Scale;
                        for (int i2 = 0; i2 < 8; ++i2) {
                            int x = j1 * 8;
                            int y = k1 * 4 + l1;
                            int z = i2 + i1 * 8;
                            double terrainDensityIncreaseScale = 0.125;
                            double terrainDensity = noiseValue1;
                            double terrainDensityIncrease = (noiseValue2 - noiseValue1) * terrainDensityIncreaseScale;
                            for (int j2 = 0; j2 < 8; ++j2) {
                                primer.func_177855_a(z, y, x, terrainDensity > 0.0 ? MoCBlocks.wyvstone.func_176223_P() : Blocks.field_150350_a.func_176223_P());
                                ++x;
                                terrainDensity += terrainDensityIncrease;
                            }
                            noiseValue1 += noiseIncrease21;
                            noiseValue2 += noiseIncrease22;
                        }
                        noiseOffset1 += noiseIncrease1;
                        noiseOffset2 += noiseIncrease2;
                        noiseOffset3 += noiseIncrease3;
                        noiseOffset4 += noiseIncrease4;
                    }
                }
            }
        }
    }

    private void replaceBiomeBlocks(int xChunk, int zChunk, ChunkPrimer primer, Biome[] biomes) {
        double scale = 0.03125;
        double[] biomeBlocksNoiseArray = this.biomeBlocksNoise.func_76304_a(new double[256], xChunk * 16, zChunk * 16, 0, 16, 16, 1, scale * 2.0, scale * 2.0, scale * 2.0);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                Biome biome = biomes[x + z * 16];
                int biomeBlocksNoiseValue = (int)(biomeBlocksNoiseArray[x + z * 16] / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int biomeBlocksLeft = -1;
                Block topBlock = biome.field_76752_A.func_177230_c();
                Block fillerBlock = biome.field_76753_B.func_177230_c();
                for (int y = 127; y >= 0; --y) {
                    Block block = primer.func_177856_a(x, y, z).func_177230_c();
                    if (block == Blocks.field_150350_a) {
                        biomeBlocksLeft = -1;
                        continue;
                    }
                    if (block != MoCBlocks.wyvstone) continue;
                    if (biomeBlocksLeft == -1) {
                        if (biomeBlocksNoiseValue <= 0) {
                            topBlock = Blocks.field_150350_a;
                            fillerBlock = Blocks.field_150348_b;
                        }
                        biomeBlocksLeft = biomeBlocksNoiseValue;
                        primer.func_177855_a(x, y, z, y >= 0 ? topBlock.func_176223_P() : fillerBlock.func_176223_P());
                        continue;
                    }
                    if (biomeBlocksLeft <= 0) continue;
                    primer.func_177855_a(x, y, z, fillerBlock.func_176223_P());
                    if (--biomeBlocksLeft != 0 || fillerBlock != Blocks.field_150354_m) continue;
                    biomeBlocksLeft = this.rand.nextInt(4);
                    fillerBlock = Blocks.field_150322_A;
                }
            }
        }
    }

    public void func_185931_b(int x, int z) {
        int var14;
        int var13;
        int var12;
        BlockFalling.field_149832_M = true;
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false);
        int var4 = x * 16;
        int var5 = z * 16;
        BlockPos chunkWorldPos = new BlockPos(var4, 0, var5);
        Biome biome = this.world.func_180494_b(chunkWorldPos.func_177982_a(16, 0, 16));
        boolean var11 = false;
        if (!var11 && this.rand.nextInt(2) == 0) {
            var12 = var4 + this.rand.nextInt(16) + 8;
            var13 = this.rand.nextInt(128);
            var14 = var5 + this.rand.nextInt(16) + 8;
            new WorldGenLakes((Block)Blocks.field_150355_j).func_180709_b(this.world, this.rand, new BlockPos(var12, var13, var14));
        }
        if (!var11 && this.rand.nextInt(8) == 0) {
            var12 = var4 + this.rand.nextInt(16) + 8;
            var13 = this.rand.nextInt(this.rand.nextInt(120) + 8);
            var14 = var5 + this.rand.nextInt(16) + 8;
            if (var13 < 63 || this.rand.nextInt(10) == 0) {
                new WorldGenLakes((Block)Blocks.field_150353_l).func_180709_b(this.world, this.rand, new BlockPos(var12, var13, var14));
            }
        }
        biome.func_180624_a(this.world, this.rand, new BlockPos(var4, 0, var5));
        MoCTools.performCustomWorldGenSpawning(this.world, biome, var4 + 8, var5 + 8, 16, 16, this.rand, this.world.func_180494_b(chunkWorldPos).func_76747_a(EnumCreatureType.CREATURE), EntityLiving.SpawnPlacementType.ON_GROUND);
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false);
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return this.world.func_180494_b(pos).func_76747_a(creatureType);
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }
}

