/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.dimension.chunk;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.dimension.chunk.MoCTerrainGenerator;
import drzhark.mocreatures.dimension.worldgen.MoCWorldGenMinable;
import drzhark.mocreatures.init.MoCBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBush;
import net.minecraft.world.gen.feature.WorldGenCactus;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenLiquids;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenReed;

public class MoCTerrainGeneratorWyvernSkylands
extends MoCTerrainGenerator {
    private final NoiseGeneratorOctaves terrainNoise1;
    private final NoiseGeneratorOctaves terrainNoise2;
    private final NoiseGeneratorOctaves terrainNoise3;
    private final NoiseGeneratorOctaves biomeBlocksNoise;
    private final NoiseGeneratorPerlin treeNoise;
    private final MapGenCaves mapGenCaves = new MapGenCaves();

    public MoCTerrainGeneratorWyvernSkylands(World world, Random random) {
        super(world, random);
        this.terrainNoise1 = new NoiseGeneratorOctaves(random, 16);
        this.terrainNoise2 = new NoiseGeneratorOctaves(random, 16);
        this.terrainNoise3 = new NoiseGeneratorOctaves(random, 8);
        this.biomeBlocksNoise = new NoiseGeneratorOctaves(random, 4);
        this.treeNoise = new NoiseGeneratorPerlin(random, 8);
    }

    @Override
    public void generate(int chunkX, int chunkZ, ChunkPrimer primer) {
        Biome[] biomes = this.world.func_72959_q().func_76933_b(new Biome[0], chunkX * 16, chunkZ * 16, 16, 16);
        this.generateStone(chunkX, chunkZ, primer);
        this.replaceBiomeBlocks(chunkX, chunkZ, primer, biomes);
        this.mapGenCaves.func_186125_a(this.world, chunkX, chunkZ, primer);
    }

    private double[] getNoiseArray(int xOffset, int yOffset, int zOffset, int xSize, int ySize, int zSize) {
        double[] noiseArray = new double[xSize * ySize * zSize];
        double hScale = 684.412;
        double vScale = 684.412;
        double[] terrainNoiseArray1 = this.terrainNoise1.func_76304_a(null, xOffset, yOffset, zOffset, xSize, ySize, zSize, hScale, vScale, hScale);
        double[] terrainNoiseArray2 = this.terrainNoise2.func_76304_a(null, xOffset, yOffset, zOffset, xSize, ySize, zSize, hScale, vScale, hScale);
        double[] terrainNoiseArray3 = this.terrainNoise3.func_76304_a(null, xOffset, yOffset, zOffset, xSize, ySize, zSize, hScale / 128.0, vScale / 160.0, hScale / 128.0);
        int index = 0;
        for (int x = 0; x < xSize; ++x) {
            for (int z = 0; z < zSize; ++z) {
                for (int y = 0; y < ySize; ++y) {
                    double multiplicator;
                    double terrainNoiseValue1 = terrainNoiseArray1[index] / 512.0;
                    double terrainNoiseValue2 = terrainNoiseArray2[index] / 512.0;
                    double terrainNoiseValue3 = (terrainNoiseArray3[index] / 10.0 + 1.0) / 2.0;
                    double noise = terrainNoiseValue3 < 0.0 ? terrainNoiseValue1 : (terrainNoiseValue3 > 1.0 ? terrainNoiseValue2 : terrainNoiseValue1 + (terrainNoiseValue2 - terrainNoiseValue1) * terrainNoiseValue3);
                    noise -= 8.0;
                    if (y > ySize - 32) {
                        multiplicator = (double)(y - (ySize - 32)) / 31.0;
                        noise = noise * (1.0 - multiplicator) + -30.0 * multiplicator;
                    }
                    if (y < 8) {
                        multiplicator = (double)(8 - y) / 7.0;
                        noise = noise * (1.0 - multiplicator) + -30.0 * multiplicator;
                    }
                    noiseArray[index] = noise;
                    ++index;
                }
            }
        }
        return noiseArray;
    }

    private void generateStone(int chunkX, int chunkZ, ChunkPrimer primer) {
        double[] noiseArray = this.getNoiseArray(chunkX * 2, 0, chunkZ * 2, 3, 33, 3);
        for (int i1 = 0; i1 < 2; ++i1) {
            for (int j1 = 0; j1 < 2; ++j1) {
                for (int k1 = 0; k1 < 32; ++k1) {
                    double noiseOffset1 = noiseArray[(i1 * 3 + j1) * 33 + k1];
                    double noiseOffset2 = noiseArray[(i1 * 3 + (j1 + 1)) * 33 + k1];
                    double noiseOffset3 = noiseArray[((i1 + 1) * 3 + j1) * 33 + k1];
                    double noiseOffset4 = noiseArray[((i1 + 1) * 3 + (j1 + 1)) * 33 + k1];
                    double[] noiseIncreases = new double[]{(noiseArray[(i1 * 3 + j1) * 33 + (k1 + 1)] - noiseOffset1) * 0.25, (noiseArray[(i1 * 3 + (j1 + 1)) * 33 + (k1 + 1)] - noiseOffset2) * 0.25, (noiseArray[((i1 + 1) * 3 + j1) * 33 + (k1 + 1)] - noiseOffset3) * 0.25, (noiseArray[((i1 + 1) * 3 + (j1 + 1)) * 33 + (k1 + 1)] - noiseOffset4) * 0.25};
                    for (int l1 = 0; l1 < 4; ++l1) {
                        double noiseValue1 = noiseOffset1;
                        double noiseValue2 = noiseOffset2;
                        double noiseIncrease21 = (noiseOffset3 - noiseOffset1) * 0.125;
                        double noiseIncrease22 = (noiseOffset4 - noiseOffset2) * 0.125;
                        for (int i2 = 0; i2 < 8; ++i2) {
                            int x = j1 * 8;
                            int y = k1 * 4 + l1;
                            int z = i2 + i1 * 8;
                            double terrainDensity = noiseValue1;
                            double terrainDensityIncrease = (noiseValue2 - noiseValue1) * 0.125;
                            for (int j2 = 0; j2 < 8; ++j2) {
                                primer.func_177855_a(z, y, x, terrainDensity > 0.0 ? MoCBlocks.wyvstone.func_176223_P() : Blocks.field_150350_a.func_176223_P());
                                ++x;
                                terrainDensity += terrainDensityIncrease;
                            }
                            noiseValue1 += noiseIncrease21;
                            noiseValue2 += noiseIncrease22;
                        }
                        noiseOffset1 += noiseIncreases[0];
                        noiseOffset2 += noiseIncreases[1];
                        noiseOffset3 += noiseIncreases[2];
                        noiseOffset4 += noiseIncreases[3];
                    }
                }
            }
        }
    }

    private void replaceBiomeBlocks(int xChunk, int zChunk, ChunkPrimer primer, Biome[] biomes) {
        double scale = 0.03125;
        double[] biomeBlocksNoiseArray = this.biomeBlocksNoise.func_76304_a(new double[256], xChunk * 16, zChunk * 16, 0, 16, 16, 1, scale, scale, scale);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                Biome biome = biomes[x + z * 16];
                int biomeBlocksNoiseValue = (int)(biomeBlocksNoiseArray[x + z * 16] / 3.0 + 3.0 + this.random.nextDouble() * 0.25);
                int biomeBlocksLeft = -1;
                Block topBlock = biome.field_76752_A.func_177230_c();
                Block fillerBlock = biome.field_76753_B.func_177230_c();
                for (int y = 127; y >= 0; --y) {
                    Block block = primer.func_177856_a(x, y, z).func_177230_c();
                    if (block == Blocks.field_150350_a) {
                        biomeBlocksLeft = -1;
                        continue;
                    }
                    if (block != MoCBlocks.wyvstone) continue;
                    if (biomeBlocksLeft == -1) {
                        if (biomeBlocksNoiseValue <= 0) {
                            topBlock = Blocks.field_150350_a;
                            fillerBlock = MoCBlocks.wyvstone;
                        }
                        biomeBlocksLeft = biomeBlocksNoiseValue;
                        primer.func_177855_a(x, y, z, topBlock.func_176223_P());
                        continue;
                    }
                    if (biomeBlocksLeft <= 0) continue;
                    primer.func_177855_a(x, y, z, fillerBlock.func_176223_P());
                    if (--biomeBlocksLeft != 0 || fillerBlock != MoCBlocks.silverSand) continue;
                    biomeBlocksLeft = this.random.nextInt(4);
                    fillerBlock = MoCBlocks.silverSandstone;
                }
            }
        }
    }

    @Override
    public void populate(int chunkX, int chunkZ) {
        int i;
        BlockPos pos;
        int i2;
        BlockPos pos2;
        int i3;
        BlockPos pos3;
        BlockFalling.field_149832_M = true;
        BlockPos chunkWorldPos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        Biome biome = this.world.func_180494_b(chunkWorldPos.func_177982_a(16, 0, 16));
        Random populateRandom = new Random(this.world.func_72905_C());
        populateRandom.setSeed((long)chunkX * (populateRandom.nextLong() / 2L * 2L + 1L) + (long)chunkZ * (populateRandom.nextLong() / 2L * 2L + 1L) ^ this.world.func_72905_C());
        if (populateRandom.nextInt(4) == 0) {
            pos3 = chunkWorldPos.func_177982_a(populateRandom.nextInt(16) + 8, populateRandom.nextInt(128), populateRandom.nextInt(16) + 8);
            new WorldGenLakes((Block)Blocks.field_150355_j).func_180709_b(this.world, populateRandom, pos3);
        }
        if (populateRandom.nextInt(8) == 0 && ((pos3 = chunkWorldPos.func_177982_a(populateRandom.nextInt(16) + 8, populateRandom.nextInt(populateRandom.nextInt(120) + 8), populateRandom.nextInt(16) + 8)).func_177956_o() < 64 || populateRandom.nextInt(10) == 0)) {
            new WorldGenLakes((Block)Blocks.field_150353_l).func_180709_b(this.world, populateRandom, pos3);
        }
        for (i3 = 0; i3 < 20; ++i3) {
            pos2 = chunkWorldPos.func_177982_a(populateRandom.nextInt(16), 128 + populateRandom.nextInt(64), populateRandom.nextInt(16));
            new MoCWorldGenMinable(MoCBlocks.wyvernIronOre.func_176223_P(), 8).func_180709_b(this.world, populateRandom, pos2);
        }
        for (i3 = 0; i3 < 2; ++i3) {
            pos2 = chunkWorldPos.func_177982_a(populateRandom.nextInt(16), 128 + populateRandom.nextInt(64), populateRandom.nextInt(16));
            new MoCWorldGenMinable(MoCBlocks.wyvernGoldOre.func_176223_P(), 8).func_180709_b(this.world, populateRandom, pos2);
        }
        for (i3 = 0; i3 < 1; ++i3) {
            pos2 = chunkWorldPos.func_177982_a(populateRandom.nextInt(16), 128 + populateRandom.nextInt(64), populateRandom.nextInt(16));
            new MoCWorldGenMinable(MoCBlocks.wyvernDiamondOre.func_176223_P(), 7).func_180709_b(this.world, populateRandom, pos2);
        }
        for (i3 = 0; i3 < 1; ++i3) {
            pos2 = chunkWorldPos.func_177982_a(populateRandom.nextInt(16), 128 + populateRandom.nextInt(64), populateRandom.nextInt(16));
            new MoCWorldGenMinable(MoCBlocks.wyvernLapisOre.func_176223_P(), 6).func_180709_b(this.world, populateRandom, pos2);
        }
        int treeNoiseValue = (int)((this.treeNoise.func_151601_a((double)chunkWorldPos.func_177958_n() * 0.5, (double)chunkWorldPos.func_177952_p() * 0.5) / 8.0 + populateRandom.nextDouble() * 4.0 + 4.0) / 3.0);
        int numTrees = Math.max(0, treeNoiseValue / 2);
        if (populateRandom.nextInt(10) == 0) {
            ++numTrees;
        }
        for (i2 = 0; i2 < numTrees; ++i2) {
            BlockPos xzPos = chunkWorldPos.func_177982_a(populateRandom.nextInt(16) + 8, 0, populateRandom.nextInt(16) + 8);
            BlockPos pos4 = xzPos.func_177982_a(0, this.world.func_189649_b(xzPos.func_177958_n(), xzPos.func_177952_p()), 0);
            WorldGenAbstractTree treeGenerator = biome.func_150567_a(populateRandom);
            treeGenerator.func_180709_b(this.world, populateRandom, pos4);
        }
        for (i2 = 0; i2 < 2; ++i2) {
            pos = chunkWorldPos.func_177982_a(populateRandom.nextInt(16) + 8, populateRandom.nextInt(128), populateRandom.nextInt(16) + 8);
            new WorldGenFlowers(Blocks.field_150327_N, BlockFlower.EnumFlowerType.DANDELION).func_180709_b(this.world, populateRandom, pos);
        }
        if (populateRandom.nextInt(2) == 0) {
            BlockPos pos5 = chunkWorldPos.func_177982_a(populateRandom.nextInt(16) + 8, populateRandom.nextInt(128), populateRandom.nextInt(16) + 8);
            new WorldGenFlowers(Blocks.field_150328_O, BlockFlower.EnumFlowerType.POPPY).func_180709_b(this.world, populateRandom, pos5);
        }
        if (populateRandom.nextInt(4) == 0) {
            BlockPos pos6 = chunkWorldPos.func_177982_a(populateRandom.nextInt(16) + 8, populateRandom.nextInt(128), populateRandom.nextInt(16) + 8);
            new WorldGenBush(Blocks.field_150338_P).func_180709_b(this.world, populateRandom, pos6);
        }
        if (populateRandom.nextInt(8) == 0) {
            BlockPos pos7 = chunkWorldPos.func_177982_a(populateRandom.nextInt(16) + 8, populateRandom.nextInt(128), populateRandom.nextInt(16) + 8);
            new WorldGenBush(Blocks.field_150337_Q).func_180709_b(this.world, populateRandom, pos7);
        }
        for (int i4 = 0; i4 < 10; ++i4) {
            pos = chunkWorldPos.func_177982_a(populateRandom.nextInt(16) + 8, populateRandom.nextInt(128), populateRandom.nextInt(16) + 8);
            new WorldGenReed().func_180709_b(this.world, populateRandom, pos);
        }
        if (populateRandom.nextInt(32) == 0) {
            BlockPos pos8 = chunkWorldPos.func_177982_a(populateRandom.nextInt(16) + 8, populateRandom.nextInt(128), populateRandom.nextInt(16) + 8);
            new WorldGenPumpkin().func_180709_b(this.world, populateRandom, pos8);
        }
        for (i = 0; i < (biome == Biomes.field_76769_d ? 10 : 0); ++i) {
            pos = chunkWorldPos.func_177982_a(populateRandom.nextInt(16) + 8, populateRandom.nextInt(128), populateRandom.nextInt(16) + 8);
            new WorldGenCactus().func_180709_b(this.world, populateRandom, pos);
        }
        for (i = 0; i < 50; ++i) {
            pos = chunkWorldPos.func_177982_a(populateRandom.nextInt(16) + 8, populateRandom.nextInt(populateRandom.nextInt(120) + 8), populateRandom.nextInt(16) + 8);
            new WorldGenLiquids((Block)Blocks.field_150358_i).func_180709_b(this.world, populateRandom, pos);
        }
        for (i = 0; i < 20; ++i) {
            pos = chunkWorldPos.func_177982_a(populateRandom.nextInt(16) + 8, populateRandom.nextInt(populateRandom.nextInt(populateRandom.nextInt(112) + 8) + 8), populateRandom.nextInt(16) + 8);
            new WorldGenLiquids((Block)Blocks.field_150356_k).func_180709_b(this.world, populateRandom, pos);
        }
        for (int x2 = 0; x2 < 16; ++x2) {
            for (int z2 = 0; z2 < 16; ++z2) {
                BlockPos xzPos = chunkWorldPos.func_177982_a(x2 + 8, 0, z2 + 8);
                BlockPos snowPos = this.world.func_175672_r(xzPos);
                if (!this.world.func_175708_f(snowPos, true) || snowPos.func_177956_o() <= 0 || snowPos.func_177956_o() >= 128 || !this.world.func_175623_d(snowPos) || !this.world.func_180495_p(snowPos.func_177982_a(0, -1, 0)).func_185904_a().func_76220_a() || this.world.func_180495_p(snowPos.func_177982_a(0, -1, 0)).func_185904_a() == Material.field_151588_w) continue;
                this.world.func_175656_a(snowPos, Blocks.field_150431_aC.func_176223_P());
            }
        }
        biome.func_180624_a(this.world, this.random, chunkWorldPos);
        MoCTools.performCustomWorldGenSpawning(this.world, biome, chunkWorldPos.func_177958_n(), chunkWorldPos.func_177952_p(), 16, 16, this.random, biome.func_76747_a(EnumCreatureType.CREATURE), EntityLiving.SpawnPlacementType.ON_GROUND);
        BlockFalling.field_149832_M = false;
    }
}

