/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.dimension.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class MoCWorldGenPortal
extends WorldGenerator {
    private final Block pillarBlock;
    private final Block stairBlock;
    private final Block wallBlock;
    private final Block centerBlock;
    private final int pillarMetadata;
    private final int wallMetadata;
    private final int centerMetadata;
    private int stairMetadata;

    public MoCWorldGenPortal(Block pillar, int pillarMeta, Block stair, int stairMeta, Block wall, int wallMeta, Block center, int centerMeta) {
        this.pillarBlock = pillar;
        this.stairBlock = stair;
        this.wallBlock = wall;
        this.centerBlock = center;
        this.pillarMetadata = pillarMeta;
        this.stairMetadata = stairMeta;
        this.wallMetadata = wallMeta;
        this.centerMetadata = centerMeta;
    }

    public void generatePillar(World world, BlockPos pos) {
        for (int nY = pos.func_177956_o(); nY < pos.func_177956_o() + 6; ++nY) {
            world.func_180501_a(new BlockPos(pos.func_177958_n(), nY, pos.func_177952_p()), this.pillarBlock.func_176203_a(this.pillarMetadata), 2);
        }
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        int nZ;
        int nX;
        if (world.func_180495_p(pos).func_177230_c() == this.centerBlock || world.func_180495_p(pos.func_177977_b()).func_177230_c() == this.centerBlock || world.func_180495_p(pos.func_177984_a()).func_177230_c() == this.centerBlock) {
            return true;
        }
        if (world.func_175623_d(pos) || !world.func_175623_d(pos.func_177984_a())) {
            return false;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        this.stairMetadata = 2;
        for (int nZ2 = z - 3; nZ2 < z + 3; nZ2 += 5) {
            for (int nX2 = x - 2; nX2 < x + 2; ++nX2) {
                if (nZ2 > z) {
                    this.stairMetadata = 3;
                }
                world.func_180501_a(new BlockPos(nX2, y + 1, nZ2), this.stairBlock.func_176203_a(this.stairMetadata), 2);
            }
        }
        for (nX = x - 2; nX < x + 2; ++nX) {
            for (nZ = z - 2; nZ < z + 2; ++nZ) {
                world.func_180501_a(new BlockPos(nX, y + 1, nZ), this.wallBlock.func_176203_a(this.wallMetadata), 2);
            }
        }
        for (nX = x - 1; nX < x + 1; ++nX) {
            for (nZ = z - 1; nZ < z + 1; ++nZ) {
                world.func_180501_a(new BlockPos(nX, y + 1, nZ), this.centerBlock.func_176203_a(this.centerMetadata), 2);
            }
        }
        for (int j = x - 3; j < x + 3; j += 5) {
            for (nZ = z - 3; nZ < z + 3; ++nZ) {
                world.func_180501_a(new BlockPos(j, y + 6, nZ), this.wallBlock.func_176203_a(this.wallMetadata), 2);
            }
        }
        this.generatePillar(world, new BlockPos(x - 3, y, z - 3));
        this.generatePillar(world, new BlockPos(x - 3, y, z + 2));
        this.generatePillar(world, new BlockPos(x + 2, y, z - 3));
        this.generatePillar(world, new BlockPos(x + 2, y, z + 2));
        return true;
    }
}

