/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.MoCEntityAnimal;
import drzhark.mocreatures.entity.ai.EntityAIMoverHelperMoC;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.entity.ai.PathNavigateFlyer;
import drzhark.mocreatures.entity.item.MoCEntityEgg;
import drzhark.mocreatures.entity.item.MoCEntityKittyBed;
import drzhark.mocreatures.entity.item.MoCEntityLitterBox;
import drzhark.mocreatures.entity.passive.MoCEntityHorse;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageHealth;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class MoCEntityMob
extends EntityMob
implements IMoCEntity {
    protected static final DataParameter<Boolean> ADULT = EntityDataManager.func_187226_a(MoCEntityMob.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(MoCEntityMob.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(MoCEntityMob.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<String> NAME_STR = EntityDataManager.func_187226_a(MoCEntityMob.class, (DataSerializer)DataSerializers.field_187194_d);
    protected boolean divePending;
    protected String texture = "blank.jpg";
    protected PathNavigate navigatorWater;
    protected PathNavigate navigatorFlyer;
    protected EntityAIWanderMoC2 wander;

    protected MoCEntityMob(World world) {
        super(world);
        this.field_70765_h = new EntityAIMoverHelperMoC((EntityLiving)this);
        this.navigatorWater = new PathNavigateSwimmer((EntityLiving)this, world);
        this.navigatorFlyer = new PathNavigateFlyer((EntityLiving)this, world);
        this.wander = new EntityAIWanderMoC2((EntityCreature)this, 1.0, 80);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.wander);
    }

    @SideOnly(value=Side.CLIENT)
    public String func_70005_c_() {
        String entityString = EntityList.func_75621_b((Entity)this);
        if (!MoCreatures.proxy.verboseEntityNames || entityString == null) {
            return super.func_70005_c_();
        }
        String translationKey = "entity." + entityString + ".verbose.name";
        String translatedString = I18n.func_135052_a((String)translationKey, (Object[])new Object[0]);
        return !translatedString.equals(translationKey) ? translatedString : super.func_70005_c_();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.getMoveSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.getAttackStrenght());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData par1EntityLivingData) {
        this.selectType();
        return super.func_180482_a(difficulty, par1EntityLivingData);
    }

    @Override
    public ResourceLocation getTexture() {
        return MoCreatures.proxy.getModelTexture(this.texture);
    }

    protected double getAttackStrenght() {
        return 2.0;
    }

    @Override
    public void selectType() {
        this.setType(1);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ADULT, (Object)false);
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
        this.field_70180_af.func_187214_a(AGE, (Object)45);
        this.field_70180_af.func_187214_a(NAME_STR, (Object)"");
    }

    @Override
    public int getType() {
        return (Integer)this.field_70180_af.func_187225_a(TYPE);
    }

    @Override
    public void setType(int i) {
        this.field_70180_af.func_187227_b(TYPE, (Object)i);
    }

    @Override
    public boolean getIsAdult() {
        return (Boolean)this.field_70180_af.func_187225_a(ADULT);
    }

    @Override
    public void setAdult(boolean flag) {
        this.field_70180_af.func_187227_b(ADULT, (Object)flag);
    }

    @Override
    public boolean getIsTamed() {
        return false;
    }

    @Override
    public String getPetName() {
        return (String)this.field_70180_af.func_187225_a(NAME_STR);
    }

    @Override
    public void setPetName(String name) {
        this.field_70180_af.func_187227_b(NAME_STR, (Object)String.valueOf(name));
    }

    @Override
    public int getAge() {
        return (Integer)this.field_70180_af.func_187225_a(AGE);
    }

    @Override
    public void setAge(int i) {
        this.field_70180_af.func_187227_b(AGE, (Object)i);
        if (this.getAge() >= this.getMaxAge()) {
            this.setAdult(true);
        }
    }

    @Override
    @Nullable
    public UUID getOwnerId() {
        return null;
    }

    @Override
    public int getOwnerPetId() {
        return 0;
    }

    @Override
    public void setOwnerPetId(int petId) {
    }

    public boolean func_70601_bi() {
        boolean willSpawn = super.func_70601_bi();
        boolean debug = MoCreatures.proxy.debug;
        if (willSpawn && debug) {
            MoCreatures.LOGGER.info("Mob: " + this.func_70005_c_() + " at: " + this.func_180425_c() + " State: " + this.field_70170_p.func_180495_p(this.func_180425_c()) + " biome: " + MoCTools.biomeName(this.field_70170_p, this.func_180425_c()));
        }
        return willSpawn;
    }

    public boolean entitiesToIgnore(Entity entity) {
        if (!(entity instanceof EntityLiving) || entity instanceof EntityMob || entity instanceof MoCEntityEgg) {
            return true;
        }
        return entity instanceof MoCEntityKittyBed || entity instanceof MoCEntityLitterBox || this.getIsTamed() && entity instanceof MoCEntityAnimal && ((MoCEntityAnimal)entity).getIsTamed() || entity instanceof EntityWolf && !MoCreatures.proxy.attackWolves || entity instanceof MoCEntityHorse && !MoCreatures.proxy.attackHorses;
    }

    @Override
    public boolean checkSpawningBiome() {
        return true;
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            float var1;
            if (this.getIsTamed() && this.field_70146_Z.nextInt(200) == 0) {
                MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageHealth(this.func_145782_y(), this.func_110143_aJ()), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
            }
            if (this.isHarmedByDaylight() && this.field_70170_p.func_72935_r() && (var1 = this.func_70013_c()) > 0.5f && this.field_70170_p.func_175710_j(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v))) && this.field_70146_Z.nextFloat() * 30.0f < (var1 - 0.4f) * 2.0f) {
                this.func_70015_d(8);
            }
            if (this.getAge() == 0) {
                this.setAge(this.getMaxAge() - 10);
            }
            if (!this.getIsAdult() && this.field_70146_Z.nextInt(300) == 0) {
                this.setAge(this.getAge() + 1);
                if (this.getAge() >= this.getMaxAge()) {
                    this.setAdult(true);
                }
            }
            if (this.getIsFlying() && this.func_70661_as().func_75500_f() && !this.isMovementCeased() && this.func_70638_az() == null && this.field_70146_Z.nextInt(20) == 0) {
                this.wander.makeUpdate();
            }
        }
        this.func_70661_as().func_75501_e();
        super.func_70636_d();
    }

    protected int getMaxAge() {
        return 100;
    }

    protected boolean isHarmedByDaylight() {
        return false;
    }

    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (!this.field_70170_p.field_72995_K && this.getIsTamed()) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageHealth(this.func_145782_y(), this.func_110143_aJ()), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        Entity entity = damagesource.func_76346_g();
        return this.func_184207_aI() && entity != null && this.func_184215_y(entity) ? false : super.func_70097_a(damagesource, i);
    }

    @Override
    public boolean isFlyer() {
        return false;
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("Adult", this.getIsAdult());
        nbttagcompound.func_74768_a("Edad", this.getAge());
        nbttagcompound.func_74778_a("Name", this.getPetName());
        nbttagcompound.func_74768_a("TypeInt", this.getType());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setAdult(nbttagcompound.func_74767_n("Adult"));
        this.setAge(nbttagcompound.func_74762_e("Edad"));
        this.setPetName(nbttagcompound.func_74779_i("Name"));
        this.setType(nbttagcompound.func_74762_e("TypeInt"));
    }

    public void func_180430_e(float f, float f1) {
        if (!this.isFlyer()) {
            super.func_180430_e(f, f1);
        }
    }

    public boolean func_70617_f_() {
        if (this.isFlyer()) {
            return false;
        }
        return super.func_70617_f_();
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (!this.isFlyer()) {
            super.func_191986_a(strafe, vertical, forward);
            return;
        }
        this.moveEntityWithHeadingFlyer(strafe, vertical, forward);
    }

    public void moveEntityWithHeadingFlyer(float strafe, float vertical, float forward) {
        if (this.func_70613_aW()) {
            this.func_191958_b(strafe, vertical, forward, 0.1f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.9f;
            this.field_70181_x *= (double)0.9f;
            this.field_70179_y *= (double)0.9f;
        } else {
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    @Override
    public void performAnimation(int attackType) {
    }

    public float getMoveSpeed() {
        return 0.7f;
    }

    @Override
    public int nameYOffset() {
        return 0;
    }

    @Override
    public boolean renderName() {
        return MoCreatures.proxy.getDisplayPetName() && this.getPetName() != null && !this.getPetName().isEmpty() && !this.func_184207_aI() && this.func_184187_bx() == null;
    }

    @Override
    public boolean shouldRenderNameAndHealth() {
        return this.getIsTamed() && !this.func_184207_aI() && this.func_184187_bx() == null;
    }

    @Override
    public void makeEntityJump() {
    }

    @Override
    public void makeEntityDive() {
        this.divePending = true;
    }

    protected boolean func_70692_ba() {
        return !this.getIsTamed();
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K && this.getIsTamed() && this.func_110143_aJ() > 0.0f) {
            return;
        }
        super.func_70106_y();
    }

    @Override
    public float getSizeFactor() {
        return 1.0f;
    }

    @Override
    public float getAdjustedYOffset() {
        return 0.0f;
    }

    @Override
    public void setArmorType(int i) {
    }

    @Override
    public float pitchRotationOffset() {
        return 0.0f;
    }

    @Override
    public float rollRotationOffset() {
        return 0.0f;
    }

    @Override
    public float yawRotationOffset() {
        return 0.0f;
    }

    @Override
    public float getAdjustedZOffset() {
        return 0.0f;
    }

    @Override
    public float getAdjustedXOffset() {
        return 0.0f;
    }

    @Override
    public boolean canAttackTarget(EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean getIsSitting() {
        return false;
    }

    @Override
    public boolean isNotScared() {
        return true;
    }

    @Override
    public boolean isMovementCeased() {
        return false;
    }

    @Override
    public boolean shouldAttackPlayers() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    @Override
    public double getDivingDepth() {
        return 0.0;
    }

    @Override
    public boolean isDiving() {
        return false;
    }

    @Override
    public void forceEntityJump() {
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    @Override
    public int maxFlyingHeight() {
        return 5;
    }

    @Override
    public int minFlyingHeight() {
        return 1;
    }

    public PathNavigate func_70661_as() {
        if (this.func_70090_H() && this.isAmphibian()) {
            return this.navigatorWater;
        }
        if (this.isFlyer()) {
            return this.navigatorFlyer;
        }
        return this.field_70699_by;
    }

    public boolean isAmphibian() {
        return false;
    }

    @Override
    public boolean getIsFlying() {
        return this.isFlyer();
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        return type == EnumCreatureType.MONSTER;
    }

    @Override
    public String getClazzString() {
        return EntityList.func_75621_b((Entity)this);
    }

    @Override
    public boolean getIsGhost() {
        return false;
    }

    @Override
    public boolean canRidePlayer() {
        return false;
    }

    @Override
    public boolean startRidingPlayer(EntityPlayer player) {
        if (MoCTools.getEntityRidingPlayer(player) != null) {
            return false;
        }
        boolean ret = super.func_184220_m((Entity)player);
        if (ret) {
            NBTTagCompound tag = player.getEntityData();
            tag.func_186854_a("MOCEntity_Riding_Player", this.func_110124_au());
            return true;
        }
        return false;
    }

    @Override
    public void onStopRidingPlayer() {
    }
}

