/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.ai;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.entity.ai.PathNavigateFlyer;
import drzhark.mocreatures.entity.ai.RandomPositionGeneratorMoCFlyer;
import drzhark.mocreatures.entity.ambient.MoCEntityAnt;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class EntityAIWanderMoC2
extends EntityAIBase {
    private final EntityCreature entity;
    private final double speed;
    private double xPosition;
    private double yPosition;
    private double zPosition;
    private int executionChance;
    private boolean mustUpdate;

    public EntityAIWanderMoC2(EntityCreature creatureIn, double speedIn) {
        this(creatureIn, speedIn, 120);
    }

    public EntityAIWanderMoC2(EntityCreature creatureIn, double speedIn, int chance) {
        this.entity = creatureIn;
        this.speed = speedIn;
        this.executionChance = chance;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        Vec3d vec3;
        if (this.entity instanceof IMoCEntity && ((IMoCEntity)this.entity).isMovementCeased()) {
            return false;
        }
        if (this.entity.func_184207_aI() && !(this.entity instanceof MoCEntityAnt) && !(this.entity instanceof MoCEntityMob)) {
            return false;
        }
        if (!this.mustUpdate) {
            if (this.entity.func_70654_ax() >= 100) {
                return false;
            }
            if (this.entity.func_70681_au().nextInt(this.executionChance) != 0) {
                return false;
            }
        }
        if ((vec3 = RandomPositionGeneratorMoCFlyer.findRandomTarget(this.entity, 10, 12)) != null && this.entity instanceof IMoCEntity && this.entity.func_70661_as() instanceof PathNavigateFlyer) {
            int distToFloor = MoCTools.distanceToFloor((Entity)this.entity);
            int finalYHeight = distToFloor + MathHelper.func_76128_c((double)(vec3.field_72448_b - this.entity.field_70163_u));
            if (finalYHeight < ((IMoCEntity)this.entity).minFlyingHeight()) {
                return false;
            }
            if (finalYHeight > ((IMoCEntity)this.entity).maxFlyingHeight()) {
                return false;
            }
        }
        if (vec3 == null) {
            return false;
        }
        this.xPosition = vec3.field_72450_a;
        this.yPosition = vec3.field_72448_b;
        this.zPosition = vec3.field_72449_c;
        this.mustUpdate = false;
        return true;
    }

    public boolean func_75253_b() {
        return !this.entity.func_70661_as().func_75500_f() && !this.entity.func_184207_aI();
    }

    public void func_75249_e() {
        this.entity.func_70661_as().func_75492_a(this.xPosition, this.yPosition, this.zPosition, this.speed);
    }

    public void makeUpdate() {
        this.mustUpdate = true;
    }

    public void setExecutionChance(int newchance) {
        this.executionChance = newchance;
    }
}

