/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hostile;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCSoundEvents;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class MoCEntityHorseMob
extends MoCEntityMob {
    public int mouthCounter;
    public int textCounter;
    public int standCounter;
    public int tailCounter;
    public int eatingCounter;
    public int wingFlapCounter;

    public MoCEntityHorseMob(World world) {
        super(world);
        this.func_70105_a(1.3964844f, 1.6f);
        this.field_70728_aV = 5;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, true));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    @Override
    public void selectType() {
        if (this.field_70170_p.field_73011_w.func_177500_n()) {
            this.setType(38);
            this.field_70178_ae = true;
        } else if (this.getType() == 0) {
            int j = this.field_70146_Z.nextInt(100);
            if (j <= 40) {
                this.setType(23);
            } else if (j <= 80) {
                this.setType(26);
            } else {
                this.setType(32);
            }
        }
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 23: {
                if (!MoCreatures.proxy.getAnimateTextures()) {
                    return MoCreatures.proxy.getModelTexture("horseundead.png");
                }
                String baseTex = "horseundead";
                int max = 79;
                if (this.field_70146_Z.nextInt(3) == 0) {
                    ++this.textCounter;
                }
                if (this.textCounter < 10) {
                    this.textCounter = 10;
                }
                if (this.textCounter > max) {
                    this.textCounter = 10;
                }
                String iteratorTex = String.valueOf(this.textCounter);
                iteratorTex = iteratorTex.substring(0, 1);
                String decayTex = String.valueOf(this.getAge() / 100);
                decayTex = decayTex.substring(0, 1);
                return MoCreatures.proxy.getModelTexture(baseTex + decayTex + iteratorTex + ".png");
            }
            case 26: {
                return MoCreatures.proxy.getModelTexture("horseskeleton.png");
            }
            case 32: {
                return MoCreatures.proxy.getModelTexture("horsebat.png");
            }
            case 38: {
                if (!MoCreatures.proxy.getAnimateTextures()) {
                    return MoCreatures.proxy.getModelTexture("horsenightmare1.png");
                }
                ++this.textCounter;
                if (this.textCounter < 10) {
                    this.textCounter = 10;
                }
                if (this.textCounter > 59) {
                    this.textCounter = 10;
                }
                String NTA = "horsenightmare";
                String NTB = String.valueOf(this.textCounter);
                NTB = NTB.substring(0, 1);
                String NTC = ".png";
                return MoCreatures.proxy.getModelTexture(NTA + NTB + NTC);
            }
        }
        return MoCreatures.proxy.getModelTexture("horseundead.png");
    }

    protected SoundEvent func_184615_bR() {
        this.openMouth();
        return MoCSoundEvents.ENTITY_HORSE_DEATH_UNDEAD;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        this.openMouth();
        this.stand();
        return MoCSoundEvents.ENTITY_HORSE_HURT_UNDEAD;
    }

    protected SoundEvent func_184639_G() {
        this.openMouth();
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.stand();
        }
        return MoCSoundEvents.ENTITY_HORSE_AMBIENT_UNDEAD;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        if (!blockIn.func_176223_P().func_185904_a().func_76224_d()) {
            SoundType soundtype = blockIn.func_185467_w();
            if (this.field_70170_p.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150431_aC) {
                soundtype = Blocks.field_150431_aC.func_185467_w();
            } else if (soundtype == SoundType.field_185848_a) {
                this.func_184185_a(SoundEvents.field_187732_cw, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
            } else {
                this.func_184185_a(SoundEvents.field_187729_cv, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
            }
        }
    }

    public boolean isOnAir() {
        return this.field_70170_p.func_175623_d(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 0.2)), MathHelper.func_76128_c((double)this.field_70161_v)));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.mouthCounter > 0 && ++this.mouthCounter > 30) {
            this.mouthCounter = 0;
        }
        if (this.standCounter > 0 && ++this.standCounter > 20) {
            this.standCounter = 0;
        }
        if (this.tailCounter > 0 && ++this.tailCounter > 8) {
            this.tailCounter = 0;
        }
        if (this.eatingCounter > 0 && ++this.eatingCounter > 50) {
            this.eatingCounter = 0;
        }
        if (this.wingFlapCounter > 0 && ++this.wingFlapCounter > 20) {
            this.wingFlapCounter = 0;
        }
    }

    @Override
    public boolean isFlyer() {
        return this.getType() == 25 || this.getType() == 32 || this.getType() == 28;
    }

    public boolean isUnicorned() {
        return this.getType() == 24 || this.getType() == 27 || this.getType() == 32;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.isOnAir() && this.isFlyer() && this.field_70146_Z.nextInt(5) == 0) {
            this.wingFlapCounter = 1;
        }
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.moveTail();
        }
        if (!this.isOnAir() && !this.func_184207_aI() && this.field_70146_Z.nextInt(250) == 0) {
            this.stand();
        }
        if (this.field_70170_p.field_72995_K && this.getType() == 38 && this.field_70146_Z.nextInt(50) == 0) {
            this.LavaFX();
        }
        if (this.field_70170_p.field_72995_K && this.getType() == 23 && this.field_70146_Z.nextInt(50) == 0) {
            this.UndeadFX();
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.isFlyer() && this.field_70146_Z.nextInt(500) == 0) {
                this.wingFlap();
            }
            if (!this.isOnAir() && !this.func_184207_aI() && this.field_70146_Z.nextInt(300) == 0) {
                this.setEating();
            }
            if (!this.func_184207_aI() && this.field_70146_Z.nextInt(100) == 0) {
                MoCTools.findMobRider((Entity)this);
            }
        }
    }

    private void openMouth() {
        this.mouthCounter = 1;
    }

    private void moveTail() {
        this.tailCounter = 1;
    }

    private void setEating() {
        this.eatingCounter = 1;
    }

    private void stand() {
        this.standCounter = 1;
    }

    public void wingFlap() {
        this.wingFlapCounter = 1;
    }

    protected Item func_146068_u() {
        boolean flag;
        boolean bl = flag = this.field_70146_Z.nextInt(100) < MoCreatures.proxy.rareItemDropChance;
        if (this.getType() == 32 && MoCreatures.proxy.rareItemDropChance < 25) {
            boolean bl2 = flag = this.field_70146_Z.nextInt(100) < 25;
        }
        if (flag && (this.getType() == 36 || this.getType() >= 50 && this.getType() < 60)) {
            return MoCItems.unicornhorn;
        }
        if (this.getType() == 38 && flag && this.field_70170_p.field_73011_w.func_177500_n()) {
            return MoCItems.heartfire;
        }
        if (this.getType() == 32 && flag) {
            return MoCItems.heartdarkness;
        }
        if (this.getType() == 26) {
            return Items.field_151103_aS;
        }
        if (this.getType() == 23 || this.getType() == 24 || this.getType() == 25) {
            if (flag) {
                return MoCItems.heartundead;
            }
            return Items.field_151078_bh;
        }
        if (this.getType() == 21 || this.getType() == 22) {
            return Items.field_151073_bk;
        }
        return Items.field_151116_aA;
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (entityIn instanceof EntityPlayer && !this.shouldAttackPlayers()) {
            return false;
        }
        if (this.field_70122_E && !this.isOnAir()) {
            this.stand();
        }
        this.openMouth();
        MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_HORSE_ANGRY_UNDEAD);
        return super.func_70652_k(entityIn);
    }

    public void func_70645_a(DamageSource damagesource) {
        super.func_70645_a(damagesource);
        if (this.getType() == 23 || this.getType() == 24 || this.getType() == 25) {
            MoCTools.spawnSlimes(this.field_70170_p, (Entity)this);
        }
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.75 - 0.1;
    }

    @Override
    public boolean func_70601_bi() {
        if (this.field_70163_u < 50.0 && !this.field_70170_p.field_73011_w.func_177500_n()) {
            this.setType(32);
        }
        return super.func_70601_bi();
    }

    public void UndeadFX() {
        MoCreatures.proxy.UndeadFX((Entity)this);
    }

    public void LavaFX() {
        MoCreatures.proxy.LavaFX((Entity)this);
    }

    public EnumCreatureAttribute func_70668_bt() {
        if (this.getType() == 23 || this.getType() == 24 || this.getType() == 25) {
            return EnumCreatureAttribute.UNDEAD;
        }
        return super.func_70668_bt();
    }

    @Override
    protected boolean isHarmedByDaylight() {
        return true;
    }

    @Override
    public int maxFlyingHeight() {
        return 10;
    }

    public void func_184232_k(Entity passenger) {
        double dist = 0.4;
        double newPosX = this.field_70165_t + dist * Math.sin(this.field_70761_aq / 57.29578f);
        double newPosZ = this.field_70161_v - dist * Math.cos(this.field_70761_aq / 57.29578f);
        passenger.func_70107_b(newPosX, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), newPosZ);
        passenger.field_70177_z = this.field_70177_z;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.9f;
    }
}

