/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hostile;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MoCEntityManticore
extends MoCEntityMob {
    public int mouthCounter;
    public int tailCounter;
    public int wingFlapCounter;
    private boolean isPoisoning;
    private int poisontimer;

    public MoCEntityManticore(World world) {
        super(world);
        this.func_70105_a(1.35f, 1.45f);
        this.field_70728_aV = 5;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIManticoreAttack(this, 1.0, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new AIManticoreTarget<EntityPlayer>(this, EntityPlayer.class, false));
        this.field_70715_bh.func_75776_a(3, new AIManticoreTarget<EntityIronGolem>(this, EntityIronGolem.class, true));
    }

    @Override
    public boolean isFlyer() {
        return true;
    }

    @Override
    public float getMoveSpeed() {
        return 0.9f;
    }

    @Override
    public void func_180430_e(float f, float f1) {
    }

    public boolean getIsRideable() {
        return false;
    }

    @Override
    public int maxFlyingHeight() {
        return 10;
    }

    public void func_184232_k(Entity passenger) {
        double dist = -0.1;
        double newPosX = this.field_70165_t + dist * Math.sin(this.field_70761_aq / 57.29578f);
        double newPosZ = this.field_70161_v - dist * Math.cos(this.field_70761_aq / 57.29578f);
        passenger.func_70107_b(newPosX, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), newPosZ);
        passenger.field_70177_z = this.field_70177_z;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.75 - 0.1;
    }

    protected void openMouth() {
        this.mouthCounter = 1;
    }

    private void moveTail() {
        this.tailCounter = 1;
    }

    public boolean isOnAir() {
        return this.field_70170_p.func_175623_d(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 0.2)), MathHelper.func_76128_c((double)this.field_70161_v)));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            if (this.mouthCounter > 0 && ++this.mouthCounter > 30) {
                this.mouthCounter = 0;
            }
            if (this.field_70146_Z.nextInt(250) == 0) {
                this.moveTail();
            }
            if (this.tailCounter > 0 && ++this.tailCounter > 10 && this.field_70146_Z.nextInt(15) == 0) {
                this.tailCounter = 0;
            }
        }
        if (this.isFlyer()) {
            if (this.wingFlapCounter > 0 && ++this.wingFlapCounter > 20) {
                this.wingFlapCounter = 0;
            }
            if (!this.field_70170_p.field_72995_K && this.wingFlapCounter == 5) {
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_FLAP);
            }
        }
        if (this.getIsPoisoning()) {
            ++this.poisontimer;
            if (this.poisontimer == 1) {
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_SCORPION_STING);
            }
            if (this.poisontimer > 50) {
                this.poisontimer = 0;
                this.setPoisoning(false);
            }
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70170_p.field_72995_K && this.isFlyer() && this.isOnAir()) {
            float myFlyingSpeed = MoCTools.getMyMovementSpeed((Entity)this);
            int wingFlapFreq = (int)(25.0f - myFlyingSpeed * 10.0f);
            if (!this.func_184207_aI() || wingFlapFreq < 5) {
                wingFlapFreq = 5;
            }
            if (this.field_70146_Z.nextInt(wingFlapFreq) == 0) {
                this.wingFlap();
            }
        }
        if (!this.func_184207_aI() && this.field_70146_Z.nextInt(200) == 0) {
            MoCTools.findMobRider((Entity)this);
        }
    }

    @Override
    public void makeEntityJump() {
        this.wingFlap();
        super.makeEntityJump();
    }

    public void wingFlap() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.isFlyer() && this.wingFlapCounter == 0) {
            this.wingFlapCounter = 1;
            if (!this.field_70170_p.field_72995_K) {
                MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 3), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
            }
        }
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType == 0) {
            this.setPoisoning(true);
        } else if (animationType == 3) {
            this.wingFlapCounter = 1;
        }
    }

    public boolean getIsPoisoning() {
        return this.isPoisoning;
    }

    public void setPoisoning(boolean flag) {
        if (flag && !this.field_70170_p.field_72995_K) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 0), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        this.isPoisoning = flag;
    }

    public boolean swingingTail() {
        return this.getIsPoisoning() && this.poisontimer < 15;
    }

    protected SoundEvent func_184615_bR() {
        this.openMouth();
        return MoCSoundEvents.ENTITY_LION_DEATH;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        this.openMouth();
        return MoCSoundEvents.ENTITY_LION_HURT;
    }

    protected SoundEvent func_184639_G() {
        this.openMouth();
        return MoCSoundEvents.ENTITY_LION_AMBIENT;
    }

    @Override
    public float getSizeFactor() {
        return 1.4f;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.945f;
    }

    static class AIManticoreTarget<T extends EntityLivingBase>
    extends EntityAINearestAttackableTarget<T> {
        public AIManticoreTarget(MoCEntityManticore manticore, Class<T> classTarget, boolean checkSight) {
            super((EntityCreature)manticore, classTarget, checkSight);
        }

        public boolean func_75250_a() {
            float f = this.field_75299_d.func_70013_c();
            return f < 0.5f && super.func_75250_a();
        }
    }

    static class AIManticoreAttack
    extends EntityAIAttackMelee {
        public AIManticoreAttack(MoCEntityManticore manticore, double speed, boolean useLongMemory) {
            super((EntityCreature)manticore, speed, useLongMemory);
        }

        public boolean func_75253_b() {
            float f = this.field_75441_b.func_70013_c();
            if (f >= 0.5f && this.field_75441_b.func_70681_au().nextInt(100) == 0) {
                this.field_75441_b.func_70624_b(null);
                return false;
            }
            return super.func_75253_b();
        }
    }
}

