/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hostile;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.entity.hostile.MoCEntitySilverSkeleton;
import drzhark.mocreatures.entity.hunter.MoCEntityBear;
import drzhark.mocreatures.entity.hunter.MoCEntityBigCat;
import drzhark.mocreatures.entity.passive.MoCEntityHorse;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.init.MoCSoundEvents;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class MoCEntityWWolf
extends MoCEntityMob {
    public int mouthCounter;
    public int tailCounter;

    public MoCEntityWWolf(World world) {
        super(world);
        this.func_70105_a(0.8f, 1.1f);
        this.setAdult(true);
        this.field_70728_aV = 5;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIWolfAttack(this, 1.0, false));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new AIWolfTarget<EntityPlayer>(this, EntityPlayer.class, false));
        this.field_70715_bh.func_75776_a(3, new AIWolfTarget<EntityIronGolem>(this, EntityIronGolem.class, true));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.5);
    }

    @Override
    public void selectType() {
        if (this.getType() == 0) {
            this.setType(this.field_70146_Z.nextInt(4) + 1);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 1: {
                return MoCreatures.proxy.getModelTexture("wild_wolf_black.png");
            }
            case 3: {
                return MoCreatures.proxy.getModelTexture("wild_wolf_timber.png");
            }
            case 4: {
                return MoCreatures.proxy.getModelTexture("wild_wolf_dark.png");
            }
            case 5: {
                return MoCreatures.proxy.getModelTexture("wild_wolf_bright.png");
            }
        }
        return MoCreatures.proxy.getModelTexture("wild_wolf_classic.png");
    }

    private void openMouth() {
        this.mouthCounter = 1;
    }

    private void moveTail() {
        this.tailCounter = 1;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.moveTail();
        }
        if (this.mouthCounter > 0 && ++this.mouthCounter > 15) {
            this.mouthCounter = 0;
        }
        if (this.tailCounter > 0 && ++this.tailCounter > 8) {
            this.tailCounter = 0;
        }
    }

    @Override
    public boolean checkSpawningBiome() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        Biome biome = MoCTools.biomeKind(this.field_70170_p, new BlockPos(i, j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), k = MathHelper.func_76128_c((double)this.field_70161_v)));
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            this.setType(3);
        }
        this.selectType();
        return true;
    }

    @Override
    public boolean func_70601_bi() {
        return super.func_70601_bi() && this.field_70170_p.func_175678_i(new BlockPos((Entity)this));
    }

    public EntityLivingBase getClosestTarget(Entity entity, double d) {
        double d1 = -1.0;
        EntityLivingBase entityliving = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_186662_g(d));
        for (Entity entity1 : list) {
            if (!(entity1 instanceof EntityLivingBase) || entity1 == entity || entity1 == entity.func_184187_bx() || entity1 == entity.func_184187_bx() || entity1 instanceof EntityPlayer || entity1 instanceof EntityMob || entity1 instanceof MoCEntityBigCat || entity1 instanceof MoCEntityBear || entity1 instanceof EntityCow || entity1 instanceof EntityWolf && !MoCreatures.proxy.attackWolves || entity1 instanceof MoCEntityHorse && !MoCreatures.proxy.attackHorses) continue;
            double d2 = entity1.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (!(d < 0.0) && !(d2 < d * d) || d1 != -1.0 && !(d2 < d1) || !((EntityLivingBase)entity1).func_70685_l(entity)) continue;
            d1 = d2;
            entityliving = (EntityLivingBase)entity1;
        }
        return entityliving;
    }

    protected SoundEvent func_184615_bR() {
        return MoCSoundEvents.ENTITY_WOLF_DEATH;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        this.openMouth();
        return MoCSoundEvents.ENTITY_WOLF_HURT;
    }

    protected SoundEvent func_184639_G() {
        this.openMouth();
        return MoCSoundEvents.ENTITY_WOLF_AMBIENT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        if (!this.getIsAdult()) {
            return null;
        }
        return MoCLootTables.WILD_WOLF;
    }

    public void func_184232_k(Entity passenger) {
        double dist = 0.1;
        double newPosX = this.field_70165_t + dist * Math.sin(this.field_70761_aq / 57.29578f);
        double newPosZ = this.field_70161_v - dist * Math.cos(this.field_70761_aq / 57.29578f);
        passenger.func_70107_b(newPosX, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), newPosZ);
        passenger.field_70177_z = this.field_70177_z;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.75 - 0.1;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && !this.func_184207_aI() && this.field_70146_Z.nextInt(100) == 0) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0));
            for (Entity entity : list) {
                EntityMob entitymob;
                if (!(entity instanceof EntityMob) || (entitymob = (EntityMob)entity).func_184187_bx() != null || !(entitymob instanceof EntitySkeleton) && !(entitymob instanceof EntityZombie) && !(entitymob instanceof MoCEntitySilverSkeleton)) continue;
                entitymob.func_184220_m((Entity)this);
                break;
            }
        }
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.945f;
    }

    static class AIWolfTarget<T extends EntityLivingBase>
    extends EntityAINearestAttackableTarget<T> {
        public AIWolfTarget(MoCEntityWWolf wolf, Class<T> classTarget, boolean checkSight) {
            super((EntityCreature)wolf, classTarget, checkSight);
        }

        public boolean func_75250_a() {
            float f = this.field_75299_d.func_70013_c();
            return f < 0.5f && super.func_75250_a();
        }
    }

    static class AIWolfAttack
    extends EntityAIAttackMelee {
        public AIWolfAttack(MoCEntityWWolf wolf, double speed, boolean useLongMemory) {
            super((EntityCreature)wolf, speed, useLongMemory);
        }

        public boolean func_75253_b() {
            float f = this.field_75441_b.func_70013_c();
            if (f >= 0.5f && this.field_75441_b.func_70681_au().nextInt(100) == 0) {
                this.field_75441_b.func_70624_b(null);
                return false;
            }
            return super.func_75253_b();
        }
    }
}

