/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hunter;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.ai.EntityAIFleeFromPlayer;
import drzhark.mocreatures.entity.ai.EntityAIFollowAdult;
import drzhark.mocreatures.entity.ai.EntityAIFollowOwnerPlayer;
import drzhark.mocreatures.entity.ai.EntityAIPanicMoC;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAnimal;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.init.MoCSoundEvents;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class MoCEntityFox
extends MoCEntityTameableAnimal {
    public MoCEntityFox(World world) {
        super(world);
        this.func_70105_a(0.7f, 0.85f);
        this.setAge(this.field_70146_Z.nextInt(15) + 50);
        this.setAdult(this.field_70146_Z.nextInt(3) != 0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPanicMoC((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFleeFromPlayer((EntityCreature)this, 1.0, 4.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFollowOwnerPlayer((EntityLiving)this, 0.8, 2.0f, 10.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowAdult((EntityLiving)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderMoC2((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.getType() == 0) {
            this.setType(1);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        if (!this.getIsAdult()) {
            if (this.getType() == 2) {
                return MoCreatures.proxy.getModelTexture("fox_snow.png");
            }
            return MoCreatures.proxy.getModelTexture("fox_cub.png");
        }
        if (this.getType() == 2) {
            return MoCreatures.proxy.getModelTexture("fox_snow.png");
        }
        return MoCreatures.proxy.getModelTexture("fox.png");
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (super.func_70097_a(damagesource, i)) {
            Entity entity = damagesource.func_76346_g();
            if (entity != null && this.func_184215_y(entity)) {
                return true;
            }
            if (entity != this && this.isNotScared() && entity instanceof EntityLivingBase && super.shouldAttackPlayers()) {
                this.func_70624_b((EntityLivingBase)entity);
                this.func_70604_c((EntityLivingBase)entity);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        Boolean tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() == MoCItems.rawTurkey) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                MoCTools.tameWithName(player, this);
            }
            this.func_70606_j(this.func_110138_aP());
            if (!this.field_70170_p.field_72995_K && !this.getIsAdult() && this.getAge() < 100) {
                this.setAge(this.getAge() + 1);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public boolean isNotScared() {
        return this.getIsAdult();
    }

    @Override
    public boolean checkSpawningBiome() {
        BlockPos pos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), MathHelper.func_76128_c((double)this.field_70161_v));
        Biome currentbiome = MoCTools.biomeKind(this.field_70170_p, pos);
        try {
            if (BiomeDictionary.hasType((Biome)currentbiome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
                this.setType(2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    protected SoundEvent func_184615_bR() {
        return MoCSoundEvents.ENTITY_FOX_DEATH;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return MoCSoundEvents.ENTITY_FOX_HURT;
    }

    protected SoundEvent func_184639_G() {
        return MoCSoundEvents.ENTITY_FOX_AMBIENT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        if (!this.getIsAdult()) {
            return null;
        }
        return MoCLootTables.FOX;
    }

    protected float func_70599_aP() {
        return 0.3f;
    }

    @Override
    public boolean isMyHealFood(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() == MoCItems.ratRaw;
    }

    @Override
    public int nameYOffset() {
        return -50;
    }

    @Override
    public boolean canAttackTarget(EntityLivingBase entity) {
        return !(entity instanceof MoCEntityFox) && (double)entity.field_70131_O <= 0.7 && (double)entity.field_70130_N <= 0.7;
    }

    @Override
    public boolean isReadyToHunt() {
        return this.getIsAdult() && !this.isMovementCeased();
    }

    @Override
    public boolean isReadyToFollowOwnerPlayer() {
        return !this.isMovementCeased();
    }

    @Override
    public float getSizeFactor() {
        if (this.getIsAdult()) {
            return 0.9f;
        }
        return 0.9f * (float)this.getAge() * 0.01f;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.86f;
    }
}

