/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hunter;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.ai.EntityAIFleeFromPlayer;
import drzhark.mocreatures.entity.ai.EntityAIFollowOwnerPlayer;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.entity.hunter.MoCEntityFox;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAnimal;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemSaddle;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MoCEntityPetScorpion
extends MoCEntityTameableAnimal {
    private static final DataParameter<Boolean> CLIMBING = EntityDataManager.func_187226_a(MoCEntityPetScorpion.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> RIDEABLE = EntityDataManager.func_187226_a(MoCEntityPetScorpion.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HAS_BABIES = EntityDataManager.func_187226_a(MoCEntityPetScorpion.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_SITTING = EntityDataManager.func_187226_a(MoCEntityPetScorpion.class, (DataSerializer)DataSerializers.field_187198_h);
    public int mouthCounter;
    public int armCounter;
    public int transformType;
    private boolean isPoisoning;
    private int poisontimer;
    private int transformCounter;

    public MoCEntityPetScorpion(World world) {
        super(world);
        this.func_70105_a(1.4f, 0.9f);
        this.poisontimer = 0;
        this.setAdult(false);
        this.setAge(20);
        this.setHasBabies(false);
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIPetScorpionAttack(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderMoC2((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFleeFromPlayer((EntityCreature)this, 1.2, 4.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFollowOwnerPlayer((EntityLiving)this, 1.0, 2.0f, 10.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    @Override
    public void selectType() {
        if (this.getType() == 0) {
            this.setType(1);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        boolean saddle = this.getIsRideable();
        if (this.transformCounter != 0 && this.transformType != 0) {
            String newText;
            switch (this.transformType) {
                case 2: {
                    newText = saddle ? "scorpion_cave_saddled.png" : "scorpion_cave.png";
                    break;
                }
                case 3: {
                    newText = saddle ? "scorpion_fire_saddled.png" : "scorpion_fire.png";
                    break;
                }
                case 4: {
                    newText = saddle ? "scorpion_frost_saddled.png" : "scorpion_frost.png";
                    break;
                }
                case 5: {
                    newText = saddle ? "scorpion_undead_saddled.png" : "scorpion_undead.png";
                    break;
                }
                default: {
                    String string = newText = saddle ? "scorpion_undead_saddled.png" : "scorpion_undead.png";
                }
            }
            if (this.transformCounter > 60 && this.transformCounter % 3 == 0) {
                return MoCreatures.proxy.getModelTexture(newText);
            }
        }
        switch (this.getType()) {
            case 1: {
                if (!saddle) {
                    return MoCreatures.proxy.getModelTexture("scorpion_dirt.png");
                }
                return MoCreatures.proxy.getModelTexture("scorpion_dirt_saddled.png");
            }
            case 2: {
                if (!saddle) {
                    return MoCreatures.proxy.getModelTexture("scorpion_cave.png");
                }
                return MoCreatures.proxy.getModelTexture("scorpion_cave_saddled.png");
            }
            case 3: {
                if (!saddle) {
                    return MoCreatures.proxy.getModelTexture("scorpion_fire.png");
                }
                return MoCreatures.proxy.getModelTexture("scorpion_fire_saddled.png");
            }
            case 4: {
                if (!saddle) {
                    return MoCreatures.proxy.getModelTexture("scorpion_frost.png");
                }
                return MoCreatures.proxy.getModelTexture("scorpion_frost_saddled.png");
            }
            case 5: {
                if (!saddle) {
                    return MoCreatures.proxy.getModelTexture("scorpion_undead.png");
                }
                return MoCreatures.proxy.getModelTexture("scorpion_undead_saddled.png");
            }
        }
        return MoCreatures.proxy.getModelTexture("scorpion_dirt.png");
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(HAS_BABIES, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(IS_SITTING, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(RIDEABLE, (Object)Boolean.FALSE);
    }

    @Override
    public boolean isReadyToFollowOwnerPlayer() {
        return !this.isMovementCeased();
    }

    @Override
    public void setRideable(boolean flag) {
        this.field_70180_af.func_187227_b(RIDEABLE, (Object)flag);
    }

    @Override
    public boolean getIsRideable() {
        return (Boolean)this.field_70180_af.func_187225_a(RIDEABLE);
    }

    public boolean getHasBabies() {
        return this.getIsAdult() && (Boolean)this.field_70180_af.func_187225_a(HAS_BABIES) != false;
    }

    public void setHasBabies(boolean flag) {
        this.field_70180_af.func_187227_b(HAS_BABIES, (Object)flag);
    }

    public boolean getIsPoisoning() {
        return this.isPoisoning;
    }

    @Override
    public boolean getIsSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_SITTING);
    }

    public void setSitting(boolean flag) {
        this.field_70180_af.func_187227_b(IS_SITTING, (Object)flag);
    }

    public void setPoisoning(boolean flag) {
        if (flag && !this.field_70170_p.field_72995_K) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 0), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        this.isPoisoning = flag;
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType == 0) {
            this.setPoisoning(true);
        } else if (animationType == 1) {
            this.armCounter = 1;
            this.swingArm();
        } else if (animationType == 3) {
            this.mouthCounter = 1;
        } else if (animationType == 5) {
            this.transformCounter = 1;
        }
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return (Boolean)this.field_70180_af.func_187225_a(CLIMBING);
    }

    public void setBesideClimbableBlock(boolean climbing) {
        this.field_70180_af.func_187227_b(CLIMBING, (Object)climbing);
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (this.poisontimer != 1) {
            MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_SCORPION_ATTACK);
        }
        return super.func_70652_k(entity);
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70122_E && this.func_184187_bx() != null) {
            this.field_70177_z = this.func_184187_bx().field_70177_z;
        }
        if (this.mouthCounter != 0 && this.mouthCounter++ > 50) {
            this.mouthCounter = 0;
        }
        if (this.armCounter != 0 && this.armCounter++ > 24) {
            this.armCounter = 0;
        }
        if (this.getIsPoisoning()) {
            ++this.poisontimer;
            if (this.poisontimer == 1) {
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_SCORPION_STING);
            }
            if (this.poisontimer > 50) {
                this.poisontimer = 0;
                this.setPoisoning(false);
            }
        }
        if (this.transformCounter > 0) {
            if (this.transformCounter == 60) {
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_MAGIC_CONVERSION);
            }
            if (++this.transformCounter > 100) {
                this.transformCounter = 0;
                if (this.transformType != 0) {
                    this.setType(this.transformType);
                }
            }
        }
        super.func_70636_d();
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (super.func_70097_a(damagesource, i)) {
            Entity entity = damagesource.func_76346_g();
            if (!(entity instanceof EntityLivingBase) || entity instanceof EntityPlayer && this.getIsTamed()) {
                return false;
            }
            if (entity != this && super.shouldAttackPlayers() && this.getIsAdult()) {
                this.func_70624_b((EntityLivingBase)entity);
            }
            return true;
        }
        return false;
    }

    protected void func_174815_a(EntityLivingBase entityLivingBaseIn, Entity entityIn) {
        if (!this.getIsPoisoning() && this.field_70146_Z.nextInt(5) == 0 && entityIn instanceof EntityLivingBase) {
            this.setPoisoning(true);
            if (this.getType() <= 1) {
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 300, 1));
            } else if (this.getType() == 2) {
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76431_k, 300, 0));
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76437_t, 300, 0));
            } else if (this.getType() == 3) {
                entityIn.func_70015_d(15);
            } else if (this.getType() == 4) {
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 500, 0));
            } else if (this.getType() == 5) {
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 300, 0));
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 300, 0));
            }
        } else {
            this.swingArm();
        }
        super.func_174815_a(entityLivingBaseIn, entityIn);
    }

    public void swingArm() {
        if (!this.field_70170_p.field_72995_K) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 1), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    public boolean swingingTail() {
        return this.getIsPoisoning() && this.poisontimer < 15;
    }

    protected SoundEvent func_184615_bR() {
        return MoCSoundEvents.ENTITY_SCORPION_DEATH;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return MoCSoundEvents.ENTITY_SCORPION_HURT;
    }

    protected SoundEvent func_184639_G() {
        if (!this.field_70170_p.field_72995_K) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 3), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        return MoCSoundEvents.ENTITY_SCORPION_AMBIENT;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.5f);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        if (!this.getIsAdult()) {
            return null;
        }
        switch (this.getType()) {
            case 1: {
                return MoCLootTables.DIRT_SCORPION;
            }
            case 2: {
                return MoCLootTables.CAVE_SCORPION;
            }
            case 3: {
                return MoCLootTables.FIRE_SCORPION;
            }
            case 4: {
                return MoCLootTables.FROST_SCORPION;
            }
            case 5: {
                return MoCLootTables.UNDEAD_SCORPION;
            }
        }
        return MoCLootTables.DIRT_SCORPION;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        Boolean tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && this.getIsAdult() && !this.getIsRideable() && stack.func_77973_b() instanceof ItemSaddle) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            this.setRideable(true);
            return true;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() == MoCItems.whip && this.getIsTamed() && !this.func_184207_aI()) {
            this.setSitting(!this.getIsSitting());
            this.setIsJumping(false);
            this.func_70661_as().func_75499_g();
            this.func_70624_b(null);
            return true;
        }
        if (!stack.func_190926_b() && this.getIsTamed() && !this.func_184207_aI() && !this.func_184218_aH() && this.transformCounter < 1) {
            if (stack.func_77973_b() == MoCItems.essencedarkness && this.getType() != 2) {
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                if (stack.func_190926_b()) {
                    player.func_184611_a(hand, new ItemStack(Items.field_151069_bo));
                } else {
                    player.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
                }
                this.transform(2);
                return true;
            }
            if (stack.func_77973_b() == MoCItems.essencefire && this.getType() != 3) {
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                if (stack.func_190926_b()) {
                    player.func_184611_a(hand, new ItemStack(Items.field_151069_bo));
                } else {
                    player.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
                }
                this.transform(3);
                return true;
            }
            if (stack.func_77973_b() == MoCItems.essenceIce && this.getType() != 4) {
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                if (stack.func_190926_b()) {
                    player.func_184611_a(hand, new ItemStack(Items.field_151069_bo));
                } else {
                    player.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
                }
                this.transform(4);
                return true;
            }
            if (!stack.func_190926_b() && this.getIsTamed() && !this.func_184207_aI() && !this.func_184218_aH() && this.transformCounter < 1 && stack.func_77973_b() == MoCItems.essenceundead && this.getType() != 5) {
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                if (stack.func_190926_b()) {
                    player.func_184611_a(hand, new ItemStack(Items.field_151069_bo));
                } else {
                    player.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
                }
                this.transform(5);
                return true;
            }
        }
        if (this.func_184187_bx() == null && this.getAge() < 60 && !this.getIsAdult()) {
            if (this.startRidingPlayer(player)) {
                this.field_70177_z = player.field_70177_z;
                if (!this.field_70170_p.field_72995_K && !this.getIsTamed()) {
                    MoCTools.tameWithName(player, this);
                }
            }
            return true;
        }
        if (this.func_184187_bx() != null) {
            MoCTools.playCustomSound((Entity)this, SoundEvents.field_187665_Y);
            this.func_184210_p();
            this.field_70159_w = player.field_70159_w * 5.0;
            this.field_70181_x = player.field_70181_x / 2.0 + 0.5;
            this.field_70179_y = player.field_70179_y * 5.0;
            return true;
        }
        if (this.getIsRideable() && this.getIsTamed() && this.getIsAdult() && !this.func_184207_aI()) {
            player.field_70177_z = this.field_70177_z;
            player.field_70125_A = this.field_70125_A;
            if (!this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setHasBabies(nbttagcompound.func_74767_n("Babies"));
        this.setRideable(nbttagcompound.func_74767_n("Saddled"));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("Babies", this.getHasBabies());
        nbttagcompound.func_74757_a("Saddled", this.getIsRideable());
    }

    @Override
    public int nameYOffset() {
        int n = (int)(1.0 - (double)this.getAge() * 0.8);
        if (n < -60) {
            n = -60;
        }
        if (this.getIsAdult()) {
            n = -60;
        }
        if (this.getIsSitting()) {
            n = (int)((double)n * 0.8);
        }
        return n;
    }

    @Override
    protected boolean isMyHealFood(ItemStack itemstack) {
        return itemstack.func_77973_b() == MoCItems.ratRaw || itemstack.func_77973_b() == MoCItems.ratCooked;
    }

    public int func_70627_aG() {
        return 300;
    }

    public void func_180430_e(float f, float f1) {
    }

    public boolean func_70067_L() {
        return !this.func_184207_aI();
    }

    @Override
    public boolean rideableEntity() {
        return true;
    }

    @Override
    public boolean isMovementCeased() {
        return this.func_184207_aI() || this.getIsSitting();
    }

    @Override
    public void dropMyStuff() {
        MoCTools.dropSaddle(this, this.field_70170_p);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    @Override
    public float getAdjustedYOffset() {
        return 0.2f;
    }

    @Override
    public int getMaxAge() {
        return 120;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.75 - 0.15;
    }

    public double func_70033_W() {
        if (this.func_184187_bx() instanceof EntityPlayer && this.func_184187_bx() == MoCreatures.proxy.getPlayer() && this.field_70170_p.field_72995_K) {
            return 0.1f;
        }
        if (this.func_184187_bx() instanceof EntityPlayer && this.field_70170_p.field_72995_K) {
            return super.func_70033_W() + (double)0.1f;
        }
        return super.func_70033_W();
    }

    public void func_184232_k(Entity passenger) {
        double dist = 0.2;
        double newPosX = this.field_70165_t + dist * Math.sin(this.field_70761_aq / 57.29578f);
        double newPosZ = this.field_70161_v - dist * Math.cos(this.field_70761_aq / 57.29578f);
        passenger.func_70107_b(newPosX, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), newPosZ);
    }

    @Override
    public boolean isNotScared() {
        return this.getIsTamed();
    }

    public void transform(int tType) {
        if (!this.field_70170_p.field_72995_K) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), tType), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        this.transformType = tType;
        if (this.transformType != 0) {
            this.transformCounter = 1;
        }
    }

    @Override
    public boolean isReadyToHunt() {
        return this.getIsAdult() && !this.isMovementCeased();
    }

    @Override
    public boolean canAttackTarget(EntityLivingBase entity) {
        return !(entity instanceof MoCEntityFox) && (double)entity.field_70131_O <= 1.0 && (double)entity.field_70130_N <= 1.0;
    }

    static class AIPetScorpionAttack
    extends EntityAIAttackMelee {
        public AIPetScorpionAttack(MoCEntityPetScorpion scorpion) {
            super((EntityCreature)scorpion, 1.0, true);
        }

        public boolean func_75253_b() {
            float f = this.field_75441_b.func_70013_c();
            if (f >= 0.5f && this.field_75441_b.func_70681_au().nextInt(100) == 0) {
                this.field_75441_b.func_70624_b(null);
                return false;
            }
            return super.func_75253_b();
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.0f + attackTarget.field_70130_N;
        }
    }
}

